/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.util.Assert;

public class AsyncEventQueueFactoryBean
extends AbstractWANComponentFactoryBean<AsyncEventQueue> {
    private AsyncEventListener asyncEventListener;
    private AsyncEventQueue asyncEventQueue;
    private Boolean batchConflationEnabled;
    private Boolean diskSynchronous;
    private Boolean parallel;
    private Boolean persistent;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private Integer dispatcherThreads;
    private Integer maximumQueueMemory;
    private String diskStoreReference;
    private String orderPolicy;

    public AsyncEventQueueFactoryBean(Cache cache) {
        this(cache, null);
    }

    public AsyncEventQueueFactoryBean(Cache cache, AsyncEventListener asyncEventListener) {
        super(cache);
        this.setAsyncEventListener(asyncEventListener);
    }

    @Override
    public AsyncEventQueue getObject() throws Exception {
        return this.asyncEventQueue;
    }

    @Override
    public Class<?> getObjectType() {
        return AsyncEventQueue.class;
    }

    @Override
    protected void doInit() {
        AsyncEventQueueFactory asyncEventQueueFactory;
        Assert.notNull((Object)this.asyncEventListener, (String)"The AsyncEventListener cannot be null.");
        AsyncEventQueueFactory asyncEventQueueFactory2 = asyncEventQueueFactory = this.factory != null ? (AsyncEventQueueFactory)this.factory : this.cache.createAsyncEventQueueFactory();
        if (this.batchSize != null) {
            asyncEventQueueFactory.setBatchSize(this.batchSize.intValue());
        }
        if (this.batchTimeInterval != null) {
            asyncEventQueueFactory.setBatchTimeInterval(this.batchTimeInterval.intValue());
        }
        if (this.batchConflationEnabled != null) {
            asyncEventQueueFactory.setBatchConflationEnabled(this.batchConflationEnabled.booleanValue());
        }
        if (this.dispatcherThreads != null) {
            asyncEventQueueFactory.setDispatcherThreads(this.dispatcherThreads.intValue());
        }
        if (this.diskStoreReference != null) {
            asyncEventQueueFactory.setDiskStoreName(this.diskStoreReference);
        }
        if (this.diskSynchronous != null) {
            asyncEventQueueFactory.setDiskSynchronous(this.diskSynchronous.booleanValue());
        }
        if (this.maximumQueueMemory != null) {
            asyncEventQueueFactory.setMaximumQueueMemory(this.maximumQueueMemory.intValue());
        }
        asyncEventQueueFactory.setParallel(this.isParallelEventQueue());
        if (this.orderPolicy != null) {
            Assert.isTrue((boolean)this.isSerialEventQueue(), (String)"Order Policy cannot be used with a Parallel Event Queue.");
            Assert.isTrue((boolean)VALID_ORDER_POLICIES.contains(this.orderPolicy.toUpperCase()), (String)String.format("The value of Order Policy '$1%s' is invalid.", this.orderPolicy));
            asyncEventQueueFactory.setOrderPolicy(GatewaySender.OrderPolicy.valueOf((String)this.orderPolicy.toUpperCase()));
        }
        if (this.persistent != null) {
            asyncEventQueueFactory.setPersistent(this.persistent.booleanValue());
        }
        this.asyncEventQueue = asyncEventQueueFactory.create(this.getName(), this.asyncEventListener);
    }

    @Override
    public void destroy() throws Exception {
        if (!this.cache.isClosed()) {
            try {
                this.asyncEventListener.close();
            }
            catch (CacheClosedException cacheClosedException) {
                // empty catch block
            }
        }
    }

    public final void setAsyncEventListener(AsyncEventListener listener) {
        Assert.state((this.asyncEventQueue == null ? 1 : 0) != 0, (String)"Setting an AsyncEventListener is not allowed once the AsyncEventQueue has been created.");
        this.asyncEventListener = listener;
    }

    public void setAsyncEventQueue(AsyncEventQueue asyncEventQueue) {
        this.asyncEventQueue = asyncEventQueue;
    }

    public void setBatchConflationEnabled(Boolean batchConflationEnabled) {
        this.batchConflationEnabled = batchConflationEnabled;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchTimeInterval(Integer batchTimeInterval) {
        this.batchTimeInterval = batchTimeInterval;
    }

    public void setDiskStoreRef(String diskStoreRef) {
        this.diskStoreReference = diskStoreRef;
    }

    public void setDiskSynchronous(Boolean diskSynchronous) {
        this.diskSynchronous = diskSynchronous;
    }

    public void setDispatcherThreads(Integer dispatcherThreads) {
        this.dispatcherThreads = dispatcherThreads;
    }

    public void setMaximumQueueMemory(Integer maximumQueueMemory) {
        this.maximumQueueMemory = maximumQueueMemory;
    }

    public void setOrderPolicy(String orderPolicy) {
        this.orderPolicy = orderPolicy;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public boolean isSerialEventQueue() {
        return !this.isParallelEventQueue();
    }

    public boolean isParallelEventQueue() {
        return Boolean.TRUE.equals(this.parallel);
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }
}

