/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.internal.datasource.ConfigProperty;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.CustomEditorRegisteringBeanFactoryPostProcessor;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.config.PdxDiskStoreAwareBeanFactoryPostProcessor;
import org.springframework.data.gemfire.config.support.GemfireFeature;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class CacheParser
extends AbstractSingleBeanDefinitionParser {
    CacheParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return CacheFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element gatewayConflictResolver;
        Element txWriter;
        super.doParse(element, builder);
        this.registerGemFireBeanFactoryPostProcessors(this.getRegistry(parserContext));
        ParsingUtils.setPropertyValue(element, builder, "cache-xml-location", "cacheXml");
        ParsingUtils.setPropertyReference(element, builder, "properties-ref", "properties");
        ParsingUtils.setPropertyValue(element, builder, "use-bean-factory-locator");
        ParsingUtils.setPropertyValue(element, builder, "close");
        ParsingUtils.setPropertyValue(element, builder, "copy-on-read");
        ParsingUtils.setPropertyValue(element, builder, "critical-heap-percentage");
        ParsingUtils.setPropertyValue(element, builder, "eviction-heap-percentage");
        ParsingUtils.setPropertyValue(element, builder, "enable-auto-reconnect");
        ParsingUtils.setPropertyValue(element, builder, "lock-lease");
        ParsingUtils.setPropertyValue(element, builder, "lock-timeout");
        ParsingUtils.setPropertyValue(element, builder, "message-sync-interval");
        this.parsePdxDiskStore(element, parserContext, builder);
        ParsingUtils.setPropertyValue(element, builder, "pdx-ignore-unread-fields");
        ParsingUtils.setPropertyValue(element, builder, "pdx-read-serialized");
        ParsingUtils.setPropertyValue(element, builder, "pdx-persistent");
        ParsingUtils.setPropertyReference(element, builder, "pdx-serializer-ref", "pdxSerializer");
        ParsingUtils.setPropertyValue(element, builder, "search-timeout");
        ParsingUtils.setPropertyValue(element, builder, "use-cluster-configuration");
        List txListeners = DomUtils.getChildElementsByTagName((Element)element, (String)"transaction-listener");
        if (!CollectionUtils.isEmpty((Collection)txListeners)) {
            ManagedList transactionListeners = new ManagedList();
            for (Element txListener : txListeners) {
                transactionListeners.add(ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, txListener, builder));
            }
            builder.addPropertyValue("transactionListeners", (Object)transactionListeners);
        }
        if ((txWriter = DomUtils.getChildElementByTagName((Element)element, (String)"transaction-writer")) != null) {
            builder.addPropertyValue("transactionWriter", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, txWriter, builder));
        }
        if ((gatewayConflictResolver = DomUtils.getChildElementByTagName((Element)element, (String)"gateway-conflict-resolver")) != null) {
            ParsingUtils.throwExceptionWhenGemFireFeatureUnavailable(GemfireFeature.WAN, element.getLocalName(), "gateway-conflict-resolver", parserContext);
            builder.addPropertyValue("gatewayConflictResolver", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, gatewayConflictResolver, builder));
        }
        this.parseDynamicRegionFactory(element, builder);
        this.parseJndiBindings(element, builder);
    }

    protected BeanDefinitionRegistry getRegistry(ParserContext parserContext) {
        return parserContext.getRegistry();
    }

    void registerGemFireBeanFactoryPostProcessors(BeanDefinitionRegistry registry) {
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(CustomEditorRegisteringBeanFactoryPostProcessor.class).getBeanDefinition(), (BeanDefinitionRegistry)registry);
    }

    private void parsePdxDiskStore(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "pdx-disk-store", "pdxDiskStoreName");
        String pdxDiskStoreName = element.getAttribute("pdx-disk-store");
        if (!StringUtils.isEmpty((Object)pdxDiskStoreName)) {
            this.registerPdxDiskStoreAwareBeanFactoryPostProcessor(this.getRegistry(parserContext), pdxDiskStoreName);
        }
    }

    void registerPdxDiskStoreAwareBeanFactoryPostProcessor(BeanDefinitionRegistry registry, String pdxDiskStoreName) {
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)this.createPdxDiskStoreAwareBeanFactoryPostProcessorBeanDefinition(pdxDiskStoreName), (BeanDefinitionRegistry)registry);
    }

    private AbstractBeanDefinition createPdxDiskStoreAwareBeanFactoryPostProcessorBeanDefinition(String pdxDiskStoreName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(PdxDiskStoreAwareBeanFactoryPostProcessor.class);
        builder.addConstructorArgValue((Object)pdxDiskStoreName);
        return builder.getBeanDefinition();
    }

    private void parseDynamicRegionFactory(Element element, BeanDefinitionBuilder builder) {
        Element dynamicRegionFactory = DomUtils.getChildElementByTagName((Element)element, (String)"dynamic-region-factory");
        if (dynamicRegionFactory != null) {
            BeanDefinitionBuilder dynamicRegionSupport = this.buildDynamicRegionSupport(dynamicRegionFactory);
            this.postProcessDynamicRegionSupport(element, dynamicRegionSupport);
            builder.addPropertyValue("dynamicRegionSupport", (Object)dynamicRegionSupport.getBeanDefinition());
        }
    }

    private BeanDefinitionBuilder buildDynamicRegionSupport(Element dynamicRegionFactory) {
        if (dynamicRegionFactory != null) {
            String registerInterest;
            String persistent;
            BeanDefinitionBuilder dynamicRegionSupport = BeanDefinitionBuilder.genericBeanDefinition(CacheFactoryBean.DynamicRegionSupport.class);
            String diskDirectory = dynamicRegionFactory.getAttribute("disk-dir");
            if (StringUtils.hasText((String)diskDirectory)) {
                dynamicRegionSupport.addPropertyValue("diskDir", (Object)diskDirectory);
            }
            if (StringUtils.hasText((String)(persistent = dynamicRegionFactory.getAttribute("persistent")))) {
                dynamicRegionSupport.addPropertyValue("persistent", (Object)persistent);
            }
            if (StringUtils.hasText((String)(registerInterest = dynamicRegionFactory.getAttribute("register-interest")))) {
                dynamicRegionSupport.addPropertyValue("registerInterest", (Object)registerInterest);
            }
            return dynamicRegionSupport;
        }
        return null;
    }

    protected void postProcessDynamicRegionSupport(Element element, BeanDefinitionBuilder dynamicRegionSupport) {
    }

    private void parseJndiBindings(Element element, BeanDefinitionBuilder builder) {
        List jndiBindings = DomUtils.getChildElementsByTagName((Element)element, (String)"jndi-binding");
        if (!CollectionUtils.isEmpty((Collection)jndiBindings)) {
            ManagedList jndiDataSources = new ManagedList(jndiBindings.size());
            for (Element jndiBinding : jndiBindings) {
                BeanDefinitionBuilder jndiDataSource = BeanDefinitionBuilder.genericBeanDefinition(CacheFactoryBean.JndiDataSource.class);
                NamedNodeMap attributes = jndiBinding.getAttributes();
                ManagedMap jndiAttributes = new ManagedMap(attributes.getLength());
                int length = attributes.getLength();
                for (int index = 0; index < length; ++index) {
                    Attr attribute = (Attr)attributes.item(index);
                    jndiAttributes.put((Object)attribute.getLocalName(), (Object)attribute.getValue());
                }
                jndiDataSource.addPropertyValue("attributes", (Object)jndiAttributes);
                List jndiProps = DomUtils.getChildElementsByTagName((Element)jndiBinding, (String)"jndi-prop");
                if (!CollectionUtils.isEmpty((Collection)jndiProps)) {
                    ManagedList props = new ManagedList(jndiProps.size());
                    for (Element jndiProp : jndiProps) {
                        String key = jndiProp.getAttribute("key");
                        String type = jndiProp.getAttribute("type");
                        String value = jndiProp.getTextContent();
                        type = StringUtils.hasText((String)type) ? type : String.class.getName();
                        props.add((Object)BeanDefinitionBuilder.genericBeanDefinition(ConfigProperty.class).addConstructorArgValue((Object)key).addConstructorArgValue((Object)value).addConstructorArgValue((Object)type).getBeanDefinition());
                    }
                    jndiDataSource.addPropertyValue("props", (Object)props);
                }
                jndiDataSources.add((Object)jndiDataSource.getBeanDefinition());
            }
            builder.addPropertyValue("jndiDataSources", (Object)jndiDataSources);
        }
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)name)) {
            name = "gemfireCache";
            parserContext.getRegistry().registerAlias(name, "gemfire-cache");
        }
        return name;
    }
}

