/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.springframework.data.gemfire.config.annotation.GatewaySenderConfigurer;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.data.gemfire.wan.GatewaySenderWrapper;
import org.springframework.data.gemfire.wan.OrderPolicyType;
import org.springframework.util.StringUtils;

public class GatewaySenderFactoryBean
extends AbstractWANComponentFactoryBean<GatewaySender> {
    private boolean manualStart = false;
    private int remoteDistributedSystemId;
    private Boolean diskSynchronous;
    private Boolean batchConflationEnabled;
    private Boolean parallel;
    private Boolean persistent;
    private GatewayEventSubstitutionFilter eventSubstitutionFilter;
    private GatewaySender gatewaySender;
    private GatewaySender.OrderPolicy orderPolicy;
    private Integer alertThreshold;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private Integer dispatcherThreads;
    private Integer maximumQueueMemory;
    private Integer socketBufferSize;
    private Integer socketReadTimeout;
    private List<GatewayEventFilter> eventFilters;
    private List<GatewaySenderConfigurer> gatewaySenderConfigurers = Collections.emptyList();
    private List<GatewayTransportFilter> transportFilters;
    private List<String> regions = new ArrayList<String>();
    private String diskStoreReference;

    public GatewaySenderFactoryBean() {
    }

    public GatewaySenderFactoryBean(GemFireCache cache) {
        super(cache);
    }

    @Override
    protected void doInit() {
        GatewaySenderFactory gatewaySenderFactory = this.resolveGatewaySenderFactory();
        StreamSupport.stream(CollectionUtils.nullSafeIterable(this.gatewaySenderConfigurers).spliterator(), false).forEach(it -> it.configure(this.getName(), this));
        Optional.ofNullable(this.getAlertThreshold()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setAlertThreshold(arg_0));
        Optional.ofNullable(this.getBatchConflationEnabled()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setBatchConflationEnabled(arg_0));
        Optional.ofNullable(this.getBatchSize()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setBatchSize(arg_0));
        Optional.ofNullable(this.getBatchTimeInterval()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setBatchTimeInterval(arg_0));
        Optional.ofNullable(this.getDiskStoreReference()).filter(StringUtils::hasText).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setDiskStoreName(arg_0));
        Optional.ofNullable(this.getDiskSynchronous()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setDiskSynchronous(arg_0));
        Optional.ofNullable(this.getDispatcherThreads()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setDispatcherThreads(arg_0));
        CollectionUtils.nullSafeList(this.getEventFilters()).forEach(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).addGatewayEventFilter(arg_0));
        Optional.ofNullable(this.getEventSubstitutionFilter()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setGatewayEventSubstitutionFilter(arg_0));
        gatewaySenderFactory.setManualStart(this.isManualStart());
        Optional.ofNullable(this.getMaximumQueueMemory()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setMaximumQueueMemory(arg_0));
        Optional.ofNullable(this.getOrderPolicy()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setOrderPolicy(arg_0));
        gatewaySenderFactory.setParallel(this.isParallelGatewaySender());
        gatewaySenderFactory.setPersistenceEnabled(this.isPersistent());
        Optional.ofNullable(this.getSocketBufferSize()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setSocketBufferSize(arg_0));
        Optional.ofNullable(this.getSocketReadTimeout()).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setSocketReadTimeout(arg_0));
        CollectionUtils.nullSafeList(this.getTransportFilters()).forEach(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).addGatewayTransportFilter(arg_0));
        GatewaySenderWrapper wrapper = new GatewaySenderWrapper(gatewaySenderFactory.create(this.getName(), this.getRemoteDistributedSystemId()));
        wrapper.setManualStart(this.isManualStart());
        this.gatewaySender = wrapper;
    }

    private GatewaySenderFactory resolveGatewaySenderFactory() {
        return this.factory != null ? (GatewaySenderFactory)this.factory : this.cache.createGatewaySenderFactory();
    }

    public GatewaySender getObject() throws Exception {
        return this.gatewaySender;
    }

    public Class<?> getObjectType() {
        return this.gatewaySender != null ? this.gatewaySender.getClass() : GatewaySender.class;
    }

    public void setGatewaySender(GatewaySender gatewaySender) {
        this.gatewaySender = gatewaySender;
    }

    public GatewaySender getGatewaySender() {
        return this.gatewaySender;
    }

    public void setGatewaySenderConfigurers(List<GatewaySenderConfigurer> gatewaySenderConfigurers) {
        this.gatewaySenderConfigurers = gatewaySenderConfigurers;
    }

    public void setAlertThreshold(Integer alertThreshold) {
        this.alertThreshold = alertThreshold;
    }

    public Integer getAlertThreshold() {
        return this.alertThreshold;
    }

    public void setBatchConflationEnabled(Boolean batchConflationEnabled) {
        this.batchConflationEnabled = batchConflationEnabled;
    }

    public Boolean getBatchConflationEnabled() {
        return this.batchConflationEnabled;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchTimeInterval(Integer batchTimeInterval) {
        this.batchTimeInterval = batchTimeInterval;
    }

    public Integer getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    public void setDiskStoreRef(String diskStoreRef) {
        this.setDiskStoreReference(diskStoreRef);
    }

    public void setDiskStoreReference(String diskStoreReference) {
        this.diskStoreReference = diskStoreReference;
    }

    public String getDiskStoreReference() {
        return this.diskStoreReference;
    }

    public void setDiskSynchronous(Boolean diskSynchronous) {
        this.diskSynchronous = diskSynchronous;
    }

    public Boolean getDiskSynchronous() {
        return this.diskSynchronous;
    }

    public void setDispatcherThreads(Integer dispatcherThreads) {
        this.dispatcherThreads = dispatcherThreads;
    }

    public Integer getDispatcherThreads() {
        return this.dispatcherThreads;
    }

    public void setEventFilters(List<GatewayEventFilter> eventFilters) {
        this.eventFilters = eventFilters;
    }

    public List<GatewayEventFilter> getEventFilters() {
        return this.eventFilters;
    }

    public void setEventSubstitutionFilter(GatewayEventSubstitutionFilter eventSubstitutionFilter) {
        this.eventSubstitutionFilter = eventSubstitutionFilter;
    }

    public GatewayEventSubstitutionFilter getEventSubstitutionFilter() {
        return this.eventSubstitutionFilter;
    }

    public void setManualStart(boolean manualStart) {
        this.manualStart = manualStart;
    }

    public void setManualStart(Boolean manualStart) {
        this.setManualStart(Boolean.TRUE.equals(manualStart));
    }

    public boolean isManualStart() {
        return this.manualStart;
    }

    public void setMaximumQueueMemory(Integer maximumQueueMemory) {
        this.maximumQueueMemory = maximumQueueMemory;
    }

    public Integer getMaximumQueueMemory() {
        return this.maximumQueueMemory;
    }

    public void setOrderPolicy(GatewaySender.OrderPolicy orderPolicy) {
        this.orderPolicy = orderPolicy;
    }

    public void setOrderPolicy(OrderPolicyType orderPolicy) {
        this.setOrderPolicy(orderPolicy != null ? orderPolicy.getOrderPolicy() : null);
    }

    public GatewaySender.OrderPolicy getOrderPolicy() {
        return this.orderPolicy;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public boolean isParallelGatewaySender() {
        return Boolean.TRUE.equals(this.parallel);
    }

    public boolean isSerialGatewaySender() {
        return !this.isParallelGatewaySender();
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    public boolean isNotPersistent() {
        return !this.isPersistent();
    }

    public void setRemoteDistributedSystemId(int remoteDistributedSystemId) {
        this.remoteDistributedSystemId = remoteDistributedSystemId;
    }

    public void setRegions(String[] regions) {
        this.setRegions(Arrays.asList(ArrayUtils.nullSafeArray(regions, String.class)));
    }

    public void setRegions(List<String> regions) {
        this.regions.addAll(CollectionUtils.nullSafeList(regions));
    }

    public List<String> getRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    public int getRemoteDistributedSystemId() {
        return this.remoteDistributedSystemId;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketReadTimeout(Integer socketReadTimeout) {
        this.socketReadTimeout = socketReadTimeout;
    }

    public Integer getSocketReadTimeout() {
        return this.socketReadTimeout;
    }

    public void setTransportFilters(List<GatewayTransportFilter> transportFilters) {
        this.transportFilters = transportFilters;
    }

    public List<GatewayTransportFilter> getTransportFilters() {
        return this.transportFilters;
    }
}

