/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.StreamSupport;
import org.apache.geode.GemFireCheckedException;
import org.apache.geode.GemFireException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.datasource.ConfigProperty;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.security.SecurityManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Phased;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.GemfireSystemException;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.JndiDataSourceType;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.support.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CacheFactoryBean
extends AbstractFactoryBeanSupport<GemFireCache>
implements DisposableBean,
InitializingBean,
PersistenceExceptionTranslator,
Phased {
    private boolean close = true;
    private boolean useBeanFactoryLocator = false;
    private int phase = -1;
    private Boolean copyOnRead;
    private Boolean enableAutoReconnect;
    private Boolean pdxIgnoreUnreadFields;
    private Boolean pdxPersistent;
    private Boolean pdxReadSerialized;
    private Boolean useClusterConfiguration;
    private CacheFactoryInitializer<?> cacheFactoryInitializer;
    private GemFireCache cache;
    private DynamicRegionSupport dynamicRegionSupport;
    private Float criticalHeapPercentage;
    private Float criticalOffHeapPercentage;
    private Float evictionHeapPercentage;
    private Float evictionOffHeapPercentage;
    private GatewayConflictResolver gatewayConflictResolver;
    protected GemfireBeanFactoryLocator beanFactoryLocator;
    private Integer lockLease;
    private Integer lockTimeout;
    private Integer messageSyncInterval;
    private Integer searchTimeout;
    private List<PeerCacheConfigurer> peerCacheConfigurers = new ArrayList<PeerCacheConfigurer>();
    private List<JndiDataSource> jndiDataSources;
    private List<TransactionListener> transactionListeners;
    private PdxSerializer pdxSerializer;
    private PeerCacheConfigurer compositePeerCacheConfigurer = (beanName, bean) -> CollectionUtils.nullSafeList(this.peerCacheConfigurers).forEach(peerCacheConfigurer -> peerCacheConfigurer.configure(beanName, bean));
    private Properties properties;
    private Resource cacheXml;
    private String cacheResolutionMessagePrefix;
    private String pdxDiskStoreName;
    private SecurityManager securityManager;
    private TransactionWriter transactionWriter;

    public void afterPropertiesSet() throws Exception {
        this.applyCacheConfigurers();
        this.initBeanFactoryLocator();
    }

    protected void applyCacheConfigurers() {
        PeerCacheConfigurer autoReconnectClusterConfigurationConfigurer = (beanName, cacheFactoryBean) -> {
            Properties gemfireProperties = this.resolveProperties();
            gemfireProperties.setProperty("disable-auto-reconnect", String.valueOf(!Boolean.TRUE.equals(this.getEnableAutoReconnect())));
            gemfireProperties.setProperty("use-cluster-configuration", String.valueOf(Boolean.TRUE.equals(this.getUseClusterConfiguration())));
        };
        this.peerCacheConfigurers.add(autoReconnectClusterConfigurationConfigurer);
        this.applyPeerCacheConfigurers(this.getCompositePeerCacheConfigurer());
    }

    protected void applyPeerCacheConfigurers(PeerCacheConfigurer ... peerCacheConfigurers) {
        this.applyPeerCacheConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(peerCacheConfigurers, PeerCacheConfigurer.class)));
    }

    protected void applyPeerCacheConfigurers(Iterable<PeerCacheConfigurer> peerCacheConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(peerCacheConfigurers).spliterator(), false).forEach(clientCacheConfigurer -> clientCacheConfigurer.configure(this.getBeanName(), this));
    }

    void initBeanFactoryLocator() {
        if (this.isUseBeanFactoryLocator() && this.beanFactoryLocator == null) {
            this.beanFactoryLocator = GemfireBeanFactoryLocator.newBeanFactoryLocator(this.getBeanFactory(), this.getBeanName());
        }
    }

    GemFireCache init() {
        ClassLoader currentThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getBeanClassLoader());
            this.setCache((GemFireCache)this.postProcess((T)this.resolveCache()));
            Optional.ofNullable(this.getCache()).ifPresent(cache -> {
                Optional.ofNullable(cache.getDistributedSystem()).map(DistributedSystem::getDistributedMember).ifPresent(member -> this.logInfo(() -> String.format("Connected to Distributed System [%1$s] as Member [%2$s]".concat(" in Group(s) [%3$s] with Role(s) [%4$s] on Host [%5$s] having PID [%6$d]"), cache.getDistributedSystem().getName(), member.getId(), member.getGroups(), member.getRoles(), member.getHost(), member.getProcessId())));
                this.logInfo(() -> String.format("%1$s %2$s version [%3$s] Cache [%4$s]", this.cacheResolutionMessagePrefix, GemfireUtils.apacheGeodeProductName(), GemfireUtils.apacheGeodeVersion(), cache.getName()));
            });
            Object t = this.getCache();
            return t;
        }
        catch (Exception cause) {
            throw RuntimeExceptionFactory.newRuntimeException(cause, "Error occurred when initializing peer cache", new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadContextClassLoader);
        }
    }

    protected <T extends GemFireCache> T resolveCache() {
        try {
            this.cacheResolutionMessagePrefix = "Found existing";
            return this.fetchCache();
        }
        catch (CacheClosedException cause) {
            this.cacheResolutionMessagePrefix = "Created new";
            this.initDynamicRegionFactory();
            return this.createCache(this.postProcess(this.configureFactory(this.initializeFactory(this.createFactory(this.resolveProperties())))));
        }
    }

    protected <T extends GemFireCache> T fetchCache() {
        return (T)((GemFireCache)Optional.ofNullable(this.getCache()).orElseGet(CacheFactory::getAnyInstance));
    }

    private void initDynamicRegionFactory() {
        Optional.ofNullable(this.getDynamicRegionSupport()).ifPresent(DynamicRegionSupport::initializeDynamicRegionFactory);
    }

    protected Properties resolveProperties() {
        return Optional.ofNullable(this.getProperties()).orElseGet(() -> this.setAndGetProperties(new Properties()));
    }

    protected Object createFactory(Properties gemfireProperties) {
        return new CacheFactory(gemfireProperties);
    }

    @Nullable
    protected Object initializeFactory(Object factory) {
        return Optional.ofNullable(this.getCacheFactoryInitializer()).map(cacheFactoryInitializer -> cacheFactoryInitializer.initialize(factory)).orElse(factory);
    }

    protected Object configureFactory(Object factory) {
        return this.configureSecurity(this.configurePdx((CacheFactory)factory));
    }

    private CacheFactory configurePdx(CacheFactory cacheFactory) {
        Optional.ofNullable(this.getPdxSerializer()).ifPresent(arg_0 -> ((CacheFactory)cacheFactory).setPdxSerializer(arg_0));
        Optional.ofNullable(this.getPdxDiskStoreName()).filter(StringUtils::hasText).ifPresent(arg_0 -> ((CacheFactory)cacheFactory).setPdxDiskStore(arg_0));
        Optional.ofNullable(this.getPdxIgnoreUnreadFields()).ifPresent(arg_0 -> ((CacheFactory)cacheFactory).setPdxIgnoreUnreadFields(arg_0));
        Optional.ofNullable(this.getPdxPersistent()).ifPresent(arg_0 -> ((CacheFactory)cacheFactory).setPdxPersistent(arg_0));
        Optional.ofNullable(this.getPdxReadSerialized()).ifPresent(arg_0 -> ((CacheFactory)cacheFactory).setPdxReadSerialized(arg_0));
        return cacheFactory;
    }

    private CacheFactory configureSecurity(CacheFactory cacheFactory) {
        Optional.ofNullable(this.getSecurityManager()).ifPresent(arg_0 -> ((CacheFactory)cacheFactory).setSecurityManager(arg_0));
        return cacheFactory;
    }

    protected Object postProcess(Object factory) {
        return factory;
    }

    protected <T extends GemFireCache> T createCache(Object factory) {
        return (T)((CacheFactory)factory).create();
    }

    protected <T extends GemFireCache> T postProcess(T cache) {
        this.loadCacheXml(cache);
        Optional.ofNullable(this.getCopyOnRead()).ifPresent(arg_0 -> cache.setCopyOnRead(arg_0));
        if (cache instanceof Cache) {
            Optional.ofNullable(this.getGatewayConflictResolver()).ifPresent(arg_0 -> ((Cache)((Cache)cache)).setGatewayConflictResolver(arg_0));
            Optional.ofNullable(this.getLockLease()).ifPresent(arg_0 -> ((Cache)((Cache)cache)).setLockLease(arg_0));
            Optional.ofNullable(this.getLockTimeout()).ifPresent(arg_0 -> ((Cache)((Cache)cache)).setLockTimeout(arg_0));
            Optional.ofNullable(this.getMessageSyncInterval()).ifPresent(arg_0 -> ((Cache)((Cache)cache)).setMessageSyncInterval(arg_0));
            Optional.ofNullable(this.getSearchTimeout()).ifPresent(arg_0 -> ((Cache)((Cache)cache)).setSearchTimeout(arg_0));
        }
        this.configureHeapPercentages(cache);
        this.configureOffHeapPercentages(cache);
        this.registerJndiDataSources(cache);
        this.registerTransactionListeners(cache);
        this.registerTransactionWriter(cache);
        return cache;
    }

    private <T extends GemFireCache> T loadCacheXml(T cache) {
        Optional.ofNullable(this.getCacheXml()).ifPresent(cacheXml -> {
            try {
                this.logDebug("Initializing cache with [%s]", cacheXml);
                cache.loadCacheXml(cacheXml.getInputStream());
            }
            catch (IOException cause) {
                throw RuntimeExceptionFactory.newRuntimeException(cause, "Failed to load cache.xml [%s]", cacheXml);
            }
        });
        return cache;
    }

    private boolean isHeapPercentageValid(Float heapPercentage) {
        return heapPercentage.floatValue() >= 0.0f && heapPercentage.floatValue() <= 100.0f;
    }

    private GemFireCache configureHeapPercentages(GemFireCache cache) {
        Optional.ofNullable(this.getCriticalHeapPercentage()).ifPresent(criticalHeapPercentage -> {
            Assert.isTrue((boolean)this.isHeapPercentageValid((Float)criticalHeapPercentage), (String)String.format("criticalHeapPercentage [%s] is not valid; must be >= 0.0 and <= 100.0", criticalHeapPercentage));
            cache.getResourceManager().setCriticalHeapPercentage(criticalHeapPercentage.floatValue());
        });
        Optional.ofNullable(this.getEvictionHeapPercentage()).ifPresent(evictionHeapPercentage -> {
            Assert.isTrue((boolean)this.isHeapPercentageValid((Float)evictionHeapPercentage), (String)String.format("evictionHeapPercentage [%s] is not valid; must be >= 0.0 and <= 100.0", evictionHeapPercentage));
            cache.getResourceManager().setEvictionHeapPercentage(evictionHeapPercentage.floatValue());
        });
        return cache;
    }

    private GemFireCache configureOffHeapPercentages(GemFireCache cache) {
        Optional.ofNullable(this.getCriticalOffHeapPercentage()).ifPresent(criticalOffHeapPercentage -> {
            Assert.isTrue((boolean)this.isHeapPercentageValid((Float)criticalOffHeapPercentage), (String)String.format("criticalOffHeapPercentage [%s] is not valid; must be >= 0.0 and <= 100.0", criticalOffHeapPercentage));
            cache.getResourceManager().setCriticalOffHeapPercentage(criticalOffHeapPercentage.floatValue());
        });
        Optional.ofNullable(this.getEvictionOffHeapPercentage()).ifPresent(evictionOffHeapPercentage -> {
            Assert.isTrue((boolean)this.isHeapPercentageValid((Float)evictionOffHeapPercentage), (String)String.format("evictionOffHeapPercentage [%s] is not valid; must be >= 0.0 and <= 100.0", evictionOffHeapPercentage));
            cache.getResourceManager().setEvictionOffHeapPercentage(evictionOffHeapPercentage.floatValue());
        });
        return cache;
    }

    private GemFireCache registerJndiDataSources(GemFireCache cache) {
        CollectionUtils.nullSafeCollection(this.getJndiDataSources()).forEach(jndiDataSource -> {
            String type = jndiDataSource.getAttributes().get("type");
            JndiDataSourceType jndiDataSourceType = JndiDataSourceType.valueOfIgnoreCase(type);
            Assert.notNull((Object)((Object)jndiDataSourceType), (String)String.format("'jndi-binding' 'type' [%1$s] is invalid; 'type' must be one of %2$s", type, Arrays.toString((Object[])JndiDataSourceType.values())));
            jndiDataSource.getAttributes().put("type", jndiDataSourceType.getName());
            try {
                JNDIInvoker.mapDatasource(jndiDataSource.getAttributes(), jndiDataSource.getProps());
            }
            catch (Exception cause) {
                throw new InvalidDataAccessApiUsageException("Failed to run operation", (Throwable)cause);
            }
        });
        return cache;
    }

    private GemFireCache registerTransactionListeners(GemFireCache cache) {
        CollectionUtils.nullSafeCollection(this.getTransactionListeners()).forEach(transactionListener -> cache.getCacheTransactionManager().addListener(transactionListener));
        return cache;
    }

    private GemFireCache registerTransactionWriter(GemFireCache cache) {
        Optional.ofNullable(this.getTransactionWriter()).ifPresent(it -> cache.getCacheTransactionManager().setWriter(it));
        return cache;
    }

    protected void close(GemFireCache cache) {
        Optional.ofNullable(cache).filter(it -> !it.isClosed()).ifPresent(RegionService::close);
        this.setCache(null);
    }

    public void destroy() throws Exception {
        if (this.isClose()) {
            this.close((GemFireCache)this.fetchCache());
            this.destroyBeanFactoryLocator();
        }
    }

    private void destroyBeanFactoryLocator() {
        Optional.ofNullable(this.getBeanFactoryLocator()).ifPresent(GemfireBeanFactoryLocator::destroy);
        this.beanFactoryLocator = null;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException exception) {
        DataAccessException wrapped;
        if (exception instanceof IllegalArgumentException && !((wrapped = GemfireCacheUtils.convertQueryExceptions(exception)) instanceof GemfireSystemException)) {
            return wrapped;
        }
        if (exception instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)exception);
        }
        if (exception.getCause() instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)exception.getCause());
        }
        if (exception.getCause() instanceof GemFireCheckedException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireCheckedException)exception.getCause());
        }
        return null;
    }

    public GemfireBeanFactoryLocator getBeanFactoryLocator() {
        return this.beanFactoryLocator;
    }

    protected void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    protected <T extends GemFireCache> T getCache() {
        return (T)this.cache;
    }

    public void setCacheXml(Resource cacheXml) {
        this.cacheXml = cacheXml;
    }

    public Resource getCacheXml() {
        return this.cacheXml;
    }

    private File getCacheXmlFile() {
        try {
            return this.getCacheXml().getFile();
        }
        catch (Throwable cause) {
            throw RuntimeExceptionFactory.newIllegalStateException(cause, "Resource [%s] is not resolvable as a file", this.getCacheXml());
        }
    }

    private boolean isCacheXmlAvailable() {
        try {
            return this.getCacheXmlFile() != null;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public GemFireCache getObject() throws Exception {
        return Optional.ofNullable(this.getCache()).orElseGet(this::init);
    }

    public Class<? extends GemFireCache> getObjectType() {
        return Optional.ofNullable(this.getCache()).map(Object::getClass).orElse(Cache.class);
    }

    public void setCacheFactoryInitializer(CacheFactoryInitializer cacheFactoryInitializer) {
        this.cacheFactoryInitializer = cacheFactoryInitializer;
    }

    public CacheFactoryInitializer getCacheFactoryInitializer() {
        return this.cacheFactoryInitializer;
    }

    protected Properties setAndGetProperties(Properties properties) {
        this.setProperties(properties);
        return this.getProperties();
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean isClose() {
        return this.close;
    }

    public PeerCacheConfigurer getCompositePeerCacheConfigurer() {
        return this.compositePeerCacheConfigurer;
    }

    public void setCopyOnRead(Boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    public Boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    public void setCriticalHeapPercentage(Float criticalHeapPercentage) {
        this.criticalHeapPercentage = criticalHeapPercentage;
    }

    public Float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    public void setCriticalOffHeapPercentage(Float criticalOffHeapPercentage) {
        this.criticalOffHeapPercentage = criticalOffHeapPercentage;
    }

    public Float getCriticalOffHeapPercentage() {
        return this.criticalOffHeapPercentage;
    }

    public void setDynamicRegionSupport(DynamicRegionSupport dynamicRegionSupport) {
        this.dynamicRegionSupport = dynamicRegionSupport;
    }

    public DynamicRegionSupport getDynamicRegionSupport() {
        return this.dynamicRegionSupport;
    }

    public void setEnableAutoReconnect(Boolean enableAutoReconnect) {
        this.enableAutoReconnect = enableAutoReconnect;
    }

    public Boolean getEnableAutoReconnect() {
        return this.enableAutoReconnect;
    }

    public void setEvictionHeapPercentage(Float evictionHeapPercentage) {
        this.evictionHeapPercentage = evictionHeapPercentage;
    }

    public Float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    public void setEvictionOffHeapPercentage(Float evictionOffHeapPercentage) {
        this.evictionOffHeapPercentage = evictionOffHeapPercentage;
    }

    public Float getEvictionOffHeapPercentage() {
        return this.evictionOffHeapPercentage;
    }

    public void setGatewayConflictResolver(GatewayConflictResolver gatewayConflictResolver) {
        this.gatewayConflictResolver = gatewayConflictResolver;
    }

    public GatewayConflictResolver getGatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    public void setJndiDataSources(List<JndiDataSource> jndiDataSources) {
        this.jndiDataSources = jndiDataSources;
    }

    public List<JndiDataSource> getJndiDataSources() {
        return this.jndiDataSources;
    }

    public void setLockLease(Integer lockLease) {
        this.lockLease = lockLease;
    }

    public Integer getLockLease() {
        return this.lockLease;
    }

    public void setLockTimeout(Integer lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public Integer getLockTimeout() {
        return this.lockTimeout;
    }

    public void setMessageSyncInterval(Integer messageSyncInterval) {
        this.messageSyncInterval = messageSyncInterval;
    }

    public Integer getMessageSyncInterval() {
        return this.messageSyncInterval;
    }

    protected void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPdxDiskStoreName(String pdxDiskStoreName) {
        this.pdxDiskStoreName = pdxDiskStoreName;
    }

    public String getPdxDiskStoreName() {
        return this.pdxDiskStoreName;
    }

    public void setPdxIgnoreUnreadFields(Boolean pdxIgnoreUnreadFields) {
        this.pdxIgnoreUnreadFields = pdxIgnoreUnreadFields;
    }

    public Boolean getPdxIgnoreUnreadFields() {
        return this.pdxIgnoreUnreadFields;
    }

    public void setPdxPersistent(Boolean pdxPersistent) {
        this.pdxPersistent = pdxPersistent;
    }

    public Boolean getPdxPersistent() {
        return this.pdxPersistent;
    }

    public void setPdxReadSerialized(Boolean pdxReadSerialized) {
        this.pdxReadSerialized = pdxReadSerialized;
    }

    public Boolean getPdxReadSerialized() {
        return this.pdxReadSerialized;
    }

    public void setPdxSerializer(PdxSerializer serializer) {
        this.pdxSerializer = serializer;
    }

    public PdxSerializer getPdxSerializer() {
        return this.pdxSerializer;
    }

    public void setPeerCacheConfigurers(PeerCacheConfigurer ... peerCacheConfigurers) {
        this.setPeerCacheConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(peerCacheConfigurers, PeerCacheConfigurer.class)));
    }

    public void setPeerCacheConfigurers(List<PeerCacheConfigurer> peerCacheConfigurers) {
        Optional.ofNullable(peerCacheConfigurers).ifPresent(this.peerCacheConfigurers::addAll);
    }

    public void setSearchTimeout(Integer searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    public Integer getSearchTimeout() {
        return this.searchTimeout;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setTransactionListeners(List<TransactionListener> transactionListeners) {
        this.transactionListeners = transactionListeners;
    }

    public List<TransactionListener> getTransactionListeners() {
        return this.transactionListeners;
    }

    public void setTransactionWriter(TransactionWriter transactionWriter) {
        this.transactionWriter = transactionWriter;
    }

    public TransactionWriter getTransactionWriter() {
        return this.transactionWriter;
    }

    public void setUseBeanFactoryLocator(boolean use) {
        this.useBeanFactoryLocator = use;
    }

    public boolean isUseBeanFactoryLocator() {
        return this.useBeanFactoryLocator;
    }

    public void setUseClusterConfiguration(Boolean useSharedConfiguration) {
        this.useClusterConfiguration = useSharedConfiguration;
    }

    public Boolean getUseClusterConfiguration() {
        return this.useClusterConfiguration;
    }

    public static class JndiDataSource {
        private List<ConfigProperty> configProperties;
        private Map<String, String> attributes;

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public List<ConfigProperty> getProps() {
            return this.configProperties;
        }

        public void setProps(List<ConfigProperty> props) {
            this.configProperties = props;
        }
    }

    public static class DynamicRegionSupport {
        private Boolean persistent = Boolean.TRUE;
        private Boolean registerInterest = Boolean.TRUE;
        private String diskDirectory;
        private String poolName;

        public void setDiskDir(String diskDirectory) {
            this.diskDirectory = diskDirectory;
        }

        public String getDiskDir() {
            return this.diskDirectory;
        }

        public void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        public Boolean getPersistent() {
            return this.persistent;
        }

        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void setRegisterInterest(Boolean registerInterest) {
            this.registerInterest = registerInterest;
        }

        public Boolean getRegisterInterest() {
            return this.registerInterest;
        }

        public void initializeDynamicRegionFactory() {
            File localDiskDirectory = this.diskDirectory != null ? new File(this.diskDirectory) : null;
            DynamicRegionFactory.Config config = new DynamicRegionFactory.Config(localDiskDirectory, this.poolName, this.persistent.booleanValue(), this.registerInterest.booleanValue());
            DynamicRegionFactory.get().open(config);
        }
    }

    public static interface CacheFactoryInitializer<T> {
        public T initialize(T var1);
    }
}

