/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public enum JndiDataSourceType {
    MANAGED("ManagedDataSource"),
    POOLED("PooledDataSource"),
    SIMPLE("SimpleDataSource"),
    XA("XAPooledDataSource");

    private final String name;

    private JndiDataSourceType(String name) {
        Assert.hasText((String)name, (String)"The JNDI DataSource Type 'name' must be specified!");
        this.name = name;
    }

    public static JndiDataSourceType valueOfIgnoreCase(String name) {
        for (JndiDataSourceType jndiDataSourceType : JndiDataSourceType.values()) {
            if (!JndiDataSourceType.isMatch(jndiDataSourceType, name)) continue;
            return jndiDataSourceType;
        }
        return null;
    }

    private static boolean isMatch(JndiDataSourceType jndiDataSourceType, String name) {
        name = StringUtils.trimWhitespace((String)name);
        return jndiDataSourceType.getName().equalsIgnoreCase(name) || jndiDataSourceType.name().equalsIgnoreCase(name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

