/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client.support;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import org.apache.geode.cache.query.QueryService;
import org.springframework.data.gemfire.client.PoolAdapter;

public abstract class FactoryDefaultsPoolAdapter
extends PoolAdapter {
    protected static final boolean DEFAULT_KEEP_ALIVE = false;
    protected static final String DEFAULT_POOL_NAME = "DEFAULT";
    protected static final String LOCALHOST = "localhost";

    @Override
    public int getFreeConnectionTimeout() {
        return 10000;
    }

    @Override
    public long getIdleTimeout() {
        return 5000L;
    }

    @Override
    public int getLoadConditioningInterval() {
        return 300000;
    }

    @Override
    public List<InetSocketAddress> getLocators() {
        return Collections.emptyList();
    }

    @Override
    public int getMaxConnections() {
        return -1;
    }

    @Override
    public int getMinConnections() {
        return 1;
    }

    @Override
    public boolean getMultiuserAuthentication() {
        return false;
    }

    @Override
    public String getName() {
        return DEFAULT_POOL_NAME;
    }

    @Override
    public List<InetSocketAddress> getOnlineLocators() {
        return Collections.emptyList();
    }

    @Override
    public long getPingInterval() {
        return 10000L;
    }

    @Override
    public boolean getPRSingleHopEnabled() {
        return true;
    }

    @Override
    public QueryService getQueryService() {
        return null;
    }

    @Override
    public int getReadTimeout() {
        return 10000;
    }

    @Override
    public int getRetryAttempts() {
        return -1;
    }

    @Override
    public String getServerGroup() {
        return "";
    }

    @Override
    public List<InetSocketAddress> getServers() {
        return Collections.singletonList(new InetSocketAddress(LOCALHOST, 40404));
    }

    @Override
    public int getSocketBufferSize() {
        return 32768;
    }

    @Override
    public int getStatisticInterval() {
        return -1;
    }

    @Override
    public int getSubscriptionAckInterval() {
        return 100;
    }

    @Override
    public boolean getSubscriptionEnabled() {
        return false;
    }

    @Override
    public int getSubscriptionMessageTrackingTimeout() {
        return 900000;
    }

    @Override
    public int getSubscriptionRedundancy() {
        return 0;
    }

    @Override
    public boolean getThreadLocalConnections() {
        return false;
    }

    @Override
    public void destroy() {
        this.destroy(false);
    }
}

