/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.GemFireVersion;
import org.springframework.data.gemfire.util.RegionUtils;
import org.springframework.util.ClassUtils;

public abstract class GemfireUtils
extends RegionUtils {
    public static final String APACHE_GEODE_NAME = "Apache Geode";
    public static final String GEMFIRE_NAME = GemfireUtils.apacheGeodeProductName();
    public static final String GEMFIRE_VERSION = GemfireUtils.apacheGeodeVersion();
    public static final String UNKNOWN = "unknown";

    public static String apacheGeodeProductName() {
        try {
            return GemFireVersion.getProductName();
        }
        catch (Throwable ignore) {
            return APACHE_GEODE_NAME;
        }
    }

    public static String apacheGeodeVersion() {
        try {
            return CacheFactory.getVersion();
        }
        catch (Throwable ignore) {
            return UNKNOWN;
        }
    }

    public static boolean isGemfireVersionGreaterThanEqualTo(double expectedVersion) {
        double actualVersion = Double.parseDouble(GEMFIRE_VERSION.substring(0, 3));
        return actualVersion >= expectedVersion;
    }

    public static boolean isGemfireVersion65OrAbove() {
        try {
            double version = Double.parseDouble(GEMFIRE_VERSION.substring(0, 3));
            return version >= 6.5;
        }
        catch (NumberFormatException e) {
            return ConcurrentMap.class.isAssignableFrom(Region.class);
        }
    }

    public static boolean isGemfireVersion7OrAbove() {
        try {
            return GemfireUtils.isGemfireVersionGreaterThanEqualTo(7.0);
        }
        catch (NumberFormatException e) {
            return ClassUtils.isPresent((String)"org.apache.geode.distributed.ServerLauncher", (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }

    public static boolean isGemfireVersion8OrAbove() {
        try {
            return GemfireUtils.isGemfireVersionGreaterThanEqualTo(8.0);
        }
        catch (NumberFormatException e) {
            return ClassUtils.isPresent((String)"org.apache.geode.management.internal.web.domain.LinkIndex", (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }

    public static void main(String ... args) {
        System.out.printf("GemFire Version %1$s%n", GEMFIRE_VERSION);
    }
}

