/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PropertiesBuilder
implements FactoryBean<Properties> {
    private final Properties properties = new Properties();

    public static PropertiesBuilder create() {
        return new PropertiesBuilder();
    }

    public static PropertiesBuilder from(Properties properties) {
        return new PropertiesBuilder(properties);
    }

    public static PropertiesBuilder from(InputStream in) {
        try {
            Properties defaults = new Properties();
            defaults.load(in);
            return new PropertiesBuilder(defaults);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read properties from InputStream", e);
        }
    }

    public static PropertiesBuilder from(Reader reader) {
        try {
            Properties defaults = new Properties();
            defaults.load(reader);
            return new PropertiesBuilder(defaults);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read properties from Reader", e);
        }
    }

    public static PropertiesBuilder fromXml(InputStream xml) {
        try {
            Properties defaults = new Properties();
            defaults.loadFromXML(xml);
            return new PropertiesBuilder(defaults);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read properties from XML", e);
        }
    }

    public PropertiesBuilder() {
    }

    public PropertiesBuilder(Properties defaults) {
        this.properties.putAll((Map<?, ?>)defaults);
    }

    public PropertiesBuilder(PropertiesBuilder builder) {
        this(builder.build());
    }

    public Properties getObject() throws Exception {
        return this.build();
    }

    public Class<?> getObjectType() {
        return this.properties != null ? this.properties.getClass() : Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public PropertiesBuilder add(Properties properties) {
        if (!CollectionUtils.isEmpty((Map)properties)) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        return this;
    }

    public PropertiesBuilder add(PropertiesBuilder builder) {
        return builder != null ? this.add(builder.build()) : this;
    }

    public PropertiesBuilder setProperty(String name, Object value) {
        return value != null ? this.setProperty(name, value.toString()) : this;
    }

    public PropertiesBuilder setProperty(String name, Object[] values) {
        return !ObjectUtils.isEmpty((Object[])values) ? this.setProperty(name, StringUtils.arrayToCommaDelimitedString((Object[])values)) : this;
    }

    public PropertiesBuilder setProperty(String name, String value) {
        Assert.hasText((String)name, (String)String.format("Name [%s] must be specified", name));
        if (this.isValuable(value)) {
            this.properties.setProperty(name, value);
        }
        return this;
    }

    public <T> PropertiesBuilder setPropertyIfNotDefault(String name, Object value, T defaultValue) {
        return defaultValue == null || !defaultValue.equals(value) ? this.setProperty(name, value) : this;
    }

    public PropertiesBuilder unsetProperty(String name) {
        Assert.hasText((String)name, (String)String.format("Name [%s] mut be specified", name));
        this.properties.setProperty(name, "");
        return this;
    }

    protected boolean isValuable(String value) {
        return StringUtils.hasText((String)value) && !"null".equalsIgnoreCase(value.trim());
    }

    public Properties build() {
        return this.properties;
    }
}

