/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import org.springframework.data.gemfire.function.annotation.OnMember;
import org.springframework.data.gemfire.function.annotation.OnMembers;
import org.springframework.data.gemfire.function.annotation.OnRegion;
import org.springframework.data.gemfire.function.annotation.OnServer;
import org.springframework.data.gemfire.function.annotation.OnServers;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfiguration;
import org.springframework.data.gemfire.function.config.OnMemberExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.OnMembersExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.OnRegionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.OnServerExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.OnServersExecutionBeanDefinitionBuilder;

abstract class FunctionExecutionBeanDefinitionBuilderFactory {
    FunctionExecutionBeanDefinitionBuilderFactory() {
    }

    static AbstractFunctionExecutionBeanDefinitionBuilder newInstance(FunctionExecutionConfiguration configuration) {
        String functionExecutionAnnotation = configuration.getAnnotationType();
        if (OnMember.class.getName().equals(functionExecutionAnnotation)) {
            return new OnMemberExecutionBeanDefinitionBuilder(configuration);
        }
        if (OnMembers.class.getName().equals(functionExecutionAnnotation)) {
            return new OnMembersExecutionBeanDefinitionBuilder(configuration);
        }
        if (OnRegion.class.getName().equals(functionExecutionAnnotation)) {
            return new OnRegionExecutionBeanDefinitionBuilder(configuration);
        }
        if (OnServer.class.getName().equals(functionExecutionAnnotation)) {
            return new OnServerExecutionBeanDefinitionBuilder(configuration);
        }
        if (OnServers.class.getName().equals(functionExecutionAnnotation)) {
            return new OnServersExecutionBeanDefinitionBuilder(configuration);
        }
        return null;
    }
}

