/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RegionDataAccessTracingAspect {
    private final Logger logger = this.newLogger();

    protected Logger newLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    protected String getCurrentThreadStackTrace() {
        StringWriter writer = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Pointcut(value="target(com.gemstone.gemfire.cache.Region)")
    private void regionPointcut() {
    }

    @Pointcut(value="execution(* com.gemstone.gemfire.cache.Region.create(..)) || execution(* com.gemstone.gemfire.cache.Region.get(..)) || execution(* com.gemstone.gemfire.cache.Region.getAll(..)) || execution(* com.gemstone.gemfire.cache.Region.put(..)) || execution(* com.gemstone.gemfire.cache.Region.putAll(..)) || execution(* com.gemstone.gemfire.cache.Region.putIfAbsent(..)) || execution(* com.gemstone.gemfire.cache.Region.remove(..)) || execution(* com.gemstone.gemfire.cache.Region.replace(..)) || execution(* com.gemstone.gemfire.cache.Region.selectValue(..)) || execution(* com.gemstone.gemfire.cache.Region.values(..))")
    private void regionDataAccessPointcut() {
    }

    @Before(value="regionPointcut() && regionDataAccessPointcut()")
    public void regionDataAccessTracingAdvice() {
        this.getLogger().trace("Region data access call [{}]", (Object)this.getCurrentThreadStackTrace());
    }
}

