/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionId;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.GemfireTransactionCommitException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class GemfireTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean,
ResourceTransactionManager {
    protected static final TimeUnit DEFAULT_RESUME_WAIT_TIME_UNIT = TimeUnit.SECONDS;
    private GemFireCache cache;
    private boolean copyOnRead = true;
    private Long resumeWaitTime;
    private TimeUnit resumeWaitTimeUnit = DEFAULT_RESUME_WAIT_TIME_UNIT;

    public GemfireTransactionManager() {
    }

    public GemfireTransactionManager(GemFireCache cache) {
        this.cache = cache;
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.cache, (String)"Cache is required");
        this.cache.setCopyOnRead(this.isCopyOnRead());
    }

    protected Object doGetTransaction() throws org.springframework.transaction.TransactionException {
        return CacheTransactionObject.newCacheTransactionObject((CacheHolder)TransactionSynchronizationManager.getResource((Object)this.getCache()));
    }

    protected boolean isExistingTransaction(Object transaction) throws org.springframework.transaction.TransactionException {
        return ((CacheTransactionObject)transaction).isHolding();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws org.springframework.transaction.TransactionException {
        try {
            CacheTransactionObject cacheTransaction = (CacheTransactionObject)transaction;
            GemFireCache cache = this.getCache();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Acquired GemFire Cache [%s] for local cache transaction", cache));
            }
            CacheTransactionManager cacheTransactionManager = this.getCacheTransactionManager();
            cacheTransactionManager.begin();
            TransactionId transactionId = cacheTransactionManager.getTransactionId();
            if (transactionId != null) {
                TransactionSynchronizationManager.bindResource((Object)cache, (Object)cacheTransaction.setAndGetHolder(CacheHolder.newCacheHolder(transactionId)));
            }
        }
        catch (IllegalStateException e) {
            throw new CannotCreateTransactionException(String.format("%1$s; %2$s", "An existing, ongoing transaction is already associated with the current thread", "are multiple transaction managers present?"), (Throwable)e);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        try {
            if (status.isDebug()) {
                this.logger.debug((Object)"Committing local cache transaction");
            }
            this.getCacheTransactionManager().commit();
        }
        catch (IllegalStateException e) {
            throw new NoTransactionException("No transaction is associated with the current thread; are multiple transaction managers present?", (Throwable)e);
        }
        catch (TransactionException e) {
            throw new GemfireTransactionCommitException("Unexpected failure occurred on commit of local cache transaction", e);
        }
    }

    protected Object doSuspend(Object transaction) throws org.springframework.transaction.TransactionException {
        if (this.getCacheTransactionManager().suspend() != null) {
            TransactionSynchronizationManager.unbindResource((Object)this.getCache());
            return ((CacheTransactionObject)transaction).setAndReturnExistingHolder(null);
        }
        return null;
    }

    protected void doResume(Object transaction, Object suspendedResources) throws org.springframework.transaction.TransactionException {
        if (suspendedResources instanceof CacheHolder) {
            boolean resumeSuccessful;
            CacheHolder holder = (CacheHolder)suspendedResources;
            boolean bl = resumeSuccessful = this.isResumeWaitTimeSet() ? this.getCacheTransactionManager().tryResume(holder.getTransactionId(), this.getResumeWaitTime().longValue(), this.getResumeWaitTimeUnit()) : this.getCacheTransactionManager().tryResume(holder.getTransactionId());
            if (resumeSuccessful) {
                TransactionSynchronizationManager.bindResource((Object)this.getCache(), (Object)((CacheTransactionObject)transaction).setAndGetHolder(holder));
            }
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        try {
            if (status.isDebug()) {
                this.logger.debug((Object)"Rolling back local cache transaction");
            }
            this.getCacheTransactionManager().rollback();
        }
        catch (IllegalStateException e) {
            throw new NoTransactionException("No transaction is associated with the current thread; are multiple transaction managers present?", (Throwable)e);
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TransactionSynchronizationManager.unbindResource((Object)this.getCache());
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        ((CacheTransactionObject)status.getTransaction()).getHolder().setRollbackOnly();
    }

    protected final boolean useSavepointForNestedTransaction() {
        return false;
    }

    public void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    public GemFireCache getCache() {
        return this.cache;
    }

    protected CacheTransactionManager getCacheTransactionManager() {
        return this.getCache().getCacheTransactionManager();
    }

    public void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    public boolean isCopyOnRead() {
        return this.copyOnRead;
    }

    public <K, V> void setRegion(Region<K, V> region) {
        Assert.notNull(region, (String)"Region must not be null");
        this.cache = (GemFireCache)region.getRegionService();
    }

    public Object getResourceFactory() {
        return this.getCache();
    }

    public void setResumeWaitTime(Long resumeWaitTime) {
        this.resumeWaitTime = resumeWaitTime;
    }

    protected Long getResumeWaitTime() {
        return this.resumeWaitTime;
    }

    protected boolean isResumeWaitTimeSet() {
        Long resumeWaitTime = this.getResumeWaitTime();
        return resumeWaitTime != null && resumeWaitTime > 0L;
    }

    public void setResumeWaitTimeUnit(TimeUnit resumeWaitTimeUnit) {
        this.resumeWaitTimeUnit = resumeWaitTimeUnit;
    }

    protected TimeUnit getResumeWaitTimeUnit() {
        TimeUnit localResumeWaitTimeUnit = this.resumeWaitTimeUnit;
        return localResumeWaitTimeUnit != null ? localResumeWaitTimeUnit : DEFAULT_RESUME_WAIT_TIME_UNIT;
    }

    protected static class CacheHolder {
        private boolean rollbackOnly = false;
        private TransactionId transactionId;

        protected CacheHolder() {
        }

        public static CacheHolder newCacheHolder(TransactionId transactionId) {
            CacheHolder cacheHolder = new CacheHolder();
            cacheHolder.transactionId = transactionId;
            return cacheHolder;
        }

        public boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        public void setRollbackOnly() {
            this.rollbackOnly = true;
        }

        public TransactionId getTransactionId() {
            return this.transactionId;
        }
    }

    protected static class CacheTransactionObject {
        private CacheHolder cacheHolder;

        protected CacheTransactionObject() {
        }

        public static CacheTransactionObject newCacheTransactionObject(CacheHolder cacheHolder) {
            CacheTransactionObject transactionObject = new CacheTransactionObject();
            transactionObject.setHolder(cacheHolder);
            return transactionObject;
        }

        public boolean isHolding() {
            return this.getHolder() != null;
        }

        public CacheHolder getHolder() {
            return this.cacheHolder;
        }

        public void setHolder(CacheHolder holder) {
            this.cacheHolder = holder;
        }

        public CacheHolder setAndGetHolder(CacheHolder holder) {
            this.setHolder(holder);
            return this.getHolder();
        }

        public CacheHolder setAndReturnExistingHolder(CacheHolder cacheHolder) {
            CacheHolder existingHolder = this.getHolder();
            this.setHolder(cacheHolder);
            return existingHolder;
        }
    }
}

