/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.springframework.util.ObjectUtils;

public abstract class ArrayUtils {
    public static <T> T[] asArray(T ... elements) {
        return elements;
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultArray) {
        return !ObjectUtils.isEmpty((Object[])array) ? array : defaultArray;
    }

    public static <T> T getFirst(T ... array) {
        return ArrayUtils.getFirst(array, null);
    }

    public static <T> T getFirst(T[] array, T defaultValue) {
        return ArrayUtils.isEmpty(array) ? defaultValue : array[0];
    }

    public static Object[] insert(Object[] originalArray, int position, Object element) {
        Object[] newArray = (Object[])Array.newInstance(originalArray.getClass().getComponentType(), originalArray.length + 1);
        if (position > 0) {
            System.arraycopy(originalArray, 0, newArray, 0, position);
        }
        newArray[position] = element;
        if (position < originalArray.length) {
            System.arraycopy(originalArray, position, newArray, position + 1, originalArray.length - position);
        }
        return newArray;
    }

    public static boolean isEmpty(Object[] array) {
        return ArrayUtils.length(array) == 0;
    }

    public static int length(Object[] array) {
        return array != null ? array.length : 0;
    }

    public static <T> T[] nullSafeArray(T[] array, Class<T> componentType) {
        return array != null ? array : (Object[])Array.newInstance(componentType, 0);
    }

    public static Object[] remove(Object[] originalArray, int position) {
        Object[] newArray = (Object[])Array.newInstance(originalArray.getClass().getComponentType(), originalArray.length - 1);
        if (position > 0) {
            System.arraycopy(originalArray, 0, newArray, 0, position);
        }
        if (position < originalArray.length - 1) {
            System.arraycopy(originalArray, position + 1, newArray, position, originalArray.length - 1 - position);
        }
        return newArray;
    }

    public static <T extends Comparable<T>> T[] sort(T[] array) {
        Arrays.sort(array);
        return array;
    }
}

