/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class AbstractRegionParser
extends AbstractSingleBeanDefinitionParser {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    AbstractRegionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return this.getRegionFactoryClass();
    }

    protected abstract Class<?> getRegionFactoryClass();

    protected String getParentName(Element element) {
        String regionTemplate = element.getAttribute("template");
        return StringUtils.hasText((String)regionTemplate) ? regionTemplate : super.getParentName(element);
    }

    protected boolean isRegionTemplate(Element element) {
        String localName = element.getLocalName();
        return localName != null && localName.endsWith("-template");
    }

    protected boolean isSubRegion(Element element) {
        String localName = element.getParentNode().getLocalName();
        return localName != null && localName.endsWith("region");
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        builder.setAbstract(this.isRegionTemplate(element));
        this.doParseRegion(element, parserContext, builder, this.isSubRegion(element));
    }

    protected abstract void doParseRegion(Element var1, ParserContext var2, BeanDefinitionBuilder var3, boolean var4);

    protected void doParseRegionConfiguration(Element element, ParserContext parserContext, BeanDefinitionBuilder regionBuilder, BeanDefinitionBuilder regionAttributesBuilder, boolean subRegion) {
        this.mergeRegionTemplateAttributes(element, parserContext, regionBuilder, regionAttributesBuilder);
        String resolvedCacheRef = ParsingUtils.resolveCacheReference(element.getAttribute("cache-ref"));
        if (!subRegion) {
            regionBuilder.addPropertyReference("cache", resolvedCacheRef);
            ParsingUtils.setPropertyValue(element, regionBuilder, "close");
            ParsingUtils.setPropertyValue(element, regionBuilder, "destroy");
        }
        ParsingUtils.setPropertyValue(element, regionBuilder, "name");
        ParsingUtils.setPropertyValue(element, regionBuilder, "ignore-if-exists", "lookupEnabled");
        ParsingUtils.setPropertyValue(element, regionBuilder, "data-policy");
        ParsingUtils.setPropertyValue(element, regionBuilder, "persistent");
        ParsingUtils.setPropertyValue(element, regionBuilder, "shortcut");
        if (StringUtils.hasText((String)element.getAttribute("disk-store-ref"))) {
            ParsingUtils.setPropertyValue(element, regionBuilder, "disk-store-ref", "diskStoreName");
            regionBuilder.addDependsOn(element.getAttribute("disk-store-ref"));
        }
        ParsingUtils.parseOptionalRegionAttributes(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseSubscription(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseStatistics(element, regionAttributesBuilder);
        ParsingUtils.parseMembershipAttributes(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseExpiration(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseEviction(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseCompressor(parserContext, element, regionAttributesBuilder);
        String enableGateway = element.getAttribute("enable-gateway");
        String hubId = element.getAttribute("hub-id");
        if (StringUtils.hasText((String)enableGateway) && GemfireUtils.isGemfireVersion7OrAbove()) {
            this.log.warn((Object)"'enable-gateway' has been deprecated since Gemfire 7.0");
        }
        ParsingUtils.setPropertyValue(element, regionBuilder, "enable-gateway");
        if (StringUtils.hasText((String)hubId)) {
            if (GemfireUtils.isGemfireVersion7OrAbove()) {
                this.log.warn((Object)"'hub-id' has been deprecated since Gemfire 7.0");
            }
            if (!CollectionUtils.isEmpty((Collection)DomUtils.getChildElementsByTagName((Element)element, (String)"gateway-sender"))) {
                parserContext.getReaderContext().error("specifying both 'hub-id' and 'gateway-sender' is invalid", (Object)element);
            }
        }
        ParsingUtils.setPropertyValue(element, regionBuilder, "hub-id");
        this.parseCollectionOfCustomSubElements(element, parserContext, regionBuilder, AsyncEventQueue.class.getName(), "async-event-queue", "asyncEventQueues");
        this.parseCollectionOfCustomSubElements(element, parserContext, regionBuilder, GatewaySender.class.getName(), "gateway-sender", "gatewaySenders");
        List subElements = DomUtils.getChildElements((Element)element);
        for (Element subElement : subElements) {
            if (subElement.getLocalName().equals("cache-listener")) {
                regionBuilder.addPropertyValue("cacheListeners", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, regionBuilder));
                continue;
            }
            if (subElement.getLocalName().equals("cache-loader")) {
                regionBuilder.addPropertyValue("cacheLoader", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, subElement, regionBuilder));
                continue;
            }
            if (!subElement.getLocalName().equals("cache-writer")) continue;
            regionBuilder.addPropertyValue("cacheWriter", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, subElement, regionBuilder));
        }
        if (!subRegion) {
            this.parseSubRegions(element, parserContext, resolvedCacheRef);
        }
    }

    void mergeRegionTemplateAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder regionBuilder, BeanDefinitionBuilder regionAttributesBuilder) {
        String regionTemplateName = this.getParentName(element);
        if (StringUtils.hasText((String)regionTemplateName)) {
            if (parserContext.getRegistry().containsBeanDefinition(regionTemplateName)) {
                BeanDefinition templateRegion = parserContext.getRegistry().getBeanDefinition(regionTemplateName);
                BeanDefinition templateRegionAttributes = this.getRegionAttributesBeanDefinition(templateRegion);
                if (templateRegionAttributes != null) {
                    regionAttributesBuilder.getRawBeanDefinition().overrideFrom(templateRegionAttributes);
                }
            } else {
                parserContext.getReaderContext().error(String.format("The Region template [%1$s] must be 'defined before' the Region [%2$s] referring to the template!", regionTemplateName, this.resolveId(element, regionBuilder.getRawBeanDefinition(), parserContext)), (Object)element);
            }
        }
    }

    BeanDefinition getRegionAttributesBeanDefinition(BeanDefinition region) {
        Assert.notNull((Object)region, (String)"BeanDefinition must not be null");
        Object regionAttributes = null;
        if (region.getPropertyValues().contains("attributes")) {
            PropertyValue attributesProperty = region.getPropertyValues().getPropertyValue("attributes");
            regionAttributes = attributesProperty.getValue();
        }
        return regionAttributes instanceof BeanDefinition ? (BeanDefinition)regionAttributes : null;
    }

    protected void parseCollectionOfCustomSubElements(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String className, String subElementName, String propertyName) {
        List subElements = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{subElementName, subElementName + "-ref"});
        if (!CollectionUtils.isEmpty((Collection)subElements)) {
            ManagedArray array = new ManagedArray(className, subElements.size());
            for (Element subElement : subElements) {
                array.add(ParsingUtils.parseRefOrNestedCustomElement(parserContext, subElement, builder));
            }
            builder.addPropertyValue(propertyName, (Object)array);
        }
    }

    protected void parseSubRegions(Element element, ParserContext parserContext, String resolvedCacheRef) {
        HashMap<String, Element> allSubRegionElements = new HashMap<String, Element>();
        this.findSubRegionElements(element, this.getRegionNameFromElement(element), allSubRegionElements);
        if (!CollectionUtils.isEmpty(allSubRegionElements)) {
            for (Map.Entry entry : allSubRegionElements.entrySet()) {
                this.parseSubRegion((Element)entry.getValue(), parserContext, (String)entry.getKey(), resolvedCacheRef);
            }
        }
    }

    private void findSubRegionElements(Element parent, String parentPath, Map<String, Element> allSubRegionElements) {
        for (Element element : DomUtils.getChildElements((Element)parent)) {
            if (!element.getLocalName().endsWith("region")) continue;
            String subRegionName = this.getRegionNameFromElement(element);
            String subRegionPath = this.buildSubRegionPath(parentPath, subRegionName);
            allSubRegionElements.put(subRegionPath, element);
            this.findSubRegionElements(element, subRegionPath, allSubRegionElements);
        }
    }

    private String getRegionNameFromElement(Element element) {
        String name = element.getAttribute("name");
        return StringUtils.hasText((String)name) ? name : element.getAttribute("id");
    }

    private String buildSubRegionPath(String parentName, String regionName) {
        String regionPath = StringUtils.arrayToDelimitedString((Object[])new String[]{parentName, regionName}, (String)"/");
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        return regionPath;
    }

    private BeanDefinition parseSubRegion(Element element, ParserContext parserContext, String subRegionPath, String cacheRef) {
        String parentBeanName = this.getParentRegionPathFrom(subRegionPath);
        String regionName = this.getRegionNameFromElement(element);
        element.setAttribute("id", subRegionPath);
        element.setAttribute("name", subRegionPath);
        BeanDefinition beanDefinition = parserContext.getDelegate().parseCustomElement(element);
        beanDefinition.getPropertyValues().add("cache", (Object)new RuntimeBeanReference(cacheRef));
        beanDefinition.getPropertyValues().add("parent", (Object)new RuntimeBeanReference(parentBeanName));
        beanDefinition.getPropertyValues().add("regionName", (Object)regionName);
        return beanDefinition;
    }

    private String getParentRegionPathFrom(String regionPath) {
        int index = regionPath.lastIndexOf("/");
        String parentPath = regionPath.substring(0, index);
        if (parentPath.lastIndexOf("/") == 0) {
            parentPath = parentPath.substring(1);
        }
        return parentPath;
    }

    protected void validateDataPolicyShortcutAttributesMutualExclusion(Element element, ParserContext parserContext) {
        if (element.hasAttribute("data-policy") && element.hasAttribute("shortcut")) {
            parserContext.getReaderContext().error(String.format("Only one of [data-policy, shortcut] may be specified with element '%1$s'.", element.getTagName()), (Object)element);
        }
    }
}

