/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import com.gemstone.gemfire.cache.Region;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class GemfireCache
implements Cache {
    private final Region region;

    public GemfireCache(Region<?, ?> region) {
        this.region = region;
    }

    public String getName() {
        return this.region.getName();
    }

    public Region<?, ?> getNativeCache() {
        return this.region;
    }

    public void clear() {
        this.region.clear();
    }

    public void evict(Object key) {
        this.region.destroy(key);
    }

    public Cache.ValueWrapper get(Object key) {
        Object value = this.region.get(key);
        return value == null ? null : new SimpleValueWrapper(value);
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.region.get(key);
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException(String.format("Cached value is not of required type [%1$s]: %2$s", type.getName(), value));
        }
        return (T)value;
    }

    public void put(Object key, Object value) {
        if (value != null) {
            this.region.put(key, value);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object existingValue = this.region.putIfAbsent(key, value);
        return existingValue == null ? null : new SimpleValueWrapper(existingValue);
    }
}

