/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.envers.repository.support;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.hibernate.envers.DefaultRevisionEntity;
import org.jspecify.annotations.Nullable;
import org.springframework.data.envers.repository.support.DefaultRevisionEntityInformation;
import org.springframework.data.envers.repository.support.EnversRevisionRepositoryImpl;
import org.springframework.data.envers.repository.support.ReflectionRevisionEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.data.repository.history.support.RevisionEntityInformation;

public class EnversRevisionRepositoryFactoryBean<T extends RevisionRepository<S, ID, N>, S, ID, N extends Number>
extends JpaRepositoryFactoryBean<T, S, ID> {
    private @Nullable Class<?> revisionEntityClass;

    public EnversRevisionRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setRevisionEntityClass(Class<?> revisionEntityClass) {
        this.revisionEntityClass = revisionEntityClass;
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        return new RevisionRepositoryFactory(entityManager, this.revisionEntityClass);
    }

    private static class RevisionRepositoryFactory<T, ID, N extends Number>
    extends JpaRepositoryFactory {
        private final RevisionEntityInformation revisionEntityInformation;
        private final EntityManager entityManager;

        public RevisionRepositoryFactory(EntityManager entityManager, @Nullable Class<?> revisionEntityClass) {
            super(entityManager);
            this.entityManager = entityManager;
            this.revisionEntityInformation = Optional.ofNullable(revisionEntityClass).filter(it -> !it.equals(DefaultRevisionEntity.class)).map(ReflectionRevisionEntityInformation::new).orElse(DefaultRevisionEntityInformation.INSTANCE);
        }

        protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
            Object fragmentImplementation = this.instantiateClass(EnversRevisionRepositoryImpl.class, new Object[]{this.getEntityInformation(metadata.getDomainType()), this.revisionEntityInformation, this.entityManager});
            return RepositoryComposition.RepositoryFragments.just((Object[])new Object[]{fragmentImplementation}).append(super.getRepositoryFragments(metadata));
        }
    }
}

