/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.envers.repository.support;

import javax.persistence.EntityManager;
import org.hibernate.envers.DefaultRevisionEntity;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.envers.repository.support.DefaultRevisionEntityInformation;
import org.springframework.data.envers.repository.support.EnversRevisionRepositoryImpl;
import org.springframework.data.envers.repository.support.ReflectionRevisionEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.data.repository.history.support.RevisionEntityInformation;

public class EnversRevisionRepositoryFactoryBean<T extends RevisionRepository<S, ID, N>, S, ID, N extends Number>
extends JpaRepositoryFactoryBean<T, S, ID> {
    private Class<?> revisionEntityClass;

    public EnversRevisionRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setRevisionEntityClass(Class<?> revisionEntityClass) {
        this.revisionEntityClass = revisionEntityClass;
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        return new RevisionRepositoryFactory(entityManager, this.revisionEntityClass);
    }

    private static class RevisionRepositoryFactory<T, ID, N extends Number>
    extends JpaRepositoryFactory {
        private final RevisionEntityInformation revisionEntityInformation;
        private final EntityManager entityManager;

        public RevisionRepositoryFactory(EntityManager entityManager, Class<?> revisionEntityClass) {
            super(entityManager);
            this.entityManager = entityManager;
            revisionEntityClass = revisionEntityClass == null ? DefaultRevisionEntity.class : revisionEntityClass;
            this.revisionEntityInformation = DefaultRevisionEntity.class.equals(revisionEntityClass) ? new DefaultRevisionEntityInformation() : new ReflectionRevisionEntityInformation(revisionEntityClass);
        }

        protected EnversRevisionRepositoryImpl getTargetRepository(RepositoryInformation information) {
            JpaEntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
            return new EnversRevisionRepositoryImpl(entityInformation, this.revisionEntityInformation, this.entityManager);
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            return EnversRevisionRepositoryImpl.class;
        }

        public <T> T getRepository(Class<T> repositoryInterface, Object customImplementation) {
            if (RevisionRepository.class.isAssignableFrom(repositoryInterface)) {
                Class[] typeArguments = GenericTypeResolver.resolveTypeArguments(repositoryInterface, RevisionRepository.class);
                Class revisionNumberType = typeArguments[2];
                if (!this.revisionEntityInformation.getRevisionNumberType().equals(revisionNumberType)) {
                    throw new IllegalStateException(String.format("Configured a revision entity type of %s with a revision type of %s but the repository interface is typed to a revision type of %s!", repositoryInterface, this.revisionEntityInformation.getRevisionNumberType(), revisionNumberType));
                }
            }
            return (T)super.getRepository(repositoryInterface, customImplementation);
        }
    }
}

