/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.utils.geohash;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import org.springframework.data.elasticsearch.utils.geohash.Geometry;
import org.springframework.data.elasticsearch.utils.geohash.GeometryValidator;
import org.springframework.data.elasticsearch.utils.geohash.GeometryVisitor;
import org.springframework.data.elasticsearch.utils.geohash.Point;
import org.springframework.data.elasticsearch.utils.geohash.Rectangle;
import org.springframework.data.elasticsearch.utils.geohash.StandardValidator;

public class WellKnownText {
    public static final WellKnownText INSTANCE = new WellKnownText(true, new StandardValidator(true));
    public static final String EMPTY = "EMPTY";
    public static final String SPACE = " ";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    public static final String COMMA = ",";
    public static final String NAN = "NaN";
    private static final String NUMBER = "<NUMBER>";
    private static final String EOF = "END-OF-STREAM";
    private static final String EOL = "END-OF-LINE";
    private final boolean coerce;
    private final GeometryValidator validator;

    public WellKnownText(boolean coerce, GeometryValidator validator) {
        this.coerce = coerce;
        this.validator = validator;
    }

    public String toWKT(Geometry geometry) {
        StringBuilder builder = new StringBuilder();
        this.toWKT(geometry, builder);
        return builder.toString();
    }

    public void toWKT(Geometry geometry, final StringBuilder sb) {
        sb.append(WellKnownText.getWKTName(geometry));
        sb.append(SPACE);
        if (geometry.isEmpty()) {
            sb.append(EMPTY);
        } else {
            geometry.visit(new GeometryVisitor<Void, RuntimeException>(){
                final /* synthetic */ WellKnownText this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Void visit(Point point) {
                    if (point.isEmpty()) {
                        sb.append(WellKnownText.EMPTY);
                    } else {
                        sb.append(WellKnownText.LPAREN);
                        this.visitPoint(point.getX(), point.getY(), point.getZ());
                        sb.append(WellKnownText.RPAREN);
                    }
                    return null;
                }

                private void visitPoint(double lon, double lat, double alt) {
                    sb.append(lon).append(WellKnownText.SPACE).append(lat);
                    if (!Double.isNaN(alt)) {
                        sb.append(WellKnownText.SPACE).append(alt);
                    }
                }

                @Override
                public Void visit(Rectangle rectangle) {
                    sb.append(WellKnownText.LPAREN);
                    sb.append(rectangle.getMinX());
                    sb.append(WellKnownText.COMMA);
                    sb.append(WellKnownText.SPACE);
                    sb.append(rectangle.getMaxX());
                    sb.append(WellKnownText.COMMA);
                    sb.append(WellKnownText.SPACE);
                    sb.append(rectangle.getMaxY());
                    sb.append(WellKnownText.COMMA);
                    sb.append(WellKnownText.SPACE);
                    sb.append(rectangle.getMinY());
                    if (rectangle.hasZ()) {
                        sb.append(WellKnownText.COMMA);
                        sb.append(WellKnownText.SPACE);
                        sb.append(rectangle.getMinZ());
                        sb.append(WellKnownText.COMMA);
                        sb.append(WellKnownText.SPACE);
                        sb.append(rectangle.getMaxZ());
                    }
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }
            });
        }
    }

    public Geometry fromWKT(String wkt) throws IOException, ParseException {
        try (StringReader reader = new StringReader(wkt);){
            StreamTokenizer tokenizer = new StreamTokenizer(reader);
            tokenizer.resetSyntax();
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(160, 255);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(43, 43);
            tokenizer.wordChars(46, 46);
            tokenizer.whitespaceChars(32, 32);
            tokenizer.whitespaceChars(9, 9);
            tokenizer.whitespaceChars(13, 13);
            tokenizer.whitespaceChars(10, 10);
            tokenizer.commentChar(35);
            Geometry geometry = this.parseGeometry(tokenizer);
            this.validator.validate(geometry);
            Geometry geometry2 = geometry;
            return geometry2;
        }
    }

    private Geometry parseGeometry(StreamTokenizer stream) throws IOException, ParseException {
        String type;
        return switch (type = this.nextWord(stream).toLowerCase(Locale.ROOT)) {
            case "point" -> this.parsePoint(stream);
            case "bbox" -> this.parseBBox(stream);
            default -> throw new IllegalArgumentException("Unknown geometry type: " + type);
        };
    }

    private Point parsePoint(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return Point.EMPTY;
        }
        double lon = this.nextNumber(stream);
        double lat = this.nextNumber(stream);
        Point pt = this.isNumberNext(stream) ? new Point(lon, lat, this.nextNumber(stream)) : new Point(lon, lat);
        this.nextCloser(stream);
        return pt;
    }

    private void parseCoordinates(StreamTokenizer stream, ArrayList<Double> lats, ArrayList<Double> lons, ArrayList<Double> alts) throws IOException, ParseException {
        this.parseCoordinate(stream, lats, lons, alts);
        while (this.nextCloserOrComma(stream).equals(COMMA)) {
            this.parseCoordinate(stream, lats, lons, alts);
        }
    }

    private void parseCoordinate(StreamTokenizer stream, ArrayList<Double> lats, ArrayList<Double> lons, ArrayList<Double> alts) throws IOException, ParseException {
        lons.add(this.nextNumber(stream));
        lats.add(this.nextNumber(stream));
        if (this.isNumberNext(stream)) {
            alts.add(this.nextNumber(stream));
        }
        if (!alts.isEmpty() && alts.size() != lons.size()) {
            throw new ParseException("coordinate dimensions do not match: " + this.tokenString(stream), stream.lineno());
        }
    }

    private Rectangle parseBBox(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return Rectangle.EMPTY;
        }
        double minLon = this.nextNumber(stream);
        this.nextComma(stream);
        double maxLon = this.nextNumber(stream);
        this.nextComma(stream);
        double maxLat = this.nextNumber(stream);
        this.nextComma(stream);
        double minLat = this.nextNumber(stream);
        this.nextCloser(stream);
        return new Rectangle(minLon, maxLon, maxLat, minLat);
    }

    private String nextWord(StreamTokenizer stream) throws ParseException, IOException {
        return switch (stream.nextToken()) {
            case -3 -> {
                String word = stream.sval;
                if (word.equalsIgnoreCase(EMPTY)) {
                    yield EMPTY;
                }
                yield word;
            }
            case 40 -> LPAREN;
            case 41 -> RPAREN;
            case 44 -> COMMA;
            default -> throw new ParseException("expected word but found: " + this.tokenString(stream), stream.lineno());
        };
    }

    private double nextNumber(StreamTokenizer stream) throws IOException, ParseException {
        if (stream.nextToken() == -3) {
            if (stream.sval.equalsIgnoreCase(NAN)) {
                return Double.NaN;
            }
            try {
                return Double.parseDouble(stream.sval);
            }
            catch (NumberFormatException e) {
                throw new ParseException("invalid number found: " + stream.sval, stream.lineno());
            }
        }
        throw new ParseException("expected number but found: " + this.tokenString(stream), stream.lineno());
    }

    private String tokenString(StreamTokenizer stream) {
        return switch (stream.ttype) {
            case -3 -> stream.sval;
            case -1 -> EOF;
            case 10 -> EOL;
            case -2 -> NUMBER;
            default -> "'" + (char)stream.ttype + "'";
        };
    }

    private boolean isNumberNext(StreamTokenizer stream) throws IOException {
        int type = stream.nextToken();
        stream.pushBack();
        return type == -3;
    }

    private String nextEmptyOrOpen(StreamTokenizer stream) throws IOException, ParseException {
        String next = this.nextWord(stream);
        if (next.equals(EMPTY) || next.equals(LPAREN)) {
            return next;
        }
        throw new ParseException("expected EMPTY or ( but found: " + this.tokenString(stream), stream.lineno());
    }

    private String nextCloser(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextWord(stream).equals(RPAREN)) {
            return RPAREN;
        }
        throw new ParseException("expected ) but found: " + this.tokenString(stream), stream.lineno());
    }

    private String nextComma(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextWord(stream).equals(COMMA)) {
            return COMMA;
        }
        throw new ParseException("expected , but found: " + this.tokenString(stream), stream.lineno());
    }

    private String nextOpener(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextWord(stream).equals(LPAREN)) {
            return LPAREN;
        }
        throw new ParseException("expected ( but found: " + this.tokenString(stream), stream.lineno());
    }

    private String nextCloserOrComma(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextWord(stream);
        if (token.equals(COMMA) || token.equals(RPAREN)) {
            return token;
        }
        throw new ParseException("expected , or ) but found: " + this.tokenString(stream), stream.lineno());
    }

    private static String getWKTName(Geometry geometry) {
        return geometry.visit(new GeometryVisitor<String, RuntimeException>(){

            @Override
            public String visit(Point point) {
                return "POINT";
            }

            @Override
            public String visit(Rectangle rectangle) {
                return "BBOX";
            }
        });
    }
}

