/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.reindex;

import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.reindex.Remote;
import org.springframework.util.Assert;

public class ReindexRequest {
    private final Source source;
    private final Dest dest;
    private final @Nullable Long maxDocs;
    private final @Nullable Conflicts conflicts;
    private final @Nullable Script script;
    private final @Nullable Duration timeout;
    private final @Nullable Boolean requireAlias;
    private final @Nullable Boolean refresh;
    private final @Nullable String waitForActiveShards;
    private final @Nullable Long requestsPerSecond;
    private final @Nullable Duration scroll;
    private final @Nullable Long slices;

    private ReindexRequest(Source source, Dest dest, @Nullable Long maxDocs, @Nullable Conflicts conflicts, @Nullable Script script, @Nullable Duration timeout, @Nullable Boolean requireAlias, @Nullable Boolean refresh, @Nullable String waitForActiveShards, @Nullable Long requestsPerSecond, @Nullable Duration scroll, @Nullable Long slices) {
        Assert.notNull((Object)source, (String)"source must not be null");
        Assert.notNull((Object)dest, (String)"dest must not be null");
        this.source = source;
        this.dest = dest;
        this.maxDocs = maxDocs;
        this.conflicts = conflicts;
        this.script = script;
        this.timeout = timeout;
        this.requireAlias = requireAlias;
        this.refresh = refresh;
        this.waitForActiveShards = waitForActiveShards;
        this.requestsPerSecond = requestsPerSecond;
        this.scroll = scroll;
        this.slices = slices;
    }

    public @Nullable Long getMaxDocs() {
        return this.maxDocs;
    }

    public Source getSource() {
        return this.source;
    }

    public Dest getDest() {
        return this.dest;
    }

    public @Nullable Script getScript() {
        return this.script;
    }

    public @Nullable Conflicts getConflicts() {
        return this.conflicts;
    }

    public @Nullable Boolean getRequireAlias() {
        return this.requireAlias;
    }

    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    public @Nullable Boolean getRefresh() {
        return this.refresh;
    }

    public @Nullable String getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    public @Nullable Long getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public @Nullable Duration getScroll() {
        return this.scroll;
    }

    public @Nullable Long getSlices() {
        return this.slices;
    }

    public static ReindexRequestBuilder builder(IndexCoordinates sourceIndex, IndexCoordinates destIndex) {
        return new ReindexRequestBuilder(sourceIndex, destIndex);
    }

    public static class Source {
        private final IndexCoordinates indexes;
        private @Nullable Query query;
        private @Nullable Remote remote;
        private @Nullable Slice slice;
        private @Nullable Integer size;
        private @Nullable SourceFilter sourceFilter;

        private Source(IndexCoordinates indexes) {
            Assert.notNull((Object)indexes, (String)"indexes must not be null");
            this.indexes = indexes;
        }

        public IndexCoordinates getIndexes() {
            return this.indexes;
        }

        public @Nullable Remote getRemote() {
            return this.remote;
        }

        public @Nullable Query getQuery() {
            return this.query;
        }

        public @Nullable Integer getSize() {
            return this.size;
        }

        public @Nullable Slice getSlice() {
            return this.slice;
        }

        public @Nullable SourceFilter getSourceFilter() {
            return this.sourceFilter;
        }
    }

    public static class Dest {
        private final IndexCoordinates index;
        private @Nullable String pipeline;
        private @Nullable String routing;
        private  @Nullable Document.VersionType versionType;
        private  @Nullable IndexQuery.OpType opType;

        private Dest(IndexCoordinates index) {
            Assert.notNull((Object)index, (String)"dest index must not be null");
            this.index = index;
        }

        public IndexCoordinates getIndex() {
            return this.index;
        }

        public  @Nullable Document.VersionType getVersionType() {
            return this.versionType;
        }

        public  @Nullable IndexQuery.OpType getOpType() {
            return this.opType;
        }

        public @Nullable String getPipeline() {
            return this.pipeline;
        }

        public @Nullable String getRouting() {
            return this.routing;
        }
    }

    public static enum Conflicts {
        PROCEED("proceed"),
        ABORT("abort");

        private final String esName;

        private Conflicts(String esName) {
            this.esName = esName;
        }

        public String getEsName() {
            return this.esName;
        }
    }

    public static class Script {
        private final @Nullable String source;
        private final @Nullable String lang;

        private Script(@Nullable String source, @Nullable String lang) {
            this.source = source;
            this.lang = lang;
        }

        public @Nullable String getSource() {
            return this.source;
        }

        public @Nullable String getLang() {
            return this.lang;
        }
    }

    public static final class ReindexRequestBuilder {
        private final Source source;
        private final Dest dest;
        private @Nullable Long maxDocs;
        private @Nullable Conflicts conflicts;
        private @Nullable Script script;
        private @Nullable Duration timeout;
        private @Nullable Boolean requireAlias;
        private @Nullable Boolean refresh;
        private @Nullable String waitForActiveShards;
        private @Nullable Long requestsPerSecond;
        private @Nullable Duration scroll;
        private @Nullable Long slices;

        public ReindexRequestBuilder(IndexCoordinates sourceIndex, IndexCoordinates destIndex) {
            Assert.notNull((Object)sourceIndex, (String)"sourceIndex must not be null");
            Assert.notNull((Object)destIndex, (String)"destIndex must not be null");
            this.source = new Source(sourceIndex);
            this.dest = new Dest(destIndex);
        }

        public ReindexRequestBuilder withMaxDocs(@Nullable Long maxDocs) {
            this.maxDocs = maxDocs;
            return this;
        }

        public ReindexRequestBuilder withConflicts(Conflicts conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public ReindexRequestBuilder withSourceQuery(Query query) {
            this.source.query = query;
            return this;
        }

        public ReindexRequestBuilder withSourceSlice(int id, int max) {
            this.source.slice = new Slice(id, max);
            return this;
        }

        public ReindexRequestBuilder withSourceRemote(Remote remote) {
            this.source.remote = remote;
            return this;
        }

        public ReindexRequestBuilder withSourceSize(int size) {
            this.source.size = size;
            return this;
        }

        public ReindexRequestBuilder withSourceSourceFilter(SourceFilter sourceFilter) {
            this.source.sourceFilter = sourceFilter;
            return this;
        }

        public ReindexRequestBuilder withDestPipeline(String pipelineName) {
            this.dest.pipeline = pipelineName;
            return this;
        }

        public ReindexRequestBuilder withDestRouting(String routing) {
            this.dest.routing = routing;
            return this;
        }

        public ReindexRequestBuilder withDestVersionType(Document.VersionType versionType) {
            this.dest.versionType = versionType;
            return this;
        }

        public ReindexRequestBuilder withDestOpType(IndexQuery.OpType opType) {
            this.dest.opType = opType;
            return this;
        }

        public ReindexRequestBuilder withScript(String source, @Nullable String lang) {
            this.script = new Script(source, lang);
            return this;
        }

        public ReindexRequestBuilder withTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public ReindexRequestBuilder withRequireAlias(boolean requireAlias) {
            this.requireAlias = requireAlias;
            return this;
        }

        public ReindexRequestBuilder withRefresh(boolean refresh) {
            this.refresh = refresh;
            return this;
        }

        public ReindexRequestBuilder withWaitForActiveShards(String waitForActiveShards) {
            this.waitForActiveShards = waitForActiveShards;
            return this;
        }

        public ReindexRequestBuilder withRequestsPerSecond(long requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond;
            return this;
        }

        public ReindexRequestBuilder withScroll(Duration scroll) {
            this.scroll = scroll;
            return this;
        }

        public ReindexRequestBuilder withSlices(long slices) {
            this.slices = slices;
            return this;
        }

        public ReindexRequest build() {
            return new ReindexRequest(this.source, this.dest, this.maxDocs, this.conflicts, this.script, this.timeout, this.requireAlias, this.refresh, this.waitForActiveShards, this.requestsPerSecond, this.scroll, this.slices);
        }
    }

    public static class Slice {
        private final int id;
        private final int max;

        private Slice(int id, int max) {
            this.id = id;
            this.max = max;
        }

        public int getId() {
            return this.id;
        }

        public int getMax() {
            return this.max;
        }
    }
}

