/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.ClearScrollRequest;
import co.elastic.clients.elasticsearch.core.ClearScrollResponse;
import co.elastic.clients.elasticsearch.core.ClosePointInTimeRequest;
import co.elastic.clients.elasticsearch.core.ClosePointInTimeResponse;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.CountResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.DeleteScriptRequest;
import co.elastic.clients.elasticsearch.core.DeleteScriptResponse;
import co.elastic.clients.elasticsearch.core.ExistsRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.GetScriptRequest;
import co.elastic.clients.elasticsearch.core.GetScriptResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.InfoRequest;
import co.elastic.clients.elasticsearch.core.InfoResponse;
import co.elastic.clients.elasticsearch.core.MgetRequest;
import co.elastic.clients.elasticsearch.core.MgetResponse;
import co.elastic.clients.elasticsearch.core.OpenPointInTimeRequest;
import co.elastic.clients.elasticsearch.core.OpenPointInTimeResponse;
import co.elastic.clients.elasticsearch.core.PingRequest;
import co.elastic.clients.elasticsearch.core.PutScriptRequest;
import co.elastic.clients.elasticsearch.core.PutScriptResponse;
import co.elastic.clients.elasticsearch.core.ReindexRequest;
import co.elastic.clients.elasticsearch.core.ReindexResponse;
import co.elastic.clients.elasticsearch.core.ScrollRequest;
import co.elastic.clients.elasticsearch.core.ScrollResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchTemplateRequest;
import co.elastic.clients.elasticsearch.core.SearchTemplateResponse;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.Transport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import co.elastic.clients.transport.endpoints.EndpointWithResponseMapperAttr;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClusterClient;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchIndicesClient;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchSqlClient;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveElasticsearchClient
extends ApiClient<ElasticsearchTransport, ReactiveElasticsearchClient>
implements AutoCloseable {
    public ReactiveElasticsearchClient(ElasticsearchTransport transport) {
        super((Transport)transport, null);
    }

    public ReactiveElasticsearchClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super((Transport)transport, transportOptions);
    }

    public ReactiveElasticsearchClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ReactiveElasticsearchClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public ReactiveElasticsearchClusterClient cluster() {
        return new ReactiveElasticsearchClusterClient((ElasticsearchTransport)this.transport, this.transportOptions);
    }

    public ReactiveElasticsearchIndicesClient indices() {
        return new ReactiveElasticsearchIndicesClient((ElasticsearchTransport)this.transport, this.transportOptions);
    }

    public ReactiveElasticsearchSqlClient sql() {
        return new ReactiveElasticsearchSqlClient((ElasticsearchTransport)this.transport, this.transportOptions);
    }

    public Mono<InfoResponse> info() {
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)InfoRequest._INSTANCE, InfoRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<BooleanResponse> ping() {
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)PingRequest._INSTANCE, PingRequest._ENDPOINT, this.transportOptions));
    }

    public <T> Mono<IndexResponse> index(IndexRequest<T> request) {
        Assert.notNull(request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync(request, IndexRequest._ENDPOINT, this.transportOptions));
    }

    public <T> Mono<IndexResponse> index(Function<IndexRequest.Builder<T>, ObjectBuilder<IndexRequest<T>>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.index((IndexRequest)fn.apply(new IndexRequest.Builder()).build());
    }

    public Mono<BulkResponse> bulk(BulkRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, BulkRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<BulkResponse> bulk(Function<BulkRequest.Builder, ObjectBuilder<BulkRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.bulk((BulkRequest)fn.apply(new BulkRequest.Builder()).build());
    }

    public <T> Mono<GetResponse<T>> get(GetRequest request, Class<T> tClass) {
        Assert.notNull((Object)request, (String)"request must not be null");
        SimpleEndpoint endpoint = GetRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr((JsonEndpoint)endpoint, "co.elastic.clients:Deserializer:_global.get.Response.TDocument", (Object)this.getDeserializer(tClass));
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, (Endpoint)endpoint, this.transportOptions));
    }

    public Mono<BooleanResponse> exists(ExistsRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, ExistsRequest._ENDPOINT, this.transportOptions));
    }

    public <T, P> Mono<UpdateResponse<T>> update(UpdateRequest<T, P> request, Class<T> clazz) {
        Assert.notNull(request, (String)"request must not be null");
        EndpointWithResponseMapperAttr endpoint = new EndpointWithResponseMapperAttr((JsonEndpoint)UpdateRequest._ENDPOINT, "co.elastic.clients:Deserializer:_global.update.Response.TDocument", (Object)this.getDeserializer(clazz));
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync(request, (Endpoint)endpoint, this.transportOptions));
    }

    public <T, P> Mono<UpdateResponse<T>> update(Function<UpdateRequest.Builder<T, P>, ObjectBuilder<UpdateRequest<T, P>>> fn, Class<T> clazz) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.update((UpdateRequest)fn.apply(new UpdateRequest.Builder()).build(), clazz);
    }

    public <T> Mono<GetResponse<T>> get(Function<GetRequest.Builder, ObjectBuilder<GetRequest>> fn, Class<T> tClass) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.get((GetRequest)fn.apply(new GetRequest.Builder()).build(), tClass);
    }

    public <T> Mono<MgetResponse<T>> mget(MgetRequest request, Class<T> clazz) {
        Assert.notNull((Object)request, (String)"request must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        SimpleEndpoint endpoint = MgetRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr((JsonEndpoint)endpoint, "co.elastic.clients:Deserializer:_global.mget.Response.TDocument", (Object)this.getDeserializer(clazz));
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, (Endpoint)endpoint, this.transportOptions));
    }

    public <T> Mono<MgetResponse<T>> mget(Function<MgetRequest.Builder, ObjectBuilder<MgetRequest>> fn, Class<T> clazz) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.mget((MgetRequest)fn.apply(new MgetRequest.Builder()).build(), clazz);
    }

    public Mono<ReindexResponse> reindex(ReindexRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, ReindexRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<ReindexResponse> reindex(Function<ReindexRequest.Builder, ObjectBuilder<ReindexRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.reindex((ReindexRequest)fn.apply(new ReindexRequest.Builder()).build());
    }

    public Mono<DeleteResponse> delete(DeleteRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, DeleteRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<DeleteResponse> delete(Function<DeleteRequest.Builder, ObjectBuilder<DeleteRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.delete((DeleteRequest)fn.apply(new DeleteRequest.Builder()).build());
    }

    public Mono<DeleteByQueryResponse> deleteByQuery(DeleteByQueryRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, DeleteByQueryRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<DeleteByQueryResponse> deleteByQuery(Function<DeleteByQueryRequest.Builder, ObjectBuilder<DeleteByQueryRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.deleteByQuery((DeleteByQueryRequest)fn.apply(new DeleteByQueryRequest.Builder()).build());
    }

    public Mono<CountResponse> count(CountRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, CountRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<CountResponse> count(Function<CountRequest.Builder, ObjectBuilder<CountRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.count((CountRequest)fn.apply(new CountRequest.Builder()).build());
    }

    public <T> Mono<ResponseBody<T>> search(SearchRequest request, Class<T> tDocumentClass) {
        Assert.notNull((Object)request, (String)"request must not be null");
        Assert.notNull(tDocumentClass, (String)"tDocumentClass must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, SearchRequest.createSearchEndpoint((JsonpDeserializer)this.getDeserializer(tDocumentClass)), this.transportOptions));
    }

    public <T> Mono<ResponseBody<T>> search(Function<SearchRequest.Builder, ObjectBuilder<SearchRequest>> fn, Class<T> tDocumentClass) {
        Assert.notNull(fn, (String)"fn must not be null");
        Assert.notNull(tDocumentClass, (String)"tDocumentClass must not be null");
        return this.search((SearchRequest)fn.apply(new SearchRequest.Builder()).build(), tDocumentClass);
    }

    public <T> Mono<SearchTemplateResponse<T>> searchTemplate(SearchTemplateRequest request, Class<T> tDocumentClass) {
        Assert.notNull((Object)request, (String)"request must not be null");
        Assert.notNull(tDocumentClass, (String)"tDocumentClass must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, SearchTemplateRequest.createSearchTemplateEndpoint((JsonpDeserializer)this.getDeserializer(tDocumentClass)), this.transportOptions));
    }

    public <T> Mono<SearchTemplateResponse<T>> searchTemplate(Function<SearchTemplateRequest.Builder, ObjectBuilder<SearchTemplateRequest>> fn, Class<T> tDocumentClass) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.searchTemplate((SearchTemplateRequest)fn.apply(new SearchTemplateRequest.Builder()).build(), tDocumentClass);
    }

    public <T> Mono<ScrollResponse<T>> scroll(ScrollRequest request, Class<T> tDocumentClass) {
        Assert.notNull((Object)request, (String)"request must not be null");
        Assert.notNull(tDocumentClass, (String)"tDocumentClass must not be null");
        SimpleEndpoint endpoint = ScrollRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr((JsonEndpoint)endpoint, "co.elastic.clients:Deserializer:_global.scroll.Response.TDocument", (Object)this.getDeserializer(tDocumentClass));
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, (Endpoint)endpoint, this.transportOptions));
    }

    public <T> Mono<ScrollResponse<T>> scroll(Function<ScrollRequest.Builder, ObjectBuilder<ScrollRequest>> fn, Class<T> tDocumentClass) {
        Assert.notNull(fn, (String)"fn must not be null");
        Assert.notNull(tDocumentClass, (String)"tDocumentClass must not be null");
        return this.scroll((ScrollRequest)fn.apply(new ScrollRequest.Builder()).build(), tDocumentClass);
    }

    public Mono<ClearScrollResponse> clearScroll(ClearScrollRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, ClearScrollRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<ClearScrollResponse> clearScroll(Function<ClearScrollRequest.Builder, ObjectBuilder<ClearScrollRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.clearScroll((ClearScrollRequest)fn.apply(new ClearScrollRequest.Builder()).build());
    }

    public Mono<OpenPointInTimeResponse> openPointInTime(OpenPointInTimeRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, OpenPointInTimeRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<OpenPointInTimeResponse> openPointInTime(Function<OpenPointInTimeRequest.Builder, ObjectBuilder<OpenPointInTimeRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.openPointInTime((OpenPointInTimeRequest)fn.apply(new OpenPointInTimeRequest.Builder()).build());
    }

    public Mono<ClosePointInTimeResponse> closePointInTime(ClosePointInTimeRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, ClosePointInTimeRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<ClosePointInTimeResponse> closePointInTime(Function<ClosePointInTimeRequest.Builder, ObjectBuilder<ClosePointInTimeRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.closePointInTime((ClosePointInTimeRequest)fn.apply(new ClosePointInTimeRequest.Builder()).build());
    }

    public Mono<PutScriptResponse> putScript(PutScriptRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, PutScriptRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<PutScriptResponse> putScript(Function<PutScriptRequest.Builder, ObjectBuilder<PutScriptRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.putScript((PutScriptRequest)fn.apply(new PutScriptRequest.Builder()).build());
    }

    public Mono<GetScriptResponse> getScript(GetScriptRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, GetScriptRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<GetScriptResponse> getScript(Function<GetScriptRequest.Builder, ObjectBuilder<GetScriptRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.getScript((GetScriptRequest)fn.apply(new GetScriptRequest.Builder()).build());
    }

    public Mono<DeleteScriptResponse> deleteScript(DeleteScriptRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((ElasticsearchTransport)this.transport).performRequestAsync((Object)request, DeleteScriptRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<DeleteScriptResponse> deleteScript(Function<DeleteScriptRequest.Builder, ObjectBuilder<DeleteScriptRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.deleteScript((DeleteScriptRequest)fn.apply(new DeleteScriptRequest.Builder()).build());
    }
}

