/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.reindex;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.ElasticsearchErrorCause;

public class ReindexResponse {
    private final long took;
    private final boolean timedOut;
    private final long total;
    private final long created;
    private final long updated;
    private final long deleted;
    private final long batches;
    private final long versionConflicts;
    private final long noops;
    private final long bulkRetries;
    private final long searchRetries;
    private final long throttledMillis;
    private final double requestsPerSecond;
    private final long throttledUntilMillis;
    private final List<Failure> failures;

    private ReindexResponse(long took, boolean timedOut, long total, long created, long updated, long deleted, long batches, long versionConflicts, long noops, long bulkRetries, long searchRetries, long throttledMillis, double requestsPerSecond, long throttledUntilMillis, List<Failure> failures) {
        this.took = took;
        this.timedOut = timedOut;
        this.total = total;
        this.created = created;
        this.updated = updated;
        this.deleted = deleted;
        this.batches = batches;
        this.versionConflicts = versionConflicts;
        this.noops = noops;
        this.bulkRetries = bulkRetries;
        this.searchRetries = searchRetries;
        this.throttledMillis = throttledMillis;
        this.requestsPerSecond = requestsPerSecond;
        this.throttledUntilMillis = throttledUntilMillis;
        this.failures = failures;
    }

    public long getTook() {
        return this.took;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public long getTotal() {
        return this.total;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdated() {
        return this.updated;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public long getBatches() {
        return this.batches;
    }

    public long getVersionConflicts() {
        return this.versionConflicts;
    }

    public long getNoops() {
        return this.noops;
    }

    public long getBulkRetries() {
        return this.bulkRetries;
    }

    public long getSearchRetries() {
        return this.searchRetries;
    }

    public long getThrottledMillis() {
        return this.throttledMillis;
    }

    public double getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public long getThrottledUntilMillis() {
        return this.throttledUntilMillis;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public static ReindexResponseBuilder builder() {
        return new ReindexResponseBuilder();
    }

    public static final class ReindexResponseBuilder {
        private long took;
        private boolean timedOut;
        private long total;
        private long created;
        private long updated;
        private long deleted;
        private long batches;
        private long versionConflicts;
        private long noops;
        private long bulkRetries;
        private long searchRetries;
        private long throttledMillis;
        private double requestsPerSecond;
        private long throttledUntilMillis;
        private List<Failure> failures = Collections.emptyList();

        private ReindexResponseBuilder() {
        }

        public ReindexResponseBuilder withTook(long took) {
            this.took = took;
            return this;
        }

        public ReindexResponseBuilder withTimedOut(boolean timedOut) {
            this.timedOut = timedOut;
            return this;
        }

        public ReindexResponseBuilder withTotal(long total) {
            this.total = total;
            return this;
        }

        public ReindexResponseBuilder withCreated(long created) {
            this.created = created;
            return this;
        }

        public ReindexResponseBuilder withUpdated(long updated) {
            this.updated = updated;
            return this;
        }

        public ReindexResponseBuilder withDeleted(long deleted) {
            this.deleted = deleted;
            return this;
        }

        public ReindexResponseBuilder withBatches(long batches) {
            this.batches = batches;
            return this;
        }

        public ReindexResponseBuilder withVersionConflicts(long versionConflicts) {
            this.versionConflicts = versionConflicts;
            return this;
        }

        public ReindexResponseBuilder withNoops(long noops) {
            this.noops = noops;
            return this;
        }

        public ReindexResponseBuilder withBulkRetries(long bulkRetries) {
            this.bulkRetries = bulkRetries;
            return this;
        }

        public ReindexResponseBuilder withSearchRetries(long searchRetries) {
            this.searchRetries = searchRetries;
            return this;
        }

        public ReindexResponseBuilder withThrottledMillis(long throttledMillis) {
            this.throttledMillis = throttledMillis;
            return this;
        }

        public ReindexResponseBuilder withRequestsPerSecond(double requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond;
            return this;
        }

        public ReindexResponseBuilder withThrottledUntilMillis(long throttledUntilMillis) {
            this.throttledUntilMillis = throttledUntilMillis;
            return this;
        }

        public ReindexResponseBuilder withFailures(List<Failure> failures) {
            this.failures = failures;
            return this;
        }

        public ReindexResponse build() {
            return new ReindexResponse(this.took, this.timedOut, this.total, this.created, this.updated, this.deleted, this.batches, this.versionConflicts, this.noops, this.bulkRetries, this.searchRetries, this.throttledMillis, this.requestsPerSecond, this.throttledUntilMillis, this.failures);
        }
    }

    public static class Failure {
        private final @Nullable String index;
        private final @Nullable String id;
        private final @Nullable Exception cause;
        private final @Nullable Integer status;
        private final @Nullable Long seqNo;
        private final @Nullable Long term;
        private final @Nullable Boolean aborted;
        private final @Nullable ElasticsearchErrorCause elasticsearchErrorCause;

        private Failure(@Nullable String index, @Nullable String id, @Nullable Exception cause, @Nullable Integer status, @Nullable Long seqNo, @Nullable Long term, @Nullable Boolean aborted, @Nullable ElasticsearchErrorCause elasticsearchErrorCause) {
            this.index = index;
            this.id = id;
            this.cause = cause;
            this.status = status;
            this.seqNo = seqNo;
            this.term = term;
            this.aborted = aborted;
            this.elasticsearchErrorCause = elasticsearchErrorCause;
        }

        public @Nullable String getIndex() {
            return this.index;
        }

        public @Nullable String getId() {
            return this.id;
        }

        public @Nullable Exception getCause() {
            return this.cause;
        }

        public @Nullable Integer getStatus() {
            return this.status;
        }

        public @Nullable Long getSeqNo() {
            return this.seqNo;
        }

        public @Nullable Long getTerm() {
            return this.term;
        }

        public @Nullable Boolean getAborted() {
            return this.aborted;
        }

        public @Nullable ElasticsearchErrorCause getElasticsearchErrorCause() {
            return this.elasticsearchErrorCause;
        }

        public static FailureBuilder builder() {
            return new FailureBuilder();
        }

        public static final class FailureBuilder {
            private @Nullable String index;
            private @Nullable String id;
            private @Nullable Exception cause;
            private @Nullable Integer status;
            private @Nullable Long seqNo;
            private @Nullable Long term;
            private @Nullable Boolean aborted;
            private @Nullable ElasticsearchErrorCause elasticsearchErrorCause;

            private FailureBuilder() {
            }

            public FailureBuilder withIndex(String index) {
                this.index = index;
                return this;
            }

            public FailureBuilder withId(String id) {
                this.id = id;
                return this;
            }

            public FailureBuilder withCause(@Nullable Exception cause) {
                this.cause = cause;
                return this;
            }

            public FailureBuilder withStatus(Integer status) {
                this.status = status;
                return this;
            }

            public FailureBuilder withSeqNo(Long seqNo) {
                this.seqNo = seqNo;
                return this;
            }

            public FailureBuilder withTerm(Long term) {
                this.term = term;
                return this;
            }

            public FailureBuilder withAborted(Boolean aborted) {
                this.aborted = aborted;
                return this;
            }

            public FailureBuilder withErrorCause(@Nullable ElasticsearchErrorCause elasticsearchErrorCause) {
                this.elasticsearchErrorCause = elasticsearchErrorCause;
                return this;
            }

            public Failure build() {
                return new Failure(this.index, this.id, this.cause, this.status, this.seqNo, this.term, this.aborted, this.elasticsearchErrorCause);
            }
        }
    }
}

