/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;

public class IndexQueryBuilder {
    private @Nullable String id;
    private @Nullable Object object;
    private @Nullable Long version;
    private @Nullable String source;
    private @Nullable Long seqNo;
    private @Nullable Long primaryTerm;
    private @Nullable String routing;
    private @Nullable IndexQuery.OpType opType;
    private @Nullable RefreshPolicy refreshPolicy;
    private @Nullable String indexName;

    public IndexQueryBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public IndexQueryBuilder withObject(Object object) {
        this.object = object;
        return this;
    }

    public IndexQueryBuilder withVersion(Long version) {
        this.version = version;
        return this;
    }

    public IndexQueryBuilder withSource(String source) {
        this.source = source;
        return this;
    }

    public IndexQueryBuilder withSeqNoPrimaryTerm(SeqNoPrimaryTerm seqNoPrimaryTerm) {
        this.seqNo = seqNoPrimaryTerm.sequenceNumber();
        this.primaryTerm = seqNoPrimaryTerm.primaryTerm();
        return this;
    }

    public IndexQueryBuilder withRouting(@Nullable String routing) {
        this.routing = routing;
        return this;
    }

    public IndexQueryBuilder withOpType(IndexQuery.OpType opType) {
        this.opType = opType;
        return this;
    }

    public IndexQuery build() {
        return new IndexQuery(this.id, this.object, this.version, this.source, this.seqNo, this.primaryTerm, this.routing, this.opType, this.indexName);
    }

    public IndexQueryBuilder withIndex(@Nullable String indexName) {
        this.indexName = indexName;
        return this;
    }
}

