/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query.parser;

import java.util.Collection;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.geo.GeoBox;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class ElasticsearchQueryCreator
extends AbstractQueryCreator<CriteriaQuery, CriteriaQuery> {
    private final MappingContext<?, ElasticsearchPersistentProperty> context;

    public ElasticsearchQueryCreator(PartTree tree, ParameterAccessor parameters, MappingContext<?, ElasticsearchPersistentProperty> context) {
        super(tree, parameters);
        this.context = context;
    }

    public ElasticsearchQueryCreator(PartTree tree, MappingContext<?, ElasticsearchPersistentProperty> context) {
        super(tree);
        this.context = context;
    }

    protected CriteriaQuery create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        return new CriteriaQuery(this.from(part, new Criteria(path.toDotPath((Converter)ElasticsearchPersistentProperty.QueryPropertyToFieldNameConverter.INSTANCE)), iterator));
    }

    protected CriteriaQuery and(Part part, CriteriaQuery base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        return base.addCriteria(this.from(part, new Criteria(path.toDotPath((Converter)ElasticsearchPersistentProperty.QueryPropertyToFieldNameConverter.INSTANCE)), iterator));
    }

    protected CriteriaQuery or(CriteriaQuery base, CriteriaQuery query) {
        return new CriteriaQuery(base.getCriteria().or(query.getCriteria()));
    }

    protected CriteriaQuery complete(@Nullable CriteriaQuery query, Sort sort) {
        if (query == null) {
            query = new CriteriaQuery(new Criteria());
        }
        return (CriteriaQuery)query.addSort(sort);
    }

    private Criteria from(Part part, Criteria criteria, Iterator<?> parameters) {
        Part.Type type = part.getType();
        return switch (type) {
            case Part.Type.TRUE -> criteria.is(true);
            case Part.Type.FALSE -> criteria.is(false);
            case Part.Type.NEGATING_SIMPLE_PROPERTY -> criteria.is(parameters.next()).not();
            case Part.Type.REGEX -> criteria.expression(parameters.next().toString());
            case Part.Type.LIKE, Part.Type.STARTING_WITH -> criteria.startsWith(parameters.next().toString());
            case Part.Type.ENDING_WITH -> criteria.endsWith(parameters.next().toString());
            case Part.Type.CONTAINING -> criteria.contains(parameters.next().toString());
            case Part.Type.GREATER_THAN -> criteria.greaterThan(parameters.next());
            case Part.Type.AFTER, Part.Type.GREATER_THAN_EQUAL -> criteria.greaterThanEqual(parameters.next());
            case Part.Type.LESS_THAN -> criteria.lessThan(parameters.next());
            case Part.Type.BEFORE, Part.Type.LESS_THAN_EQUAL -> criteria.lessThanEqual(parameters.next());
            case Part.Type.BETWEEN -> criteria.between(parameters.next(), parameters.next());
            case Part.Type.IN -> criteria.in(this.asArray(parameters.next()));
            case Part.Type.NOT_IN -> criteria.notIn(this.asArray(parameters.next()));
            case Part.Type.SIMPLE_PROPERTY, Part.Type.WITHIN -> this.within(part, criteria, parameters);
            case Part.Type.NEAR -> this.near(criteria, parameters);
            case Part.Type.EXISTS, Part.Type.IS_NOT_NULL -> criteria.exists();
            case Part.Type.IS_NULL -> criteria.not().exists();
            case Part.Type.IS_EMPTY -> criteria.empty();
            case Part.Type.IS_NOT_EMPTY -> criteria.notEmpty();
            default -> throw new InvalidDataAccessApiUsageException("Illegal criteria found '" + String.valueOf(type) + "'.");
        };
    }

    private Criteria within(Part part, Criteria criteria, Iterator<?> parameters) {
        Object secondParameter;
        Object firstParameter = parameters.next();
        if (part.getType() == Part.Type.SIMPLE_PROPERTY) {
            if (part.getProperty().getType() != GeoPoint.class) {
                if (firstParameter != null) {
                    return criteria.is(firstParameter);
                }
                return criteria.exists().not();
            }
            secondParameter = ".001km";
        } else {
            secondParameter = parameters.next();
        }
        return this.doWithinIfPossible(criteria, firstParameter, secondParameter);
    }

    private Criteria near(Criteria criteria, Iterator<?> parameters) {
        Object firstParameter = parameters.next();
        if (firstParameter instanceof GeoBox) {
            GeoBox geoBox = (GeoBox)firstParameter;
            return criteria.boundedBy(geoBox);
        }
        if (firstParameter instanceof Box) {
            Box box = (Box)firstParameter;
            return criteria.boundedBy(GeoBox.fromBox(box));
        }
        Object secondParameter = parameters.next();
        return this.doWithinIfPossible(criteria, firstParameter, secondParameter);
    }

    private Criteria doWithinIfPossible(Criteria criteria, Object firstParameter, Object secondParameter) {
        if (firstParameter instanceof GeoPoint) {
            GeoPoint geoPoint = (GeoPoint)firstParameter;
            if (secondParameter instanceof String) {
                String string = (String)secondParameter;
                return criteria.within(geoPoint, string);
            }
        }
        if (firstParameter instanceof Point) {
            Point point = (Point)firstParameter;
            if (secondParameter instanceof Distance) {
                Distance distance = (Distance)secondParameter;
                return criteria.within(point, distance);
            }
        }
        if (firstParameter instanceof String) {
            String firstString = (String)firstParameter;
            if (secondParameter instanceof String) {
                String secondString = (String)secondParameter;
                return criteria.within(firstString, secondString);
            }
        }
        return criteria;
    }

    private Object[] asArray(Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).toArray();
        }
        if (o.getClass().isArray()) {
            return (Object[])o;
        }
        return new Object[]{o};
    }
}

