/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.Alias;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.util.Assert;

public class CreateIndexSettings {
    private final IndexCoordinates indexCoordinates;
    private final Set<Alias> aliases;
    private final @Nullable Map<String, Object> settings;
    private final @Nullable Document mapping;

    private CreateIndexSettings(Builder builder) {
        this.indexCoordinates = builder.indexCoordinates;
        this.aliases = builder.aliases;
        this.settings = builder.settings;
        this.mapping = builder.mapping;
    }

    public static Builder builder(IndexCoordinates indexCoordinates) {
        return new Builder(indexCoordinates);
    }

    public IndexCoordinates getIndexCoordinates() {
        return this.indexCoordinates;
    }

    public Alias[] getAliases() {
        return (Alias[])this.aliases.toArray(Alias[]::new);
    }

    public @Nullable Map<String, Object> getSettings() {
        return this.settings;
    }

    public @Nullable Document getMapping() {
        return this.mapping;
    }

    public static class Builder {
        private final IndexCoordinates indexCoordinates;
        private final Set<Alias> aliases = new HashSet<Alias>();
        private @Nullable Map<String, Object> settings;
        private @Nullable Document mapping;

        public Builder(IndexCoordinates indexCoordinates) {
            Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
            this.indexCoordinates = indexCoordinates;
        }

        public Builder withAlias(Alias alias) {
            Assert.notNull((Object)alias, (String)"alias must not be null");
            this.aliases.add(alias);
            return this;
        }

        public Builder withAliases(Set<Alias> aliases) {
            Assert.notNull(aliases, (String)"aliases must not be null");
            this.aliases.addAll(aliases);
            return this;
        }

        public Builder withSettings(Map<String, Object> settings) {
            Assert.notNull(settings, (String)"settings must not be null");
            this.settings = settings;
            return this;
        }

        public Builder withMapping(@Nullable Document mapping) {
            this.mapping = mapping;
            return this;
        }

        public CreateIndexSettings build() {
            return new CreateIndexSettings(this);
        }
    }
}

