/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.SearchShardStatistics;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;

public class SearchHitsImpl<T>
implements SearchScrollHits<T> {
    private final long totalHits;
    private final TotalHitsRelation totalHitsRelation;
    private final float maxScore;
    private final Duration executionDuration;
    private final @Nullable String scrollId;
    private final List<? extends SearchHit<T>> searchHits;
    private final Lazy<List<SearchHit<T>>> unmodifiableSearchHits;
    private final @Nullable AggregationsContainer<?> aggregations;
    private final @Nullable Suggest suggest;
    private final @Nullable String pointInTimeId;
    private final @Nullable SearchShardStatistics searchShardStatistics;

    public SearchHitsImpl(long totalHits, TotalHitsRelation totalHitsRelation, float maxScore, Duration executionDuration, @Nullable String scrollId, @Nullable String pointInTimeId, List<? extends SearchHit<T>> searchHits, @Nullable AggregationsContainer<?> aggregations, @Nullable Suggest suggest, @Nullable SearchShardStatistics searchShardStatistics) {
        Assert.notNull(searchHits, (String)"searchHits must not be null");
        this.totalHits = totalHits;
        this.totalHitsRelation = totalHitsRelation;
        this.maxScore = maxScore;
        this.executionDuration = executionDuration;
        this.scrollId = scrollId;
        this.pointInTimeId = pointInTimeId;
        this.searchHits = searchHits;
        this.aggregations = aggregations;
        this.suggest = suggest;
        this.unmodifiableSearchHits = Lazy.of(() -> Collections.unmodifiableList(searchHits));
        this.searchShardStatistics = searchShardStatistics;
    }

    @Override
    public long getTotalHits() {
        return this.totalHits;
    }

    @Override
    public TotalHitsRelation getTotalHitsRelation() {
        return this.totalHitsRelation;
    }

    @Override
    public float getMaxScore() {
        return this.maxScore;
    }

    @Override
    public Duration getExecutionDuration() {
        return this.executionDuration;
    }

    @Override
    public @Nullable String getScrollId() {
        return this.scrollId;
    }

    @Override
    public List<SearchHit<T>> getSearchHits() {
        return (List)this.unmodifiableSearchHits.get();
    }

    @Override
    public SearchHit<T> getSearchHit(int index) {
        return this.searchHits.get(index);
    }

    @Override
    public @Nullable AggregationsContainer<?> getAggregations() {
        return this.aggregations;
    }

    @Override
    public @Nullable Suggest getSuggest() {
        return this.suggest;
    }

    @Override
    public @Nullable String getPointInTimeId() {
        return this.pointInTimeId;
    }

    @Override
    public SearchShardStatistics getSearchShardStatistics() {
        return this.searchShardStatistics;
    }

    public String toString() {
        return "SearchHits{totalHits=" + this.totalHits + ", totalHitsRelation=" + String.valueOf((Object)this.totalHitsRelation) + ", maxScore=" + this.maxScore + ", executionDuration=" + String.valueOf(this.executionDuration) + ", scrollId='" + this.scrollId + "', pointInTimeId='" + this.pointInTimeId + "', searchHits={" + this.searchHits.size() + " elements}, aggregations=" + String.valueOf(this.aggregations) + ", shardStatistics=" + String.valueOf(this.searchShardStatistics) + "}";
    }
}

