/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.client.elc.Aggregation;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchAggregation;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.util.Assert;

public class ElasticsearchAggregations
implements AggregationsContainer<List<ElasticsearchAggregation>> {
    private final List<ElasticsearchAggregation> aggregations;
    private final Map<String, ElasticsearchAggregation> aggregationsAsMap;

    public ElasticsearchAggregations(Map<String, Aggregate> aggregations) {
        Assert.notNull(aggregations, (String)"aggregations must not be null");
        this.aggregationsAsMap = new HashMap<String, ElasticsearchAggregation>();
        aggregations.forEach((name, aggregate) -> this.aggregationsAsMap.put((String)name, new ElasticsearchAggregation(new Aggregation((String)name, (Aggregate)aggregate))));
        this.aggregations = new ArrayList<ElasticsearchAggregation>(this.aggregationsAsMap.values());
    }

    @Override
    public List<ElasticsearchAggregation> aggregations() {
        return this.aggregations;
    }

    public Map<String, ElasticsearchAggregation> aggregationsAsMap() {
        return this.aggregationsAsMap;
    }

    public @Nullable ElasticsearchAggregation get(String name) {
        Assert.notNull((Object)name, (String)"name must not be null");
        return this.aggregationsAsMap.get(name);
    }
}

