/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.reindex;

import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public class Remote {
    private final String scheme;
    private final String host;
    private final int port;
    private final @Nullable String pathPrefix;
    private final @Nullable String username;
    private final @Nullable String password;
    private final @Nullable Duration socketTimeout;
    private final @Nullable Duration connectTimeout;

    private Remote(String scheme, String host, int port, @Nullable String pathPrefix, @Nullable String username, @Nullable String password, @Nullable Duration socketTimeout, @Nullable Duration connectTimeout) {
        Assert.notNull((Object)scheme, (String)"scheme must not be null");
        Assert.notNull((Object)host, (String)"host must not be null");
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.pathPrefix = pathPrefix;
        this.username = username;
        this.password = password;
        this.socketTimeout = socketTimeout;
        this.connectTimeout = connectTimeout;
    }

    public String getHost() {
        return this.host;
    }

    public @Nullable String getUsername() {
        return this.username;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public @Nullable Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public @Nullable Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public @Nullable String getPathPrefix() {
        return this.pathPrefix;
    }

    public static RemoteBuilder builder(String scheme, String host, int port) {
        return new RemoteBuilder(scheme, host, port);
    }

    public static class RemoteBuilder {
        private final String scheme;
        private final String host;
        private final int port;
        private @Nullable String pathPrefix;
        private @Nullable String username;
        private @Nullable String password;
        private @Nullable Duration socketTimeout;
        private @Nullable Duration connectTimeout;

        public RemoteBuilder(String scheme, String host, int port) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
        }

        public RemoteBuilder withPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        public RemoteBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public RemoteBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public RemoteBuilder withSocketTimeout(Duration socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public RemoteBuilder withConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Remote build() {
            return new Remote(this.scheme, this.host, this.port, this.pathPrefix, this.username, this.password, this.socketTimeout, this.connectTimeout);
        }
    }
}

