/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.ScriptedField;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchCustomConversions;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchTypeMapper;
import org.springframework.data.elasticsearch.core.convert.MappingConversionException;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.PropertyValueConverter;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilter;
import org.springframework.data.elasticsearch.core.query.Order;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.CachingValueExpressionEvaluatorFactory;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mapping.model.ValueExpressionParameterValueProvider;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.format.datetime.DateFormatterRegistrar;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class MappingElasticsearchConverter
implements ElasticsearchConverter,
ApplicationContextAware,
InitializingBean,
EnvironmentCapable {
    private static final String INCOMPATIBLE_TYPES = "Cannot convert %1$s of type %2$s into an instance of %3$s! Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions.";
    private static final String INVALID_TYPE_TO_READ = "Expected to read Document %s into type %s but didn't find a PersistentEntity for the latter!";
    private static final Log LOGGER = LogFactory.getLog(MappingElasticsearchConverter.class);
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
    private final GenericConversionService conversionService;
    private CustomConversions conversions = new ElasticsearchCustomConversions(Collections.emptyList());
    protected @Nullable Environment environment;
    private final SpELContext spELContext = new SpELContext((PropertyAccessor)new MapAccessor());
    private final SpelExpressionParser expressionParser = new SpelExpressionParser();
    private final CachingValueExpressionEvaluatorFactory expressionEvaluatorFactory = new CachingValueExpressionEvaluatorFactory((ExpressionParser)this.expressionParser, (EnvironmentCapable)this, (EvaluationContextProvider)this.spELContext);
    private final EntityInstantiators instantiators = new EntityInstantiators();
    private final ElasticsearchTypeMapper typeMapper;

    public MappingElasticsearchConverter(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this(mappingContext, null);
    }

    public MappingElasticsearchConverter(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, @Nullable GenericConversionService conversionService) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.mappingContext = mappingContext;
        this.conversionService = conversionService != null ? conversionService : new DefaultConversionService();
        this.typeMapper = ElasticsearchTypeMapper.create(mappingContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext = this.mappingContext;
        if (mappingContext instanceof ApplicationContextAware) {
            ApplicationContextAware contextAware = (ApplicationContextAware)mappingContext;
            contextAware.setApplicationContext(applicationContext);
        }
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new StandardEnvironment();
        }
        return this.environment;
    }

    public MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversions(CustomConversions conversions) {
        Assert.notNull((Object)conversions, (String)"CustomConversions must not be null");
        this.conversions = conversions;
    }

    public void afterPropertiesSet() {
        DateFormatterRegistrar.addDateConverters((ConverterRegistry)this.conversionService);
        this.conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    public ElasticsearchTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public <R> R read(Class<R> type, Document source) {
        Reader reader = new Reader(this.mappingContext, this.conversionService, this.conversions, this.typeMapper, this.expressionEvaluatorFactory, this.instantiators);
        return reader.read(type, source);
    }

    public void write(Object source, Document sink) {
        Assert.notNull((Object)source, (String)"source to map must not be null");
        Writer writer = new Writer(this.mappingContext, this.conversionService, this.conversions, this.typeMapper);
        writer.write(source, sink);
    }

    @Override
    public void updateQuery(Query query, @Nullable Class<?> domainClass) {
        BaseQuery baseQuery;
        Assert.notNull((Object)query, (String)"query must not be null");
        if (query instanceof BaseQuery && (baseQuery = (BaseQuery)query).queryIsUpdatedByConverter()) {
            return;
        }
        if (domainClass == null) {
            return;
        }
        this.updatePropertiesInFieldsSortAndSourceFilter(query, domainClass);
        if (query instanceof CriteriaQuery) {
            CriteriaQuery criteriaQuery = (CriteriaQuery)query;
            this.updatePropertiesInCriteriaQuery(criteriaQuery, domainClass);
        }
        if (query instanceof BaseQuery) {
            baseQuery = (BaseQuery)query;
            baseQuery.setQueryIsUpdatedByConverter(true);
        }
    }

    private void updatePropertiesInFieldsSortAndSourceFilter(Query query, Class<?> domainClass) {
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        if (persistentEntity != null) {
            SourceFilter sourceFilter;
            List<String> storedFields;
            List<String> fields = query.getFields();
            if (!fields.isEmpty()) {
                query.setFields(this.propertyToFieldNames(fields, persistentEntity));
            }
            if (!CollectionUtils.isEmpty(storedFields = query.getStoredFields())) {
                query.setStoredFields(this.propertyToFieldNames(storedFields, persistentEntity));
            }
            if ((sourceFilter = query.getSourceFilter()) != null) {
                String[] includes = null;
                String[] excludes = null;
                if (sourceFilter.getIncludes() != null) {
                    includes = this.propertyToFieldNames(Arrays.asList(sourceFilter.getIncludes()), persistentEntity).toArray(new String[0]);
                }
                if (sourceFilter.getExcludes() != null) {
                    excludes = this.propertyToFieldNames(Arrays.asList(sourceFilter.getExcludes()), persistentEntity).toArray(new String[0]);
                }
                query.addSourceFilter(new FetchSourceFilter(sourceFilter.fetchSource(), includes, excludes));
            }
            if (query.getSort() != null) {
                Sort sort = query.getSort();
                List<Sort.Order> newOrders = sort.stream().map(order -> {
                    String fieldNames = this.updateFieldNames(order.getProperty(), persistentEntity);
                    if (order instanceof Order) {
                        Order springDataElasticsearchOrder = (Order)((Object)order);
                        return springDataElasticsearchOrder.withProperty(fieldNames);
                    }
                    return new Sort.Order(order.getDirection(), fieldNames, order.isIgnoreCase(), order.getNullHandling());
                }).toList();
                if (query instanceof BaseQuery) {
                    BaseQuery baseQuery = (BaseQuery)query;
                    baseQuery.setSort(Sort.by(newOrders));
                }
            }
        }
    }

    private List<String> propertyToFieldNames(List<String> propertyNames, ElasticsearchPersistentEntity<?> persistentEntity) {
        return propertyNames.stream().map(propertyName -> this.propertyToFieldName(persistentEntity, (String)propertyName)).collect(Collectors.toList());
    }

    @NotNull
    private String propertyToFieldName(ElasticsearchPersistentEntity<?> persistentEntity, String propertyName) {
        ElasticsearchPersistentProperty persistentProperty = (ElasticsearchPersistentProperty)persistentEntity.getPersistentProperty(propertyName);
        return persistentProperty != null ? persistentProperty.getFieldName() : propertyName;
    }

    private void updatePropertiesInCriteriaQuery(CriteriaQuery criteriaQuery, Class<?> domainClass) {
        Assert.notNull((Object)criteriaQuery, (String)"criteriaQuery must not be null");
        Assert.notNull(domainClass, (String)"domainClass must not be null");
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        if (persistentEntity != null) {
            for (Criteria chainedCriteria : criteriaQuery.getCriteria().getCriteriaChain()) {
                this.updatePropertiesInCriteria(chainedCriteria, persistentEntity);
            }
            for (Criteria subCriteria : criteriaQuery.getCriteria().getSubCriteria()) {
                for (Criteria chainedCriteria : subCriteria.getCriteriaChain()) {
                    this.updatePropertiesInCriteria(chainedCriteria, persistentEntity);
                }
            }
        }
    }

    private void updatePropertiesInCriteria(Criteria criteria, ElasticsearchPersistentEntity<?> persistentEntity) {
        org.springframework.data.elasticsearch.core.query.Field field = criteria.getField();
        if (field == null) {
            return;
        }
        PropertyNamesUpdate propertyNamesUpdate = this.updatePropertyNames(persistentEntity, field.getName());
        CharSequence[] fieldNames = propertyNamesUpdate.names();
        field.setName(String.join((CharSequence)".", fieldNames));
        if (propertyNamesUpdate.propertyCount() > 1 && propertyNamesUpdate.nestedProperty().booleanValue()) {
            List<CharSequence> propertyNames = Arrays.asList(fieldNames);
            field.setPath(String.join((CharSequence)".", propertyNames.subList(0, propertyNamesUpdate.propertyCount - 1)));
        }
        if (propertyNamesUpdate.persistentProperty != null) {
            Field fieldAnnotation;
            if (propertyNamesUpdate.persistentProperty.hasPropertyValueConverter()) {
                PropertyValueConverter propertyValueConverter = Objects.requireNonNull(propertyNamesUpdate.persistentProperty.getPropertyValueConverter());
                criteria.getQueryCriteriaEntries().forEach(criteriaEntry -> {
                    if (criteriaEntry.getKey().hasValue()) {
                        Object value = criteriaEntry.getValue();
                        if (value.getClass().isArray()) {
                            Object[] objects = (Object[])value;
                            for (int i = 0; i < objects.length; ++i) {
                                objects[i] = propertyValueConverter.write(objects[i]);
                            }
                        } else {
                            criteriaEntry.setValue(propertyValueConverter.write(value));
                        }
                    }
                });
            }
            if ((fieldAnnotation = (Field)propertyNamesUpdate.persistentProperty.findAnnotation(Field.class)) != null) {
                field.setFieldType(fieldAnnotation.type());
            }
        }
    }

    @Override
    public String updateFieldNames(String propertyPath, ElasticsearchPersistentEntity<?> persistentEntity) {
        Assert.notNull((Object)propertyPath, (String)"propertyPath must not be null");
        Assert.notNull(persistentEntity, (String)"persistentEntity must not be null");
        PropertyNamesUpdate propertyNamesUpdate = this.updatePropertyNames(persistentEntity, propertyPath);
        return String.join((CharSequence)".", propertyNamesUpdate.names());
    }

    PropertyNamesUpdate updatePropertyNames(ElasticsearchPersistentEntity<?> persistentEntity, String propertyPath) {
        String[] propertyNames = propertyPath.split("\\.");
        String[] fieldNames = Arrays.copyOf(propertyNames, propertyNames.length);
        ElasticsearchPersistentEntity currentEntity = persistentEntity;
        ElasticsearchPersistentProperty persistentProperty = null;
        int propertyCount = 0;
        boolean isNested = false;
        for (int i = 0; i < propertyNames.length; ++i) {
            persistentProperty = (ElasticsearchPersistentProperty)currentEntity.getPersistentProperty(propertyNames[i]);
            if (persistentProperty != null) {
                ++propertyCount;
                fieldNames[i] = persistentProperty.getFieldName();
                Field fieldAnnotation = (Field)persistentProperty.findAnnotation(Field.class);
                if (fieldAnnotation != null && fieldAnnotation.type() == FieldType.Nested) {
                    isNested = true;
                }
                try {
                    currentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(persistentProperty.getActualType());
                }
                catch (Exception e) {
                    currentEntity = null;
                }
            }
            if (currentEntity == null) break;
        }
        return new PropertyNamesUpdate(fieldNames, isNested, propertyCount, persistentProperty);
    }

    private static class Reader
    extends Base {
        private final EntityInstantiators instantiators;
        private final CachingValueExpressionEvaluatorFactory expressionEvaluatorFactory;

        public Reader(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, GenericConversionService conversionService, CustomConversions conversions, ElasticsearchTypeMapper typeMapper, CachingValueExpressionEvaluatorFactory expressionEvaluatorFactory, EntityInstantiators instantiators) {
            super(mappingContext, conversionService, conversions, typeMapper);
            this.expressionEvaluatorFactory = expressionEvaluatorFactory;
            this.instantiators = instantiators;
        }

        <R> R read(Class<R> type, Document source) {
            TypeInformation typeInformation = TypeInformation.of((Class)ClassUtils.getUserClass(type));
            R r = this.read(typeInformation, (Map<String, Object>)source);
            if (r == null) {
                throw new ConversionException("could not convert into object of class " + String.valueOf(type));
            }
            return r;
        }

        private <R> @Nullable R read(TypeInformation<R> typeInformation, Map<String, Object> source) {
            Assert.notNull(source, (String)"Source must not be null!");
            TypeInformation typeToUse = this.typeMapper.readType(source, typeInformation);
            Class rawType = typeToUse.getType();
            if (this.conversions.hasCustomReadTarget(source.getClass(), rawType)) {
                return (R)this.conversionService.convert(source, rawType);
            }
            if (Document.class.isAssignableFrom(rawType)) {
                return (R)source;
            }
            if (typeToUse.isMap()) {
                return this.readMap(typeToUse, source);
            }
            if (typeToUse.equals((Object)TypeInformation.OBJECT)) {
                return (R)source;
            }
            ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
            if (entity == null) {
                throw new MappingException(String.format(MappingElasticsearchConverter.INVALID_TYPE_TO_READ, source, typeToUse.getType()));
            }
            return this.readEntity(entity, source);
        }

        private <R> R readMap(TypeInformation<?> type, Map<String, Object> source) {
            Assert.notNull(source, (String)"Document must not be null!");
            Class mapType = this.typeMapper.readType(source, type).getType();
            TypeInformation keyType = type.getComponentType();
            TypeInformation valueType = type.getMapValueType();
            Class rawKeyType = keyType != null ? keyType.getType() : null;
            Class rawValueType = valueType != null ? valueType.getType() : null;
            Map map = CollectionFactory.createMap((Class)mapType, (Class)rawKeyType, (int)source.keySet().size());
            for (Map.Entry<String, Object> entry : source.entrySet()) {
                TypeInformation defaultedValueType;
                if (this.typeMapper.isTypeKey(entry.getKey())) continue;
                Object key = entry.getKey();
                if (rawKeyType != null && !rawKeyType.isAssignableFrom(key.getClass())) {
                    key = this.conversionService.convert(key, rawKeyType);
                }
                Object value = entry.getValue();
                TypeInformation typeInformation = defaultedValueType = valueType != null ? valueType : TypeInformation.OBJECT;
                if (value instanceof Map) {
                    map.put(key, this.read(defaultedValueType, (Map)value));
                    continue;
                }
                if (value instanceof List) {
                    map.put(key, this.readCollectionOrArray(valueType != null ? valueType : TypeInformation.LIST, (List)value));
                    continue;
                }
                map.put(key, this.getPotentiallyConvertedSimpleRead(value, rawValueType));
            }
            return (R)map;
        }

        private <R> R readEntity(ElasticsearchPersistentEntity<?> entity, Map<String, Object> source) {
            ElasticsearchPersistentEntity<?> targetEntity = this.computeClosestEntity(entity, source);
            ValueExpressionEvaluator evaluator = this.expressionEvaluatorFactory.create(source);
            MapValueAccessor accessor = new MapValueAccessor(source);
            InstanceCreatorMetadata creatorMetadata = entity.getInstanceCreatorMetadata();
            ParameterValueProvider<ElasticsearchPersistentProperty> propertyValueProvider = creatorMetadata != null && creatorMetadata.hasParameters() ? this.getParameterProvider(entity, accessor, evaluator) : NoOpParameterValueProvider.INSTANCE;
            EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(targetEntity);
            Object instance = instantiator.createInstance(targetEntity, propertyValueProvider);
            if (!targetEntity.requiresPropertyPopulation()) {
                return (R)instance;
            }
            Document document = source instanceof Document ? (Document)source : null;
            ElasticsearchPropertyValueProvider valueProvider = new ElasticsearchPropertyValueProvider(accessor, evaluator);
            try {
                Object result = this.readProperties(targetEntity, instance, valueProvider);
                if (document != null) {
                    if (document.hasId()) {
                        ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)targetEntity.getIdProperty();
                        ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(targetEntity.getPropertyAccessor(result), (ConversionService)this.conversionService);
                        if (idProperty != null && idProperty.isReadable() && idProperty.getType().isAssignableFrom(String.class)) {
                            propertyAccessor.setProperty((PersistentProperty)idProperty, (Object)document.getId());
                        }
                    }
                    if (document.hasVersion()) {
                        long version = document.getVersion();
                        ElasticsearchPersistentProperty versionProperty = targetEntity.getVersionProperty();
                        if (versionProperty != null && versionProperty.getType().isAssignableFrom(Long.class)) {
                            Assert.isTrue((version != -1L ? 1 : 0) != 0, (String)"Version in response is -1");
                            targetEntity.getPropertyAccessor(result).setProperty((PersistentProperty)versionProperty, (Object)version);
                        }
                    }
                    if (targetEntity.hasSeqNoPrimaryTermProperty() && document.hasSeqNo() && document.hasPrimaryTerm() && this.isAssignedSeqNo(document.getSeqNo()) && this.isAssignedPrimaryTerm(document.getPrimaryTerm())) {
                        SeqNoPrimaryTerm seqNoPrimaryTerm = new SeqNoPrimaryTerm(document.getSeqNo(), document.getPrimaryTerm());
                        ElasticsearchPersistentProperty property = targetEntity.getRequiredSeqNoPrimaryTermProperty();
                        targetEntity.getPropertyAccessor(result).setProperty((PersistentProperty)property, (Object)seqNoPrimaryTerm);
                    }
                }
                if (source instanceof SearchDocument) {
                    SearchDocument searchDocument = (SearchDocument)source;
                    this.populateScriptedFields(targetEntity, result, searchDocument);
                }
                return (R)result;
            }
            catch (ConversionException e) {
                String documentId = document != null && document.hasId() ? document.getId() : null;
                throw new MappingConversionException(documentId, e);
            }
        }

        private ParameterValueProvider<ElasticsearchPersistentProperty> getParameterProvider(ElasticsearchPersistentEntity<?> entity, MapValueAccessor source, ValueExpressionEvaluator evaluator) {
            ElasticsearchPropertyValueProvider provider = new ElasticsearchPropertyValueProvider(source, evaluator);
            PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, null);
            return new ConverterAwareValueExpressionParameterValueProvider(evaluator, (ConversionService)this.conversionService, (ParameterValueProvider<ElasticsearchPersistentProperty>)parameterProvider);
        }

        private boolean isAssignedSeqNo(long seqNo) {
            return seqNo >= 0L;
        }

        private boolean isAssignedPrimaryTerm(long primaryTerm) {
            return primaryTerm > 0L;
        }

        protected <R> R readProperties(ElasticsearchPersistentEntity<?> entity, R instance, ElasticsearchPropertyValueProvider valueProvider) {
            ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
            Iterator iterator = entity.iterator();
            while (iterator.hasNext()) {
                Object value;
                ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)iterator.next();
                if (entity.isCreatorArgument(property) || !property.isReadable() || property.isSeqNoPrimaryTermProperty() || property.isIndexedIndexNameProperty() || (value = valueProvider.getPropertyValue(property)) == null) continue;
                accessor.setProperty((PersistentProperty)property, value);
            }
            return (R)accessor.getBean();
        }

        protected <R> @Nullable R readValue(@Nullable Object value, ElasticsearchPersistentProperty property, TypeInformation<?> type) {
            String propertyName;
            String key;
            int count;
            if (value == null) {
                return null;
            }
            Class rawType = type.getType();
            if (property.hasPropertyValueConverter()) {
                return (R)this.propertyConverterRead(property, value);
            }
            if (TemporalAccessor.class.isAssignableFrom(property.getType()) && !this.conversions.hasCustomReadTarget(value.getClass(), rawType) && (count = this.propertyWarnings.computeIfAbsent(key = (propertyName = property.getOwner().getType().getSimpleName() + "." + property.getName()) + "-read", k -> 0).intValue()) < 5) {
                LOGGER.warn((Object)String.format("Type %s of property %s is a TemporalAccessor class but has neither a @Field annotation defining the date type nor a registered converter for reading! It cannot be mapped from a complex object in Elasticsearch!", property.getType().getSimpleName(), propertyName));
                this.propertyWarnings.put(key, count + 1);
            }
            return (R)this.readValue(value, type);
        }

        private <T> @Nullable T readValue(Object value, TypeInformation<?> type) {
            Class rawType = type.getType();
            if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
                return (T)this.conversionService.convert(value, rawType);
            }
            if (value instanceof List) {
                return (T)this.readCollectionOrArray(type, (List)value);
            }
            if (value.getClass().isArray()) {
                return (T)this.readCollectionOrArray(type, Arrays.asList((Object[])value));
            }
            if (value instanceof Map) {
                TypeInformation<?> collectionComponentType = this.getCollectionComponentType(type);
                if (collectionComponentType != null) {
                    Object o = this.read(collectionComponentType, (Map)value);
                    return o != null ? (T)Reader.getCollectionWithSingleElement(type, collectionComponentType, o) : null;
                }
                return (T)this.read(type, (Map)value);
            }
            TypeInformation<?> collectionComponentType = this.getCollectionComponentType(type);
            if (collectionComponentType != null && collectionComponentType.isAssignableFrom(TypeInformation.of(value.getClass()))) {
                Object o = this.getPotentiallyConvertedSimpleRead(value, collectionComponentType);
                return o != null ? (T)Reader.getCollectionWithSingleElement(type, collectionComponentType, o) : null;
            }
            return (T)this.getPotentiallyConvertedSimpleRead(value, rawType);
        }

        private static <T> T getCollectionWithSingleElement(TypeInformation<?> collectionType, TypeInformation<?> componentType, Object element) {
            Collection collection = CollectionFactory.createCollection((Class)collectionType.getType(), (Class)componentType.getType(), (int)1);
            collection.add(element);
            return (T)collection;
        }

        @Nullable TypeInformation<?> getCollectionComponentType(TypeInformation<?> type) {
            return type.isCollectionLike() ? type.getComponentType() : null;
        }

        private Object propertyConverterRead(ElasticsearchPersistentProperty property, Object source) {
            PropertyValueConverter propertyValueConverter = Objects.requireNonNull(property.getPropertyValueConverter());
            if (source instanceof String[]) {
                String[] strings = (String[])source;
                source = Arrays.asList(strings);
            }
            if (source instanceof List) {
                List list = source;
                source = list.stream().map(it -> this.convertOnRead(propertyValueConverter, it)).collect(Collectors.toList());
            } else if (source instanceof Set) {
                Set set = (Set)source;
                source = set.stream().map(it -> this.convertOnRead(propertyValueConverter, it)).collect(Collectors.toSet());
            } else {
                source = this.convertOnRead(propertyValueConverter, source);
            }
            return source;
        }

        private Object convertOnRead(PropertyValueConverter propertyValueConverter, Object source) {
            return propertyValueConverter.read(source);
        }

        private @Nullable Object readCollectionOrArray(TypeInformation<?> targetType, Collection<?> source) {
            Collection<Object> items;
            Assert.notNull(targetType, (String)"Target type must not be null!");
            Class collectionType = targetType.isSubTypeOf(Collection.class) ? targetType.getType() : List.class;
            TypeInformation componentType = targetType.getComponentType() != null ? targetType.getComponentType() : TypeInformation.OBJECT;
            Class rawComponentType = componentType.getType();
            Collection collection = items = targetType.getType().isArray() ? new ArrayList(source.size()) : CollectionFactory.createCollection((Class)collectionType, (Class)rawComponentType, (int)source.size());
            if (source.isEmpty()) {
                return this.getPotentiallyConvertedSimpleRead(items, targetType);
            }
            for (Object element : source) {
                if (element instanceof Map) {
                    items.add(this.read(componentType, (Map)element));
                    continue;
                }
                if (!Object.class.equals((Object)rawComponentType) && element instanceof Collection && !rawComponentType.isArray() && !ClassUtils.isAssignable(Iterable.class, (Class)rawComponentType)) {
                    throw new MappingException(String.format(MappingElasticsearchConverter.INCOMPATIBLE_TYPES, element, element.getClass(), rawComponentType));
                }
                if (element instanceof List) {
                    items.add(this.readCollectionOrArray(componentType, (Collection)element));
                    continue;
                }
                items.add(this.getPotentiallyConvertedSimpleRead(element, rawComponentType));
            }
            return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
        }

        private @Nullable Object getPotentiallyConvertedSimpleRead(@Nullable Object value, TypeInformation<?> targetType) {
            return this.getPotentiallyConvertedSimpleRead(value, targetType.getType());
        }

        private @Nullable Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
            if (target == null || value == null || ClassUtils.isAssignableValue(target, (Object)value)) {
                return value;
            }
            if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
                return this.conversionService.convert(value, target);
            }
            if (Enum.class.isAssignableFrom(target)) {
                return Enum.valueOf(target, value.toString());
            }
            try {
                return this.conversionService.convert(value, target);
            }
            catch (ConverterNotFoundException e) {
                return this.convertFromCollectionToObject(value, target);
            }
        }

        private @Nullable Object convertFromCollectionToObject(Object value, Class<?> target) {
            Collection collection;
            if (value.getClass().isArray()) {
                value = Arrays.asList(value);
            }
            if (value instanceof Collection && !(collection = (Collection)value).isEmpty()) {
                value = collection.iterator().next();
            }
            return this.conversionService.convert(value, target);
        }

        private <T> void populateScriptedFields(ElasticsearchPersistentEntity<?> entity, T result, SearchDocument searchDocument) {
            Map<String, List<Object>> fields = searchDocument.getFields();
            entity.doWithProperties(property -> {
                if (property.isAnnotationPresent(ScriptedField.class)) {
                    String name;
                    ScriptedField scriptedField = (ScriptedField)property.findAnnotation(ScriptedField.class);
                    String string = name = scriptedField.name().isEmpty() ? property.getName() : scriptedField.name();
                    if (fields.containsKey(name)) {
                        if (property.isCollectionLike()) {
                            List values = searchDocument.getFieldValues(name);
                            entity.getPropertyAccessor(result).setProperty(property, values);
                        } else {
                            Object value = searchDocument.getFieldValue(name);
                            entity.getPropertyAccessor(result).setProperty(property, value);
                        }
                    }
                }
            });
        }

        private ElasticsearchPersistentEntity<?> computeClosestEntity(ElasticsearchPersistentEntity<?> entity, Map<String, Object> source) {
            TypeInformation typeToUse = this.typeMapper.readType(source);
            if (typeToUse == null) {
                return entity;
            }
            if (!(entity.getTypeInformation().getType().isInterface() || entity.getTypeInformation().isCollectionLike() || entity.getTypeInformation().isMap() || ClassUtils.isAssignableValue((Class)entity.getType(), (Object)typeToUse.getType()))) {
                return entity;
            }
            return (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToUse);
        }

        static enum NoOpParameterValueProvider implements ParameterValueProvider<ElasticsearchPersistentProperty>
        {
            INSTANCE;


            public <T> T getParameterValue(Parameter<T, ElasticsearchPersistentProperty> parameter) {
                return null;
            }
        }

        class ElasticsearchPropertyValueProvider
        implements PropertyValueProvider<ElasticsearchPersistentProperty> {
            final MapValueAccessor accessor;
            final ValueExpressionEvaluator evaluator;

            ElasticsearchPropertyValueProvider(MapValueAccessor accessor, ValueExpressionEvaluator evaluator) {
                this.accessor = accessor;
                this.evaluator = evaluator;
            }

            public <T> T getPropertyValue(ElasticsearchPersistentProperty property) {
                Object value;
                String expression = property.getSpelExpression();
                Object object = value = expression != null ? this.evaluator.evaluate(expression) : this.accessor.get(property);
                if (value == null) {
                    return null;
                }
                return (T)Reader.this.readValue(value, property, property.getTypeInformation());
            }
        }

        private class ConverterAwareValueExpressionParameterValueProvider
        extends ValueExpressionParameterValueProvider<ElasticsearchPersistentProperty> {
            public ConverterAwareValueExpressionParameterValueProvider(ValueExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<ElasticsearchPersistentProperty> delegate) {
                super(evaluator, conversionService, delegate);
            }

            protected <T> T potentiallyConvertExpressionValue(Object object, Parameter<T, ElasticsearchPersistentProperty> parameter) {
                return Reader.this.readValue(object, parameter.getType());
            }
        }
    }

    private static class Writer
    extends Base {
        private boolean writeTypeHints = true;

        public Writer(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, GenericConversionService conversionService, CustomConversions conversions, ElasticsearchTypeMapper typeMapper) {
            super(mappingContext, conversionService, conversions, typeMapper);
        }

        void write(Object source, Document sink) {
            if (source instanceof Map) {
                sink.putAll((Map)source);
                return;
            }
            Class entityType = ClassUtils.getUserClass(source.getClass());
            ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
            if (entity != null) {
                this.writeTypeHints = entity.writeTypeHints();
            }
            TypeInformation typeInformation = TypeInformation.of((Class)entityType);
            if (this.writeTypeHints && this.requiresTypeHint(entityType)) {
                this.typeMapper.writeType(typeInformation, sink);
            }
            this.writeInternal(source, (Map<String, Object>)sink, typeInformation);
        }

        private void writeInternal(@Nullable Object source, Map<String, Object> sink, @Nullable TypeInformation<?> typeInformation) {
            if (null == source) {
                return;
            }
            Class<?> entityType = source.getClass();
            Optional customTarget = this.conversions.getCustomWriteTarget(entityType, Map.class);
            if (customTarget.isPresent()) {
                Map result = (Map)this.conversionService.convert(source, Map.class);
                if (result != null) {
                    sink.putAll(result);
                }
                return;
            }
            if (Map.class.isAssignableFrom(entityType)) {
                this.writeMapInternal((Map)source, sink, TypeInformation.MAP);
                return;
            }
            if (Collection.class.isAssignableFrom(entityType)) {
                this.writeCollectionInternal((Collection)source, TypeInformation.LIST, (Collection)((Object)sink));
                return;
            }
            ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType);
            this.addCustomTypeKeyIfNecessary(source, sink, typeInformation);
            this.writeInternal(source, sink, entity);
        }

        private void writeInternal(@Nullable Object source, Map<String, Object> sink, @Nullable ElasticsearchPersistentEntity<?> entity) {
            if (source == null) {
                return;
            }
            if (null == entity) {
                throw new MappingException("No mapping metadata found for entity of type " + source.getClass().getName());
            }
            PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
            this.writeProperties(entity, accessor, new MapValueAccessor(sink));
        }

        private boolean requiresTypeHint(Class<?> type) {
            return !this.isSimpleType(type) && !ClassUtils.isAssignable(Collection.class, type) && !this.conversions.hasCustomWriteTarget(type, Document.class);
        }

        private boolean isSimpleType(Object value) {
            return this.isSimpleType(value.getClass());
        }

        private boolean isSimpleType(Class<?> type) {
            return !Map.class.isAssignableFrom(type) && this.conversions.isSimpleType(type);
        }

        private Map<String, Object> writeMapInternal(Map<?, ?> source, Map<String, Object> sink, TypeInformation<?> propertyType) {
            for (Map.Entry<?, ?> entry : source.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (this.isSimpleType(key.getClass())) {
                    String simpleKey = this.potentiallyConvertMapKey(key);
                    if (value == null || this.isSimpleType(value)) {
                        sink.put(simpleKey, this.getPotentiallyConvertedSimpleWrite(value, Object.class));
                        continue;
                    }
                    if (value instanceof Collection || value.getClass().isArray()) {
                        sink.put(simpleKey, this.writeCollectionInternal(Writer.asCollection(value), propertyType.getMapValueType(), new ArrayList()));
                        continue;
                    }
                    Document document = Document.create();
                    TypeInformation valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : TypeInformation.OBJECT;
                    this.writeInternal(value, (Map<String, Object>)document, valueTypeInfo);
                    sink.put(simpleKey, document);
                    continue;
                }
                throw new MappingException("Cannot use a complex object as a key value.");
            }
            return sink;
        }

        private List<Object> writeCollectionInternal(Collection<?> source, @Nullable TypeInformation<?> type, Collection<?> sink) {
            List<Object> collection;
            TypeInformation componentType = null;
            List<Object> list = collection = sink instanceof List ? (List<Object>)sink : new ArrayList(sink);
            if (type != null) {
                componentType = type.getComponentType();
            }
            for (Object element : source) {
                Class<?> elementType;
                Class<?> clazz = elementType = element == null ? null : element.getClass();
                if (elementType == null || this.isSimpleType(elementType)) {
                    collection.add(this.getPotentiallyConvertedSimpleWrite(element, componentType != null ? componentType.getType() : Object.class));
                    continue;
                }
                if (element instanceof Collection || elementType.isArray()) {
                    collection.add(this.writeCollectionInternal(Writer.asCollection(element), componentType, new ArrayList()));
                    continue;
                }
                Document document = Document.create();
                this.writeInternal(element, (Map<String, Object>)document, componentType);
                collection.add(document);
            }
            return collection;
        }

        private void writeProperties(ElasticsearchPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, MapValueAccessor sink) {
            Iterator iterator = entity.iterator();
            while (iterator.hasNext()) {
                ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)iterator.next();
                if (!property.isWritable() || property.isIndexedIndexNameProperty() || property.isIdProperty() && !entity.storeIdInSource() || property.isVersionProperty() && !entity.storeVersionInSource() || property.isIdProperty() && !entity.storeIdInSource()) continue;
                Object value = accessor.getProperty((PersistentProperty)property);
                if (value == null) {
                    if (!property.storeNullValue()) continue;
                    sink.set(property, null);
                    continue;
                }
                if (!property.storeEmptyValue() && Writer.hasEmptyValue(value)) continue;
                if (property.hasPropertyValueConverter()) {
                    value = this.propertyConverterWrite(property, value);
                    sink.set(property, value);
                    continue;
                }
                if (TemporalAccessor.class.isAssignableFrom(property.getActualType()) && !this.conversions.hasCustomWriteTarget(value.getClass())) {
                    String propertyName = entity.getType().getSimpleName() + "." + property.getName();
                    String key = propertyName + "-write";
                    int count = this.propertyWarnings.computeIfAbsent(key, k -> 0);
                    if (count >= 5) continue;
                    LOGGER.warn((Object)String.format("Type %s of property %s is a TemporalAccessor class but has neither a @Field annotation defining the date type nor a registered converter for writing! It will be mapped to a complex object in Elasticsearch!", property.getType().getSimpleName(), propertyName));
                    this.propertyWarnings.put(key, count + 1);
                    continue;
                }
                if (!this.isSimpleType(value)) {
                    this.writeProperty(property, value, sink);
                    continue;
                }
                Object writeSimpleValue = this.getPotentiallyConvertedSimpleWrite(value, Object.class);
                if (writeSimpleValue == null) continue;
                sink.set(property, writeSimpleValue);
            }
        }

        private static boolean hasEmptyValue(Object value) {
            Map m;
            Collection c;
            String s;
            return value instanceof String && (s = (String)value).isEmpty() || value instanceof Collection && (c = (Collection)value).isEmpty() || value instanceof Map && (m = (Map)value).isEmpty();
        }

        protected void writeProperty(ElasticsearchPersistentProperty property, Object value, MapValueAccessor sink) {
            Optional customWriteTarget = this.conversions.getCustomWriteTarget(value.getClass());
            if (customWriteTarget.isPresent()) {
                Class writeTarget = (Class)customWriteTarget.get();
                sink.set(property, this.conversionService.convert(value, writeTarget));
                return;
            }
            TypeInformation valueType = TypeInformation.of(value.getClass());
            TypeInformation type = property.getTypeInformation();
            if (valueType.isCollectionLike()) {
                List<Object> collectionInternal = this.createCollection(Writer.asCollection(value), property);
                sink.set(property, collectionInternal);
                return;
            }
            if (valueType.isMap()) {
                Map<String, Object> mapDbObj = this.createMap((Map)value, property);
                sink.set(property, mapDbObj);
                return;
            }
            Optional basicTargetType = this.conversions.getCustomWriteTarget(value.getClass());
            if (basicTargetType.isPresent()) {
                sink.set(property, this.conversionService.convert(value, (Class)basicTargetType.get()));
                return;
            }
            ElasticsearchPersistentEntity entity = valueType.isSubTypeOf(property.getType()) ? (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(value.getClass()) : (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Object existingValue = sink.get(property);
            Map<String, Object> document = existingValue instanceof Map ? (Map)existingValue : Document.create();
            this.addCustomTypeKeyIfNecessary(value, document, TypeInformation.of((Class)property.getRawType()));
            this.writeInternal(value, document, entity);
            sink.set(property, document);
        }

        private void addCustomTypeKeyIfNecessary(Object source, Map<String, Object> sink, @Nullable TypeInformation<?> type) {
            boolean notTheSameClass;
            TypeInformation actualType;
            if (!this.writeTypeHints) {
                return;
            }
            Class reference = type == null ? Object.class : ((actualType = type.getActualType()) == null ? Object.class : actualType.getType());
            Class valueType = ClassUtils.getUserClass(source.getClass());
            boolean bl = notTheSameClass = !valueType.equals(reference);
            if (notTheSameClass) {
                this.typeMapper.writeType(valueType, sink);
            }
        }

        private String potentiallyConvertMapKey(Object key) {
            if (key instanceof String) {
                return (String)key;
            }
            if (this.conversions.hasCustomWriteTarget(key.getClass(), String.class)) {
                Object potentiallyConvertedSimpleWrite = this.getPotentiallyConvertedSimpleWrite(key, Object.class);
                if (potentiallyConvertedSimpleWrite == null) {
                    return key.toString();
                }
                return (String)potentiallyConvertedSimpleWrite;
            }
            return key.toString();
        }

        private @Nullable Object getPotentiallyConvertedSimpleWrite(@Nullable Object value, @Nullable Class<?> typeHint) {
            if (value == null) {
                return null;
            }
            if (typeHint != null && Object.class != typeHint && this.conversionService.canConvert(value.getClass(), typeHint) && (value = this.conversionService.convert(value, typeHint)) == null) {
                return null;
            }
            Optional customTarget = this.conversions.getCustomWriteTarget(value.getClass());
            if (customTarget.isPresent()) {
                return this.conversionService.convert(value, (Class)customTarget.get());
            }
            if (ObjectUtils.isArray((Object)value)) {
                if (value instanceof byte[]) {
                    return value;
                }
                return Writer.asCollection(value);
            }
            return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
        }

        private Object propertyConverterWrite(ElasticsearchPersistentProperty property, Object value) {
            PropertyValueConverter propertyValueConverter = Objects.requireNonNull(property.getPropertyValueConverter());
            value = value instanceof List ? ((List)value).stream().map(propertyValueConverter::write).collect(Collectors.toList()) : (value instanceof Set ? ((Set)value).stream().map(propertyValueConverter::write).collect(Collectors.toSet()) : propertyValueConverter.write(value));
            return value;
        }

        protected List<Object> createCollection(Collection<?> collection, ElasticsearchPersistentProperty property) {
            return this.writeCollectionInternal(collection, property.getTypeInformation(), new ArrayList(collection.size()));
        }

        protected Map<String, Object> createMap(Map<?, ?> map, ElasticsearchPersistentProperty property) {
            Assert.notNull(map, (String)"Given map must not be null!");
            Assert.notNull((Object)property, (String)"PersistentProperty must not be null!");
            return this.writeMapInternal(map, new LinkedHashMap<String, Object>(map.size()), property.getTypeInformation());
        }

        private static Collection<?> asCollection(Object source) {
            if (source instanceof Collection) {
                Collection collection = (Collection)source;
                return collection;
            }
            return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
        }
    }

    record PropertyNamesUpdate(String[] names, Boolean nestedProperty, Integer propertyCount, ElasticsearchPersistentProperty persistentProperty) {
    }

    static class MapValueAccessor {
        final Map<String, Object> target;

        MapValueAccessor(Map<String, Object> target) {
            this.target = target;
        }

        public @Nullable Object get(ElasticsearchPersistentProperty property) {
            String fieldName = property.getFieldName();
            Map<String, Object> map = this.target;
            if (map instanceof Document) {
                Document document = (Document)map;
                if (property.isIdProperty() && document.hasId()) {
                    Object id = null;
                    if (!fieldName.contains(".")) {
                        id = this.target.get(fieldName);
                    }
                    return id != null ? id : document.getId();
                }
                if (property.isVersionProperty() && document.hasVersion()) {
                    return document.getVersion();
                }
            }
            if (property.hasExplicitFieldName() || !fieldName.contains(".")) {
                return this.target.get(fieldName);
            }
            Iterator<String> parts = Arrays.asList(fieldName.split("\\.")).iterator();
            Map<String, Object> source = this.target;
            Object result = null;
            while (parts.hasNext()) {
                result = source.get(parts.next());
                if (!parts.hasNext()) continue;
                source = this.getAsMap(result);
            }
            return result;
        }

        public void set(ElasticsearchPersistentProperty property, @Nullable Object value) {
            if (value != null) {
                if (property.isIdProperty()) {
                    ((Document)this.target).setId(value.toString());
                }
                if (property.isVersionProperty()) {
                    ((Document)this.target).setVersion((Long)value);
                }
            }
            this.target.put(property.getFieldName(), value);
        }

        private Map<String, Object> getAsMap(Object result) {
            if (result instanceof Map) {
                return (Map)result;
            }
            throw new IllegalArgumentException(String.format("%s is not a Map.", result));
        }
    }

    private static class Base {
        protected final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
        protected final ElasticsearchTypeMapper typeMapper;
        protected final GenericConversionService conversionService;
        protected final CustomConversions conversions;
        protected final ConcurrentHashMap<String, Integer> propertyWarnings = new ConcurrentHashMap();

        private Base(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, GenericConversionService conversionService, CustomConversions conversions, ElasticsearchTypeMapper typeMapper) {
            this.mappingContext = mappingContext;
            this.conversionService = conversionService;
            this.conversions = conversions;
            this.typeMapper = typeMapper;
        }
    }
}

