/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.util;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;

public class ScrollState {
    private final Object lock = new Object();
    private final Set<String> pastIds = new LinkedHashSet<String>();
    private @Nullable String scrollId;

    public ScrollState() {
    }

    public ScrollState(String scrollId) {
        this.updateScrollId(scrollId);
    }

    public @Nullable String getScrollId() {
        return this.scrollId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getScrollIds() {
        Object object = this.lock;
        synchronized (object) {
            return List.copyOf(this.pastIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateScrollId(@Nullable String scrollId) {
        if (StringUtils.hasText((String)scrollId)) {
            Object object = this.lock;
            synchronized (object) {
                this.scrollId = scrollId;
                this.pastIds.add(scrollId);
            }
        }
    }
}

