/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.support.HttpHeaders;

class DefaultClientConfiguration
implements ClientConfiguration {
    private final List<InetSocketAddress> hosts;
    private final HttpHeaders headers;
    private final boolean useSsl;
    private final @Nullable SSLContext sslContext;
    private final @Nullable String caFingerprint;
    private final Duration soTimeout;
    private final Duration connectTimeout;
    private final @Nullable String pathPrefix;
    private final @Nullable HostnameVerifier hostnameVerifier;
    private final @Nullable String proxy;
    private final Supplier<HttpHeaders> headersSupplier;
    private final List<ClientConfiguration.ClientConfigurationCallback<?>> clientConfigurers;

    DefaultClientConfiguration(List<InetSocketAddress> hosts, HttpHeaders headers, boolean useSsl, @Nullable SSLContext sslContext, @Nullable String caFingerprint, Duration soTimeout, Duration connectTimeout, @Nullable String pathPrefix, @Nullable HostnameVerifier hostnameVerifier, @Nullable String proxy, List<ClientConfiguration.ClientConfigurationCallback<?>> clientConfigurers, Supplier<HttpHeaders> headersSupplier) {
        this.hosts = List.copyOf(hosts);
        this.headers = headers;
        this.useSsl = useSsl;
        this.sslContext = sslContext;
        this.caFingerprint = caFingerprint;
        this.soTimeout = soTimeout;
        this.connectTimeout = connectTimeout;
        this.pathPrefix = pathPrefix;
        this.hostnameVerifier = hostnameVerifier;
        this.proxy = proxy;
        this.clientConfigurers = clientConfigurers;
        this.headersSupplier = headersSupplier;
    }

    @Override
    public List<InetSocketAddress> getEndpoints() {
        return this.hosts;
    }

    @Override
    public HttpHeaders getDefaultHeaders() {
        return this.headers;
    }

    @Override
    public boolean useSsl() {
        return this.useSsl;
    }

    @Override
    public Optional<SSLContext> getSslContext() {
        return Optional.ofNullable(this.sslContext);
    }

    @Override
    public Optional<String> getCaFingerprint() {
        return Optional.ofNullable(this.caFingerprint);
    }

    @Override
    public Optional<HostnameVerifier> getHostNameVerifier() {
        return Optional.ofNullable(this.hostnameVerifier);
    }

    @Override
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public Duration getSocketTimeout() {
        return this.soTimeout;
    }

    @Override
    public @Nullable String getPathPrefix() {
        return this.pathPrefix;
    }

    @Override
    public Optional<String> getProxy() {
        return Optional.ofNullable(this.proxy);
    }

    @Override
    public <T> List<ClientConfiguration.ClientConfigurationCallback<?>> getClientConfigurers() {
        return this.clientConfigurers;
    }

    @Override
    public Supplier<HttpHeaders> getHeadersSupplier() {
        return this.headersSupplier;
    }
}

