/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support.querybyexample;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.support.ExampleMatcherAccessor;
import org.springframework.util.StringUtils;

class ExampleCriteriaMapper {
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    ExampleCriteriaMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    <S> Criteria criteria(Example<S> example) {
        return this.buildCriteria(example);
    }

    private <S> Criteria buildCriteria(Example<S> example) {
        ExampleMatcherAccessor matcherAccessor = new ExampleMatcherAccessor(example.getMatcher());
        return this.applyPropertySpecs(new Criteria(), "", example.getProbe(), (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(example.getProbeType()), matcherAccessor, example.getMatcher().getMatchMode());
    }

    private Criteria applyPropertySpecs(Criteria criteria, String path, @Nullable Object probe, ElasticsearchPersistentEntity<?> persistentEntity, ExampleMatcherAccessor exampleSpecAccessor, ExampleMatcher.MatchMode matchMode) {
        if (probe == null) {
            return criteria;
        }
        PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(probe);
        Iterator iterator = persistentEntity.iterator();
        while (iterator.hasNext()) {
            ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)iterator.next();
            String propertyName = property.getName();
            Object propertyPath = StringUtils.hasText((String)path) ? path + "." + propertyName : propertyName;
            if (exampleSpecAccessor.isIgnoredPath((String)propertyPath) || property.isCollectionLike() || property.isVersionProperty()) continue;
            Object propertyValue = propertyAccessor.getProperty((PersistentProperty)property);
            if (property.isMap() && propertyValue != null) {
                for (Map.Entry entry : ((Map)propertyValue).entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    criteria = this.applyPropertySpec((String)propertyPath + "." + key, value, exampleSpecAccessor, property, matchMode, criteria);
                }
                continue;
            }
            criteria = this.applyPropertySpec((String)propertyPath, propertyValue, exampleSpecAccessor, property, matchMode, criteria);
        }
        return criteria;
    }

    private Criteria applyPropertySpec(String path, Object propertyValue, ExampleMatcherAccessor exampleSpecAccessor, ElasticsearchPersistentProperty property, ExampleMatcher.MatchMode matchMode, Criteria criteria) {
        if (exampleSpecAccessor.isIgnoreCaseForPath(path)) {
            throw new InvalidDataAccessApiUsageException("Current implementation of Query-by-Example supports only case-sensitive matching.");
        }
        Object transformedValue = ((Optional)exampleSpecAccessor.getValueTransformerForPath(path).apply(Optional.ofNullable(propertyValue))).orElse(null);
        if (transformedValue != null) {
            if (property.isEntity()) {
                return this.applyPropertySpecs(criteria, path, transformedValue, (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property), exampleSpecAccessor, matchMode);
            }
            return this.applyStringMatcher(this.applyMatchMode(criteria, path, matchMode), transformedValue, exampleSpecAccessor.getStringMatcherForPath(path));
        }
        criteria = this.tryToAppendMustNotSentence(criteria, path, exampleSpecAccessor);
        return criteria;
    }

    private Criteria tryToAppendMustNotSentence(Criteria criteria, String path, ExampleMatcherAccessor exampleSpecAccessor) {
        if (ExampleMatcher.NullHandler.INCLUDE.equals((Object)exampleSpecAccessor.getNullHandler()) || exampleSpecAccessor.hasPropertySpecifier(path)) {
            return criteria.and(path).not().exists();
        }
        return criteria;
    }

    private Criteria applyMatchMode(Criteria criteria, String path, ExampleMatcher.MatchMode matchMode) {
        if (matchMode == ExampleMatcher.MatchMode.ALL) {
            return criteria.and(path);
        }
        return criteria.or(path);
    }

    private Criteria applyStringMatcher(Criteria criteria, Object value, ExampleMatcher.StringMatcher stringMatcher) {
        return switch (stringMatcher) {
            default -> throw new IncompatibleClassChangeError();
            case ExampleMatcher.StringMatcher.DEFAULT -> criteria.is(value);
            case ExampleMatcher.StringMatcher.EXACT -> criteria.matchesAll(value);
            case ExampleMatcher.StringMatcher.STARTING -> criteria.startsWith(this.validateString(value));
            case ExampleMatcher.StringMatcher.ENDING -> criteria.endsWith(this.validateString(value));
            case ExampleMatcher.StringMatcher.CONTAINING -> criteria.contains(this.validateString(value));
            case ExampleMatcher.StringMatcher.REGEX -> criteria.regexp(this.validateString(value));
        };
    }

    private String validateString(Object value) {
        if (value instanceof String) {
            return value.toString();
        }
        throw new IllegalArgumentException("This operation requires a String but got " + value.getClass());
    }
}

