/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.DocValueField;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.RuntimeField;
import org.springframework.data.elasticsearch.core.query.ScriptedField;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.util.Assert;

public interface Query {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final Pageable DEFAULT_PAGE = PageRequest.of((int)0, (int)10);

    public static Query findAll() {
        return new StringQuery("{\"match_all\":{}}");
    }

    public <T extends Query> T setPageable(Pageable var1);

    public Pageable getPageable();

    public <T extends Query> T addSort(@Nullable Sort var1);

    public @Nullable Sort getSort();

    public void addFields(String ... var1);

    public List<String> getFields();

    public void setFields(List<String> var1);

    public void addStoredFields(String ... var1);

    public @Nullable List<String> getStoredFields();

    public void setStoredFields(@Nullable List<String> var1);

    public void addSourceFilter(SourceFilter var1);

    public @Nullable SourceFilter getSourceFilter();

    public float getMinScore();

    public boolean getTrackScores();

    public @Nullable Collection<String> getIds();

    public List<IdWithRouting> getIdsWithRouting();

    public static Query multiGetQueryWithRouting(List<IdWithRouting> idsWithRouting) {
        Assert.notNull(idsWithRouting, (String)"idsWithRouting must not be null");
        BaseQuery query = new BaseQuery();
        query.setIdsWithRouting(idsWithRouting);
        return query;
    }

    public static Query multiGetQuery(Collection<String> ids) {
        Assert.notNull(ids, (String)"ids must not be null");
        BaseQuery query = new BaseQuery();
        query.setIds(ids);
        return query;
    }

    public @Nullable String getRoute();

    public @Nullable SearchType getSearchType();

    public @Nullable IndicesOptions getIndicesOptions();

    public @Nullable String getPreference();

    public void setPreference(String var1);

    default public boolean isLimiting() {
        return false;
    }

    default public @Nullable Integer getMaxResults() {
        return null;
    }

    public void setHighlightQuery(HighlightQuery var1);

    default public Optional<HighlightQuery> getHighlightQuery() {
        return Optional.empty();
    }

    public void setTrackTotalHits(@Nullable Boolean var1);

    public @Nullable Boolean getTrackTotalHits();

    public void setTrackTotalHitsUpTo(@Nullable Integer var1);

    public @Nullable Integer getTrackTotalHitsUpTo();

    public @Nullable Duration getScrollTime();

    public void setScrollTime(@Nullable Duration var1);

    default public boolean hasScrollTime() {
        return this.getScrollTime() != null;
    }

    public @Nullable Duration getTimeout();

    default public boolean getExplain() {
        return false;
    }

    public void setSearchAfter(@Nullable List<Object> var1);

    public @Nullable List<Object> getSearchAfter();

    public void addRescorerQuery(RescorerQuery var1);

    public void setRescorerQueries(List<RescorerQuery> var1);

    default public List<RescorerQuery> getRescorerQueries() {
        return Collections.emptyList();
    }

    public void setRequestCache(@Nullable Boolean var1);

    public @Nullable Boolean getRequestCache();

    public void addRuntimeField(RuntimeField var1);

    public List<RuntimeField> getRuntimeFields();

    public @Nullable List<IndexBoost> getIndicesBoost();

    default public @Nullable PointInTime getPointInTime() {
        return null;
    }

    default public Integer getReactiveBatchSize() {
        return 500;
    }

    public @Nullable Boolean getAllowNoIndices();

    public @Nullable EnumSet<IndicesOptions.WildcardStates> getExpandWildcards();

    public List<DocValueField> getDocValueFields();

    public List<ScriptedField> getScriptedFields();

    public record PointInTime(String id, Duration keepAlive) {
    }

    public record IdWithRouting(String id, @Nullable String routing) {
        public IdWithRouting(String id, @Nullable String routing) {
            Assert.notNull((Object)id, (String)"id must not be null");
        }
    }

    public static enum SearchType {
        QUERY_THEN_FETCH,
        DFS_QUERY_THEN_FETCH;

    }
}

