/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.query.InnerHitsQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;

public class HasParentQuery {
    private final String parentType;
    private final Query query;
    private final @Nullable Boolean score;
    private final @Nullable Boolean ignoreUnmapped;
    private final @Nullable InnerHitsQuery innerHitsQuery;

    public static Builder builder(String parentType) {
        return new Builder(parentType);
    }

    private HasParentQuery(Builder builder) {
        this.parentType = builder.parentType;
        this.query = builder.query;
        this.innerHitsQuery = builder.innerHitsQuery;
        this.score = builder.score;
        this.ignoreUnmapped = builder.ignoreUnmapped;
    }

    public String getParentType() {
        return this.parentType;
    }

    public Query getQuery() {
        return this.query;
    }

    public @Nullable Boolean getScore() {
        return this.score;
    }

    public @Nullable Boolean getIgnoreUnmapped() {
        return this.ignoreUnmapped;
    }

    public @Nullable InnerHitsQuery getInnerHitsQuery() {
        return this.innerHitsQuery;
    }

    public static class Builder {
        private final String parentType;
        private Query query;
        private @Nullable Boolean score;
        private @Nullable Boolean ignoreUnmapped;
        private @Nullable InnerHitsQuery innerHitsQuery;

        private Builder(String parentType) {
            Assert.notNull((Object)parentType, (String)"parent_type must not be null.");
            this.parentType = parentType;
        }

        public Builder withQuery(Query query) {
            this.query = query;
            return this;
        }

        public Builder withScore(@Nullable Boolean score) {
            this.score = score;
            return this;
        }

        public Builder withIgnoreUnmapped(@Nullable Boolean ignoreUnmapped) {
            this.ignoreUnmapped = ignoreUnmapped;
            return this;
        }

        public Builder withInnerHitsQuery(@Nullable InnerHitsQuery innerHitsQuery) {
            this.innerHitsQuery = innerHitsQuery;
            return this;
        }

        public HasParentQuery build() {
            Assert.notNull((Object)this.query, (String)"query must not be null.");
            return new HasParentQuery(this);
        }
    }
}

