/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.elc.AutoCloseableElasticsearchClient;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchClients;
import org.springframework.util.Assert;

public class ElasticsearchClientFactoryBean
implements FactoryBean<ElasticsearchClient>,
InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(ElasticsearchClientFactoryBean.class);
    private @Nullable AutoCloseableElasticsearchClient client;
    private String hosts = "http://localhost:9200";
    static final String COMMA = ",";

    public void destroy() {
        try {
            LOGGER.info((Object)"Closing elasticSearch  client");
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.buildClient();
    }

    public ElasticsearchClient getObject() {
        if (this.client == null) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.client;
    }

    public Class<?> getObjectType() {
        return ElasticsearchClient.class;
    }

    public boolean isSingleton() {
        return false;
    }

    protected void buildClient() throws Exception {
        Assert.hasText((String)this.hosts, (String)"[Assertion Failed] At least one host must be set.");
        ClientConfiguration clientConfiguration = ClientConfiguration.builder().connectedTo(this.hosts).build();
        this.client = (AutoCloseableElasticsearchClient)ElasticsearchClients.createImperative(clientConfiguration);
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getHosts() {
        return this.hosts;
    }
}

