/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.core.geo.GeoBox;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.query.Field;
import org.springframework.data.elasticsearch.core.query.HasChildQuery;
import org.springframework.data.elasticsearch.core.query.HasParentQuery;
import org.springframework.data.elasticsearch.core.query.SimpleField;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Criteria {
    public static final String CRITERIA_VALUE_SEPARATOR = " ";
    @Nullable
    private Field field;
    private float boost = Float.NaN;
    private boolean negating = false;
    private final CriteriaChain criteriaChain = new CriteriaChain();
    private final Set<CriteriaEntry> queryCriteriaEntries = new LinkedHashSet<CriteriaEntry>();
    private final Set<CriteriaEntry> filterCriteriaEntries = new LinkedHashSet<CriteriaEntry>();
    private final Set<Criteria> subCriteria = new LinkedHashSet<Criteria>();

    public static Criteria and() {
        return new Criteria();
    }

    public static Criteria or() {
        return new OrCriteria();
    }

    public Criteria() {
    }

    public Criteria(String fieldName) {
        this(new SimpleField(fieldName));
    }

    public Criteria(Field field) {
        Assert.notNull((Object)field, (String)"Field for criteria must not be null");
        Assert.hasText((String)field.getName(), (String)"Field.name for criteria must not be null/empty");
        this.field = field;
        this.criteriaChain.add(this);
    }

    protected Criteria(List<Criteria> criteriaChain, String fieldName) {
        this(criteriaChain, new SimpleField(fieldName));
    }

    protected Criteria(List<Criteria> criteriaChain, Field field) {
        Assert.notNull(criteriaChain, (String)"CriteriaChain must not be null");
        Assert.notNull((Object)field, (String)"Field for criteria must not be null");
        Assert.hasText((String)field.getName(), (String)"Field.name for criteria must not be null/empty");
        this.field = field;
        this.criteriaChain.addAll(criteriaChain);
        this.criteriaChain.add(this);
    }

    public static Criteria where(String fieldName) {
        return new Criteria(fieldName);
    }

    public static Criteria where(Field field) {
        return new Criteria(field);
    }

    @Nullable
    public Field getField() {
        return this.field;
    }

    public Set<CriteriaEntry> getQueryCriteriaEntries() {
        return Collections.unmodifiableSet(this.queryCriteriaEntries);
    }

    public Set<CriteriaEntry> getFilterCriteriaEntries() {
        return Collections.unmodifiableSet(this.filterCriteriaEntries);
    }

    public Operator getOperator() {
        return Operator.AND;
    }

    public List<Criteria> getCriteriaChain() {
        return Collections.unmodifiableList(this.criteriaChain);
    }

    public Criteria not() {
        this.negating = true;
        return this;
    }

    public boolean isNegating() {
        return this.negating;
    }

    public Criteria boost(float boost) {
        Assert.isTrue((boost >= 0.0f ? 1 : 0) != 0, (String)"boost must not be negative");
        this.boost = boost;
        return this;
    }

    public float getBoost() {
        return this.boost;
    }

    public boolean isAnd() {
        return this.getOperator() == Operator.AND;
    }

    public boolean isOr() {
        return this.getOperator() == Operator.OR;
    }

    public Set<Criteria> getSubCriteria() {
        return this.subCriteria;
    }

    public Criteria and(Field field) {
        return new Criteria((List<Criteria>)this.criteriaChain, field);
    }

    public Criteria and(String fieldName) {
        return new Criteria((List<Criteria>)this.criteriaChain, fieldName);
    }

    public Criteria and(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"Cannot chain 'null' criteria.");
        this.criteriaChain.add(criteria);
        return this;
    }

    public Criteria and(Criteria ... criterias) {
        Assert.notNull((Object)criterias, (String)"Cannot chain 'null' criterias.");
        this.criteriaChain.addAll(Arrays.asList(criterias));
        return this;
    }

    public Criteria or(Field field) {
        return new OrCriteria((List<Criteria>)this.criteriaChain, field);
    }

    public Criteria or(String fieldName) {
        return this.or(new SimpleField(fieldName));
    }

    public Criteria or(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"Cannot chain 'null' criteria.");
        Assert.notNull((Object)criteria.getField(), (String)"Cannot chain Criteria with no field");
        OrCriteria orCriteria = new OrCriteria((List<Criteria>)this.criteriaChain, criteria.getField());
        orCriteria.queryCriteriaEntries.addAll(criteria.queryCriteriaEntries);
        orCriteria.filterCriteriaEntries.addAll(criteria.filterCriteriaEntries);
        orCriteria.subCriteria.addAll(criteria.subCriteria);
        orCriteria.boost = criteria.boost;
        orCriteria.negating = criteria.isNegating();
        return orCriteria;
    }

    public Criteria subCriteria(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria must not be null");
        this.subCriteria.add(criteria);
        return this;
    }

    public Criteria is(Object o) {
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.EQUALS, o));
        return this;
    }

    public Criteria exists() {
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.EXISTS));
        return this;
    }

    public Criteria between(@Nullable Object lowerBound, @Nullable Object upperBound) {
        if (lowerBound == null && upperBound == null) {
            throw new InvalidDataAccessApiUsageException("Range [* TO *] is not allowed");
        }
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.BETWEEN, new Object[]{lowerBound, upperBound}));
        return this;
    }

    public Criteria startsWith(String s) {
        Assert.notNull((Object)s, (String)"s may not be null");
        this.assertNoBlankInWildcardQuery(s, false, true);
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.STARTS_WITH, s));
        return this;
    }

    public Criteria contains(String s) {
        Assert.notNull((Object)s, (String)"s may not be null");
        this.assertNoBlankInWildcardQuery(s, true, true);
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.CONTAINS, s));
        return this;
    }

    public Criteria endsWith(String s) {
        Assert.notNull((Object)s, (String)"s may not be null");
        this.assertNoBlankInWildcardQuery(s, true, false);
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.ENDS_WITH, s));
        return this;
    }

    public Criteria in(Object ... values) {
        return this.in(this.toCollection(values));
    }

    public Criteria in(Iterable<?> values) {
        Assert.notNull(values, (String)"Collection of 'in' values must not be null");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.IN, values));
        return this;
    }

    public Criteria notIn(Object ... values) {
        return this.notIn(this.toCollection(values));
    }

    public Criteria notIn(Iterable<?> values) {
        Assert.notNull(values, (String)"Collection of 'NotIn' values must not be null");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.NOT_IN, values));
        return this;
    }

    public Criteria expression(String s) {
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.EXPRESSION, s));
        return this;
    }

    public Criteria fuzzy(String s) {
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.FUZZY, s));
        return this;
    }

    public Criteria lessThanEqual(Object upperBound) {
        Assert.notNull((Object)upperBound, (String)"upperBound must not be null");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.LESS_EQUAL, upperBound));
        return this;
    }

    public Criteria lessThan(Object upperBound) {
        Assert.notNull((Object)upperBound, (String)"upperBound must not be null");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.LESS, upperBound));
        return this;
    }

    public Criteria greaterThanEqual(Object lowerBound) {
        Assert.notNull((Object)lowerBound, (String)"lowerBound must not be null");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.GREATER_EQUAL, lowerBound));
        return this;
    }

    public Criteria greaterThan(Object lowerBound) {
        Assert.notNull((Object)lowerBound, (String)"lowerBound must not be null");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.GREATER, lowerBound));
        return this;
    }

    public Criteria matches(Object value) {
        Assert.notNull((Object)value, (String)"value must not be null");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.MATCHES, value));
        return this;
    }

    public Criteria matchesAll(Object value) {
        Assert.notNull((Object)value, (String)"value must not be null");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.MATCHES_ALL, value));
        return this;
    }

    public Criteria empty() {
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.EMPTY));
        return this;
    }

    public Criteria notEmpty() {
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.NOT_EMPTY));
        return this;
    }

    public Criteria regexp(String value) {
        Assert.notNull((Object)value, (String)"value must not be null");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.REGEXP, value));
        return this;
    }

    public Criteria boundedBy(GeoBox boundingBox) {
        Assert.notNull((Object)boundingBox, (String)"boundingBox value for boundedBy criteria must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.BBOX, new Object[]{boundingBox}));
        return this;
    }

    public Criteria boundedBy(Box boundingBox) {
        Assert.notNull((Object)boundingBox, (String)"boundingBox value for boundedBy criteria must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.BBOX, new Object[]{boundingBox.getFirst(), boundingBox.getSecond()}));
        return this;
    }

    public Criteria boundedBy(String topLeftGeohash, String bottomRightGeohash) {
        Assert.isTrue((boolean)StringUtils.hasLength((String)topLeftGeohash), (String)"topLeftGeohash must not be empty");
        Assert.isTrue((boolean)StringUtils.hasLength((String)bottomRightGeohash), (String)"bottomRightGeohash must not be empty");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.BBOX, new Object[]{topLeftGeohash, bottomRightGeohash}));
        return this;
    }

    public Criteria boundedBy(GeoPoint topLeftPoint, GeoPoint bottomRightPoint) {
        Assert.notNull((Object)topLeftPoint, (String)"topLeftPoint must not be null");
        Assert.notNull((Object)bottomRightPoint, (String)"bottomRightPoint must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.BBOX, new Object[]{topLeftPoint, bottomRightPoint}));
        return this;
    }

    public Criteria boundedBy(Point topLeftPoint, Point bottomRightPoint) {
        Assert.notNull((Object)topLeftPoint, (String)"topLeftPoint must not be null");
        Assert.notNull((Object)bottomRightPoint, (String)"bottomRightPoint must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.BBOX, new Object[]{GeoPoint.fromPoint(topLeftPoint), GeoPoint.fromPoint(bottomRightPoint)}));
        return this;
    }

    public Criteria within(GeoPoint location, String distance) {
        Assert.notNull((Object)location, (String)"Location value for near criteria must not be null");
        Assert.notNull((Object)location, (String)"Distance value for near criteria must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.WITHIN, new Object[]{location, distance}));
        return this;
    }

    public Criteria within(Point location, Distance distance) {
        Assert.notNull((Object)location, (String)"Location value for near criteria must not be null");
        Assert.notNull((Object)location, (String)"Distance value for near criteria must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.WITHIN, new Object[]{location, distance}));
        return this;
    }

    public Criteria within(String geoLocation, String distance) {
        Assert.isTrue((boolean)StringUtils.hasLength((String)geoLocation), (String)"geoLocation value must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.WITHIN, new Object[]{geoLocation, distance}));
        return this;
    }

    public Criteria intersects(GeoJson<?> geoShape) {
        Assert.notNull(geoShape, (String)"geoShape must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.GEO_INTERSECTS, geoShape));
        return this;
    }

    public Criteria isDisjoint(GeoJson<?> geoShape) {
        Assert.notNull(geoShape, (String)"geoShape must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.GEO_IS_DISJOINT, geoShape));
        return this;
    }

    public Criteria within(GeoJson<?> geoShape) {
        Assert.notNull(geoShape, (String)"geoShape must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.GEO_WITHIN, geoShape));
        return this;
    }

    public Criteria contains(GeoJson<?> geoShape) {
        Assert.notNull(geoShape, (String)"geoShape must not be null");
        this.filterCriteriaEntries.add(new CriteriaEntry(OperationKey.GEO_CONTAINS, geoShape));
        return this;
    }

    public Criteria hasChild(HasChildQuery query) {
        Assert.notNull((Object)query, (String)"has_child query must not be null.");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.HAS_CHILD, query));
        return this;
    }

    public Criteria hasParent(HasParentQuery query) {
        Assert.notNull((Object)query, (String)"has_parent query must not be null.");
        this.queryCriteriaEntries.add(new CriteriaEntry(OperationKey.HAS_PARENT, query));
        return this;
    }

    private void assertNoBlankInWildcardQuery(String searchString, boolean leadingWildcard, boolean trailingWildcard) {
        if (searchString.contains(CRITERIA_VALUE_SEPARATOR)) {
            throw new InvalidDataAccessApiUsageException("Cannot constructQuery '" + (leadingWildcard ? "*" : "") + "\"" + searchString + "\"" + (trailingWildcard ? "*" : "") + "'. Use expression or multiple clauses instead.");
        }
    }

    private List<Object> toCollection(Object ... values) {
        return Arrays.asList(values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Criteria criteria = (Criteria)o;
        if (Float.compare(criteria.boost, this.boost) != 0) {
            return false;
        }
        if (this.negating != criteria.negating) {
            return false;
        }
        if (!Objects.equals(this.field, criteria.field)) {
            return false;
        }
        if (!this.criteriaChain.filter(this).equals(criteria.criteriaChain.filter(criteria))) {
            return false;
        }
        if (!this.queryCriteriaEntries.equals(criteria.queryCriteriaEntries)) {
            return false;
        }
        if (!this.filterCriteriaEntries.equals(criteria.filterCriteriaEntries)) {
            return false;
        }
        return this.subCriteria.equals(criteria.subCriteria);
    }

    public int hashCode() {
        int result = this.field != null ? this.field.hashCode() : 0;
        result = 31 * result + (this.boost != 0.0f ? Float.floatToIntBits(this.boost) : 0);
        result = 31 * result + (this.negating ? 1 : 0);
        result = 31 * result + this.criteriaChain.filter(this).hashCode();
        result = 31 * result + this.queryCriteriaEntries.hashCode();
        result = 31 * result + this.filterCriteriaEntries.hashCode();
        result = 31 * result + this.subCriteria.hashCode();
        return result;
    }

    public String toString() {
        return "Criteria{field=" + String.valueOf(this.field) + ", boost=" + this.boost + ", negating=" + this.negating + ", queryCriteriaEntries=" + String.valueOf(this.queryCriteriaEntries) + ", filterCriteriaEntries=" + String.valueOf(this.filterCriteriaEntries) + ", subCriteria=" + String.valueOf(this.subCriteria) + "}";
    }

    static class OrCriteria
    extends Criteria {
        public OrCriteria() {
        }

        public OrCriteria(String fieldName) {
            super(fieldName);
        }

        public OrCriteria(Field field) {
            super(field);
        }

        public OrCriteria(List<Criteria> criteriaChain, String fieldName) {
            super(criteriaChain, fieldName);
        }

        public OrCriteria(List<Criteria> criteriaChain, Field field) {
            super(criteriaChain, field);
        }

        @Override
        public Operator getOperator() {
            return Operator.OR;
        }
    }

    public static class CriteriaChain
    extends LinkedList<Criteria> {
        List<Criteria> filter(Criteria criteria) {
            return this.stream().filter((? super T c) -> c != criteria).collect(Collectors.toList());
        }
    }

    public static enum Operator {
        AND,
        OR;

    }

    public static class CriteriaEntry {
        private final OperationKey key;
        @Nullable
        private Object value;

        protected CriteriaEntry(OperationKey key) {
            Assert.isTrue((boolean)key.hasNoValue(), (String)"key must be OperationKey.EXISTS, OperationKey.EMPTY or OperationKey.NOT_EMPTY for this call");
            this.key = key;
        }

        CriteriaEntry(OperationKey key, Object value) {
            Assert.notNull((Object)((Object)key), (String)"key must not be null");
            Assert.notNull((Object)value, (String)"value must not be null");
            this.key = key;
            this.value = value;
        }

        public OperationKey getKey() {
            return this.key;
        }

        public void setValue(Object value) {
            Assert.notNull((Object)value, (String)"value must not be null");
            this.value = value;
        }

        public Object getValue() {
            Assert.isTrue((this.key != OperationKey.EXISTS ? 1 : 0) != 0, (String)(this.key.name() + " has no value"));
            Assert.notNull((Object)this.value, (String)"unexpected null value");
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CriteriaEntry that = (CriteriaEntry)o;
            if (this.key != that.key) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CriteriaEntry{key=" + String.valueOf((Object)this.key) + ", value=" + String.valueOf(this.value) + "}";
        }
    }

    public static enum OperationKey {
        EQUALS,
        CONTAINS,
        STARTS_WITH,
        ENDS_WITH,
        EXPRESSION,
        BETWEEN,
        FUZZY,
        MATCHES,
        MATCHES_ALL,
        IN,
        NOT_IN,
        WITHIN,
        BBOX,
        LESS,
        LESS_EQUAL,
        GREATER,
        GREATER_EQUAL,
        EXISTS,
        GEO_INTERSECTS,
        GEO_IS_DISJOINT,
        GEO_WITHIN,
        GEO_CONTAINS,
        EMPTY,
        NOT_EMPTY,
        REGEXP,
        HAS_CHILD,
        HAS_PARENT;


        public boolean hasNoValue() {
            return this == EXISTS || this == EMPTY || this == NOT_EMPTY;
        }

        public boolean hasValue() {
            return !this.hasNoValue();
        }
    }
}

