/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.routing.RoutingResolver;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleElasticsearchRepository<T, ID>
implements ElasticsearchRepository<T, ID> {
    protected ElasticsearchOperations operations;
    protected IndexOperations indexOperations;
    protected Class<T> entityClass;
    protected ElasticsearchEntityInformation<T, ID> entityInformation;

    public SimpleElasticsearchRepository(ElasticsearchEntityInformation<T, ID> metadata, ElasticsearchOperations operations) {
        this.operations = operations;
        Assert.notNull(metadata, (String)"ElasticsearchEntityInformation must not be null!");
        this.entityInformation = metadata;
        this.entityClass = this.entityInformation.getJavaType();
        this.indexOperations = operations.indexOps(this.entityClass);
        if (this.shouldCreateIndexAndMapping() && !this.indexOperations.exists()) {
            this.indexOperations.createWithMapping();
        } else if (this.shouldAlwaysWriteMapping()) {
            this.indexOperations.putMapping();
        }
    }

    private boolean shouldCreateIndexAndMapping() {
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.operations.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(this.entityClass);
        return entity.isCreateIndexAndMapping();
    }

    private boolean shouldAlwaysWriteMapping() {
        return ((ElasticsearchPersistentEntity)this.operations.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(this.entityClass)).isAlwaysWriteMapping();
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.execute(operations -> operations.get(this.stringIdRepresentation(id), this.entityClass, this.getIndexCoordinates())));
    }

    public Iterable<T> findAll() {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        return this.findAll((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"pageable must not be null");
        Query query = Query.findAll();
        query.setPageable(pageable);
        SearchHits searchHits = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()));
        SearchPage page = SearchHitSupport.searchPageFor(searchHits, query.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    public Iterable<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"sort must not be null");
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        PageRequest pageable = PageRequest.of((int)0, (int)itemCount, (Sort)sort);
        Query query = Query.findAll();
        query.setPageable((Pageable)pageable);
        List searchHitList = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()).getSearchHits());
        return (List)SearchHitSupport.unwrapSearchHits(searchHitList);
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"ids can't be null.");
        List<String> stringIds = this.stringIdsRepresentation(ids);
        Query query = this.getIdQuery(stringIds);
        if (!stringIds.isEmpty()) {
            query.setPageable((Pageable)PageRequest.of((int)0, (int)stringIds.size()));
        }
        List searchHitList = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()).getSearchHits());
        return (List)SearchHitSupport.unwrapSearchHits(searchHitList);
    }

    public long count() {
        Query query = Query.findAll();
        ((BaseQuery)query).setMaxResults(0);
        return this.execute(operations -> operations.count(query, this.entityClass, this.getIndexCoordinates()));
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Cannot save 'null' entity.");
        return (S)this.executeAndRefresh(operations -> operations.save(entity, this.getIndexCoordinates()));
    }

    @Override
    public <S extends T> S save(S entity, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(entity, (String)"entity must not be null");
        return (S)this.executeAndRefresh(operations -> operations.save(entity, this.getIndexCoordinates()), refreshPolicy);
    }

    public <S extends T> List<S> save(List<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        return Streamable.of(this.saveAll(entities)).stream().collect(Collectors.toList());
    }

    @Override
    public <S extends T> List<S> save(List<S> entities, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        return Streamable.of(this.saveAll(entities, refreshPolicy)).stream().collect(Collectors.toList());
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        this.executeAndRefresh(operations -> operations.save(entities, indexCoordinates));
        return entities;
    }

    @Override
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        this.executeAndRefresh(operations -> operations.save(entities, indexCoordinates), refreshPolicy);
        return entities;
    }

    public boolean existsById(ID id) {
        return this.execute(operations -> operations.exists(this.stringIdRepresentation(id), this.getIndexCoordinates()));
    }

    @Override
    public Page<T> searchSimilar(T entity, @Nullable String[] fields, Pageable pageable) {
        Assert.notNull(entity, (String)"Cannot search similar records for 'null'.");
        Assert.notNull((Object)pageable, (String)"'pageable' cannot be 'null'");
        MoreLikeThisQuery query = new MoreLikeThisQuery();
        query.setId(this.stringIdRepresentation(this.extractIdFromBean(entity)));
        query.setPageable(pageable);
        if (fields != null) {
            query.addFields(fields);
        }
        SearchHits searchHits = this.execute(operations -> operations.search(query, this.entityClass, this.getIndexCoordinates()));
        SearchPage searchPage = SearchHitSupport.searchPageFor(searchHits, pageable);
        return (Page)SearchHitSupport.unwrapSearchHits(searchPage);
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"Cannot delete entity with id 'null'.");
        this.doDelete(id, null, this.getIndexCoordinates());
    }

    @Override
    public void deleteById(ID id, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(id, (String)"Cannot delete entity with id 'null'.");
        this.doDelete(id, null, this.getIndexCoordinates(), refreshPolicy);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Cannot delete 'null' entity.");
        this.doDelete(this.extractIdFromBean(entity), this.operations.getEntityRouting(entity), this.getIndexCoordinates());
    }

    @Override
    public void delete(T entity, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(entity, (String)"Cannot delete 'null' entity.");
        this.doDelete(this.extractIdFromBean(entity), this.operations.getEntityRouting(entity), this.getIndexCoordinates(), refreshPolicy);
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"Cannot delete 'null' list.");
        ArrayList<String> idStrings = new ArrayList<String>();
        for (ID id : ids) {
            idStrings.add(this.stringIdRepresentation(id));
        }
        if (idStrings.isEmpty()) {
            return;
        }
        Query query = this.operations.idsQuery(idStrings);
        this.executeAndRefresh(operations -> {
            operations.delete(query, this.entityClass, this.getIndexCoordinates());
            return null;
        });
    }

    @Override
    public void deleteAllById(Iterable<? extends ID> ids, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull(ids, (String)"Cannot delete 'null' list.");
        ArrayList<String> idStrings = new ArrayList<String>();
        for (ID id : ids) {
            idStrings.add(this.stringIdRepresentation(id));
        }
        if (idStrings.isEmpty()) {
            return;
        }
        Query query = this.operations.idsQuery(idStrings);
        this.executeAndRefresh(operations -> {
            operations.delete(query, this.entityClass, this.getIndexCoordinates());
            return null;
        });
    }

    public void deleteAll(Iterable<? extends T> entities) {
        this.deleteAllById(this.getEntityIds(entities));
    }

    @Override
    public void deleteAll(Iterable<? extends T> entities, @Nullable RefreshPolicy refreshPolicy) {
        this.deleteAllById(this.getEntityIds(entities), refreshPolicy);
    }

    @NotNull
    private List<ID> getEntityIds(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Cannot delete 'null' list.");
        ArrayList<ID> ids = new ArrayList<ID>();
        for (T entity : entities) {
            ID id = this.extractIdFromBean(entity);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    private void doDelete(@Nullable ID id, @Nullable String routing, IndexCoordinates indexCoordinates) {
        if (id != null) {
            this.executeAndRefresh(operations -> {
                ElasticsearchOperations ops = routing != null ? operations.withRouting(RoutingResolver.just(routing)) : operations;
                return ops.delete(this.stringIdRepresentation(id), indexCoordinates);
            });
        }
    }

    private void doDelete(@Nullable ID id, @Nullable String routing, IndexCoordinates indexCoordinates, @Nullable RefreshPolicy refreshPolicy) {
        if (id != null) {
            this.executeAndRefresh(operations -> {
                ElasticsearchOperations ops = routing != null ? operations.withRouting(RoutingResolver.just(routing)) : operations;
                return ops.delete(this.stringIdRepresentation(id), indexCoordinates);
            }, refreshPolicy);
        }
    }

    public void deleteAll() {
        this.executeAndRefresh(operations -> {
            operations.delete(Query.findAll(), this.entityClass, this.getIndexCoordinates());
            return null;
        });
    }

    @Override
    public void deleteAll(@Nullable RefreshPolicy refreshPolicy) {
        this.executeAndRefresh(operations -> {
            operations.delete(Query.findAll(), this.entityClass, this.getIndexCoordinates());
            return null;
        }, refreshPolicy);
    }

    private void doRefresh() {
        RefreshPolicy refreshPolicy = null;
        ElasticsearchOperations elasticsearchOperations = this.operations;
        if (elasticsearchOperations instanceof AbstractElasticsearchTemplate) {
            AbstractElasticsearchTemplate template = (AbstractElasticsearchTemplate)elasticsearchOperations;
            refreshPolicy = template.getRefreshPolicy();
        }
        if (refreshPolicy == null) {
            this.indexOperations.refresh();
        }
    }

    @Nullable
    protected ID extractIdFromBean(T entity) {
        return (ID)this.entityInformation.getId(entity);
    }

    private List<String> stringIdsRepresentation(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"ids can't be null.");
        return StreamUtils.createStreamFromIterator(ids.iterator()).map(this::stringIdRepresentation).collect(Collectors.toList());
    }

    @Nullable
    protected String stringIdRepresentation(@Nullable ID id) {
        return this.operations.convertId(id);
    }

    private IndexCoordinates getIndexCoordinates() {
        return this.operations.getIndexCoordinatesFor(this.entityClass);
    }

    private Query getIdQuery(List<String> stringIds) {
        return this.operations.idsQuery(stringIds);
    }

    @Nullable
    public <R> R execute(OperationsCallback<R> callback) {
        return callback.doWithOperations(this.operations);
    }

    @Nullable
    public <R> R executeAndRefresh(OperationsCallback<R> callback) {
        R result = callback.doWithOperations(this.operations);
        this.doRefresh();
        return result;
    }

    @Nullable
    public <R> R executeAndRefresh(OperationsCallback<R> callback, @Nullable RefreshPolicy refreshPolicy) {
        R result = callback.doWithOperations(this.operations.withRefreshPolicy(refreshPolicy));
        this.doRefresh();
        return result;
    }

    @FunctionalInterface
    public static interface OperationsCallback<R> {
        @Nullable
        public R doWithOperations(ElasticsearchOperations var1);
    }
}

