/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.elasticsearch.support.Version;
import org.springframework.lang.Nullable;

public final class VersionInfo {
    private static final Log LOGGER = LogFactory.getLog(VersionInfo.class);
    private static final String VERSION_PROPERTIES = "versions.properties";
    public static final String VERSION_SPRING_DATA_ELASTICSEARCH = "version.spring-data-elasticsearch";
    public static final String VERSION_ELASTICSEARCH_CLIENT = "version.elasticsearch-client";
    private static Properties versionProperties;

    public static Properties versionProperties() {
        return versionProperties;
    }

    public static void logVersions(String vendor, String runtimeLibraryVersion, @Nullable String clusterVersion) {
        try {
            String versionSpringDataElasticsearch = versionProperties.getProperty(VERSION_SPRING_DATA_ELASTICSEARCH);
            Version versionBuiltLibraryES = Version.fromString(versionProperties.getProperty(VERSION_ELASTICSEARCH_CLIENT));
            Version versionRuntimeLibrary = Version.fromString(runtimeLibraryVersion);
            Version versionCluster = clusterVersion != null ? Version.fromString(clusterVersion) : null;
            LOGGER.info((Object)String.format("Version Spring Data Elasticsearch: %s", versionSpringDataElasticsearch));
            LOGGER.info((Object)String.format("Version Elasticsearch client in build: %s", versionBuiltLibraryES));
            LOGGER.info((Object)String.format("Version runtime client used: %s - %s", vendor, versionRuntimeLibrary));
            if (VersionInfo.differInMajorOrMinor(versionBuiltLibraryES, versionRuntimeLibrary)) {
                LOGGER.warn((Object)String.format("Version mismatch in between Elasticsearch Clients build/use: %s - %s", versionBuiltLibraryES, versionRuntimeLibrary));
            }
            if (versionCluster != null) {
                LOGGER.info((Object)String.format("Version cluster: %s - %s", vendor, versionCluster));
                if (VersionInfo.differInMajorOrMinor(versionRuntimeLibrary, versionCluster)) {
                    LOGGER.warn((Object)String.format("Version mismatch in between  Client and Cluster: %s - %s - %s", vendor, versionRuntimeLibrary, versionCluster));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)String.format("Could not log version info: %s - %s", e.getClass().getSimpleName(), e.getMessage()));
        }
    }

    private static Properties loadVersionProperties() throws IOException {
        InputStream resource = VersionInfo.class.getClassLoader().getResourceAsStream(VERSION_PROPERTIES);
        if (resource != null) {
            Properties properties = new Properties();
            properties.load(resource);
            return properties;
        }
        throw new IllegalStateException("Resource not found");
    }

    private static boolean differInMajorOrMinor(Version version1, Version version2) {
        return version1.major() != version2.major() || version1.minor() != version2.minor();
    }

    private VersionInfo() {
    }

    static {
        try {
            versionProperties = VersionInfo.loadVersionProperties();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Could not load versions.properties", (Throwable)e);
            versionProperties = new Properties();
            versionProperties.put(VERSION_SPRING_DATA_ELASTICSEARCH, "0.0.0");
            versionProperties.put(VERSION_ELASTICSEARCH_CLIENT, "0.0.0");
        }
    }
}

