/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.GetIndexTemplatesResponse;
import org.elasticsearch.client.indices.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.cluster.ClusterHealth;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.reindex.ReindexResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ResponseConverter {
    private ResponseConverter() {
    }

    public static Map<String, Set<AliasData>> aliasDatas(Map<String, Set<AliasMetadata>> aliasesMetadatas) {
        LinkedHashMap<String, Set<AliasData>> converted = new LinkedHashMap<String, Set<AliasData>>();
        aliasesMetadatas.forEach((index, aliasMetaDataSet) -> {
            LinkedHashSet aliasDataSet = new LinkedHashSet();
            aliasMetaDataSet.forEach(aliasMetaData -> aliasDataSet.add(ResponseConverter.toAliasData(aliasMetaData)));
            converted.put((String)index, aliasDataSet);
        });
        return converted;
    }

    public static AliasData toAliasData(AliasMetadata aliasMetaData) {
        Document filter = null;
        CompressedXContent aliasMetaDataFilter = aliasMetaData.getFilter();
        if (aliasMetaDataFilter != null) {
            filter = Document.parse(aliasMetaDataFilter.string());
        }
        return AliasData.of(aliasMetaData.alias(), filter, aliasMetaData.indexRouting(), aliasMetaData.getSearchRouting(), aliasMetaData.writeIndex(), aliasMetaData.isHidden());
    }

    public static List<IndexInformation> getIndexInformations(GetIndexResponse getIndexResponse) {
        Assert.notNull((Object)getIndexResponse, (String)"getIndexResponse must not be null");
        ArrayList<IndexInformation> indexInformationList = new ArrayList<IndexInformation>();
        for (String indexName : getIndexResponse.getIndices()) {
            Settings settings = ResponseConverter.settingsFromGetIndexResponse(getIndexResponse, indexName);
            Document mappings = ResponseConverter.mappingsFromGetIndexResponse(getIndexResponse, indexName);
            List<AliasData> aliases = ResponseConverter.aliasDataFromIndexResponse(getIndexResponse, indexName);
            indexInformationList.add(IndexInformation.of(indexName, settings, mappings, aliases));
        }
        return indexInformationList;
    }

    private static Settings settingsFromGetIndexResponse(GetIndexResponse getIndexResponse, String indexName) {
        Settings settings = new Settings();
        org.elasticsearch.common.settings.Settings indexSettings = (org.elasticsearch.common.settings.Settings)getIndexResponse.getSettings().get(indexName);
        if (!indexSettings.isEmpty()) {
            for (String key : indexSettings.keySet()) {
                settings.put(key, (Object)indexSettings.get(key));
            }
        }
        return settings;
    }

    private static Document mappingsFromGetIndexResponse(GetIndexResponse getIndexResponse, String indexName) {
        Document document = Document.create();
        if (getIndexResponse.getMappings().containsKey(indexName)) {
            MappingMetadata mappings = (MappingMetadata)getIndexResponse.getMappings().get(indexName);
            document = Document.from(mappings.getSourceAsMap());
        }
        return document;
    }

    private static List<AliasData> aliasDataFromIndexResponse(GetIndexResponse getIndexResponse, String indexName) {
        List<AliasData> aliases = Collections.emptyList();
        if (getIndexResponse.getAliases().get(indexName) != null) {
            aliases = ((List)getIndexResponse.getAliases().get(indexName)).stream().map(ResponseConverter::toAliasData).collect(Collectors.toList());
        }
        return aliases;
    }

    public static List<IndexInformation> getIndexInformations(org.elasticsearch.action.admin.indices.get.GetIndexResponse getIndexResponse) {
        ArrayList<IndexInformation> indexInformationList = new ArrayList<IndexInformation>();
        for (String indexName : getIndexResponse.getIndices()) {
            Settings settings = ResponseConverter.settingsFromGetIndexResponse(getIndexResponse, indexName);
            Document mappings = ResponseConverter.mappingsFromGetIndexResponse(getIndexResponse, indexName);
            List<AliasData> aliases = ResponseConverter.aliasDataFromIndexResponse(getIndexResponse, indexName);
            indexInformationList.add(IndexInformation.of(indexName, settings, mappings, aliases));
        }
        return indexInformationList;
    }

    private static Settings settingsFromGetIndexResponse(org.elasticsearch.action.admin.indices.get.GetIndexResponse getIndexResponse, String indexName) {
        Settings settings = new Settings();
        if (getIndexResponse.getSettings().containsKey((Object)indexName)) {
            org.elasticsearch.common.settings.Settings indexSettings = (org.elasticsearch.common.settings.Settings)getIndexResponse.getSettings().get((Object)indexName);
            for (String key : indexSettings.keySet()) {
                settings.put(key, (Object)indexSettings.get(key));
            }
        }
        return settings;
    }

    private static Document mappingsFromGetIndexResponse(org.elasticsearch.action.admin.indices.get.GetIndexResponse getIndexResponse, String indexName) {
        boolean responseHasMappings;
        Document document = Document.create();
        boolean bl = responseHasMappings = getIndexResponse.getMappings().containsKey((Object)indexName) && ((ImmutableOpenMap)getIndexResponse.getMappings().get((Object)indexName)).get((Object)"_doc") != null;
        if (responseHasMappings) {
            MappingMetadata mappings = (MappingMetadata)((ImmutableOpenMap)getIndexResponse.getMappings().get((Object)indexName)).get((Object)"_doc");
            document = Document.from(mappings.getSourceAsMap());
        }
        return document;
    }

    private static List<AliasData> aliasDataFromIndexResponse(org.elasticsearch.action.admin.indices.get.GetIndexResponse getIndexResponse, String indexName) {
        List<AliasData> aliases = Collections.emptyList();
        if (getIndexResponse.getAliases().get((Object)indexName) != null) {
            aliases = ((List)getIndexResponse.getAliases().get((Object)indexName)).stream().map(ResponseConverter::toAliasData).collect(Collectors.toList());
        }
        return aliases;
    }

    @Nullable
    public static TemplateData getTemplateData(GetIndexTemplatesResponse getIndexTemplatesResponse, String templateName) {
        for (IndexTemplateMetadata indexTemplateMetadata : getIndexTemplatesResponse.getIndexTemplates()) {
            if (!indexTemplateMetadata.name().equals(templateName)) continue;
            Settings settings = new Settings();
            org.elasticsearch.common.settings.Settings templateSettings = indexTemplateMetadata.settings();
            templateSettings.keySet().forEach(key -> settings.put((String)key, (Object)templateSettings.get(key)));
            LinkedHashMap<String, AliasData> aliases = new LinkedHashMap<String, AliasData>();
            ImmutableOpenMap aliasesResponse = indexTemplateMetadata.aliases();
            Iterator keysIt = aliasesResponse.keysIt();
            while (keysIt.hasNext()) {
                String key2 = (String)keysIt.next();
                aliases.put(key2, ResponseConverter.toAliasData((AliasMetadata)aliasesResponse.get((Object)key2)));
            }
            return TemplateData.builder().withIndexPatterns(indexTemplateMetadata.patterns().toArray(new String[0])).withSettings(settings).withMapping(Document.from(indexTemplateMetadata.mappings().getSourceAsMap())).withAliases(aliases).withOrder(indexTemplateMetadata.order()).withVersion(indexTemplateMetadata.version()).build();
        }
        return null;
    }

    public static Settings fromSettingsResponse(GetSettingsResponse response, String indexName) {
        Settings settings = new Settings();
        if (!response.getIndexToDefaultSettings().isEmpty()) {
            org.elasticsearch.common.settings.Settings defaultSettings = (org.elasticsearch.common.settings.Settings)response.getIndexToDefaultSettings().get((Object)indexName);
            for (String key : defaultSettings.keySet()) {
                settings.put(key, (Object)defaultSettings.get(key));
            }
        }
        if (!response.getIndexToSettings().isEmpty()) {
            org.elasticsearch.common.settings.Settings customSettings = (org.elasticsearch.common.settings.Settings)response.getIndexToSettings().get((Object)indexName);
            for (String key : customSettings.keySet()) {
                settings.put(key, (Object)customSettings.get(key));
            }
        }
        return settings;
    }

    @Nullable
    public static MultiGetItem.Failure getFailure(MultiGetItemResponse itemResponse) {
        MultiGetResponse.Failure responseFailure = itemResponse.getFailure();
        return responseFailure != null ? MultiGetItem.Failure.of(responseFailure.getIndex(), responseFailure.getType(), responseFailure.getId(), responseFailure.getFailure(), null) : null;
    }

    public static ClusterHealth clusterHealth(ClusterHealthResponse clusterHealthResponse) {
        return ClusterHealth.builder().withActivePrimaryShards(clusterHealthResponse.getActivePrimaryShards()).withActiveShards(clusterHealthResponse.getActiveShards()).withActiveShardsPercent(clusterHealthResponse.getActiveShardsPercent()).withClusterName(clusterHealthResponse.getClusterName()).withDelayedUnassignedShards(clusterHealthResponse.getDelayedUnassignedShards()).withInitializingShards(clusterHealthResponse.getInitializingShards()).withNumberOfDataNodes(clusterHealthResponse.getNumberOfDataNodes()).withNumberOfInFlightFetch(clusterHealthResponse.getNumberOfInFlightFetch()).withNumberOfNodes(clusterHealthResponse.getNumberOfNodes()).withNumberOfPendingTasks(clusterHealthResponse.getNumberOfPendingTasks()).withRelocatingShards(clusterHealthResponse.getRelocatingShards()).withStatus(clusterHealthResponse.getStatus().toString()).withTaskMaxWaitingTimeMillis(clusterHealthResponse.getTaskMaxWaitingTime().millis()).withTimedOut(clusterHealthResponse.isTimedOut()).withUnassignedShards(clusterHealthResponse.getUnassignedShards()).build();
    }

    public static ByQueryResponse byQueryResponseOf(BulkByScrollResponse bulkByScrollResponse) {
        List<ByQueryResponse.Failure> failures = bulkByScrollResponse.getBulkFailures().stream().map(ResponseConverter::byQueryResponseFailureOf).collect(Collectors.toList());
        List<ByQueryResponse.SearchFailure> searchFailures = bulkByScrollResponse.getSearchFailures().stream().map(ResponseConverter::byQueryResponseSearchFailureOf).collect(Collectors.toList());
        return ByQueryResponse.builder().withTook(bulkByScrollResponse.getTook().getMillis()).withTimedOut(bulkByScrollResponse.isTimedOut()).withTotal(bulkByScrollResponse.getTotal()).withUpdated(bulkByScrollResponse.getUpdated()).withDeleted(bulkByScrollResponse.getDeleted()).withBatches(bulkByScrollResponse.getBatches()).withVersionConflicts(bulkByScrollResponse.getVersionConflicts()).withNoops(bulkByScrollResponse.getNoops()).withBulkRetries(bulkByScrollResponse.getBulkRetries()).withSearchRetries(bulkByScrollResponse.getSearchRetries()).withReasonCancelled(bulkByScrollResponse.getReasonCancelled()).withFailures(failures).withSearchFailure(searchFailures).build();
    }

    public static ByQueryResponse.Failure byQueryResponseFailureOf(BulkItemResponse.Failure failure) {
        return ByQueryResponse.Failure.builder().withIndex(failure.getIndex()).withType(failure.getType()).withId(failure.getId()).withStatus(failure.getStatus().getStatus()).withAborted(failure.isAborted()).withCause(failure.getCause()).withSeqNo(failure.getSeqNo()).withTerm(failure.getTerm()).build();
    }

    public static ByQueryResponse.SearchFailure byQueryResponseSearchFailureOf(ScrollableHitSource.SearchFailure searchFailure) {
        return ByQueryResponse.SearchFailure.builder().withReason(searchFailure.getReason()).withIndex(searchFailure.getIndex()).withNodeId(searchFailure.getNodeId()).withShardId(searchFailure.getShardId()).withStatus(searchFailure.getStatus().getStatus()).build();
    }

    public static ReindexResponse reindexResponseOf(BulkByScrollResponse bulkByScrollResponse) {
        List<ReindexResponse.Failure> failures = bulkByScrollResponse.getBulkFailures().stream().map(ResponseConverter::reindexResponseFailureOf).collect(Collectors.toList());
        return ReindexResponse.builder().withTook(bulkByScrollResponse.getTook().getMillis()).withTimedOut(bulkByScrollResponse.isTimedOut()).withTotal(bulkByScrollResponse.getTotal()).withCreated(bulkByScrollResponse.getCreated()).withUpdated(bulkByScrollResponse.getUpdated()).withDeleted(bulkByScrollResponse.getDeleted()).withBatches(bulkByScrollResponse.getBatches()).withVersionConflicts(bulkByScrollResponse.getVersionConflicts()).withNoops(bulkByScrollResponse.getNoops()).withBulkRetries(bulkByScrollResponse.getBulkRetries()).withSearchRetries(bulkByScrollResponse.getSearchRetries()).withThrottledMillis(bulkByScrollResponse.getStatus().getThrottled().getMillis()).withRequestsPerSecond(bulkByScrollResponse.getStatus().getRequestsPerSecond()).withThrottledUntilMillis(bulkByScrollResponse.getStatus().getThrottledUntil().getMillis()).withFailures(failures).build();
    }

    public static ReindexResponse.Failure reindexResponseFailureOf(BulkItemResponse.Failure failure) {
        return ReindexResponse.Failure.builder().withIndex(failure.getIndex()).withType(failure.getType()).withId(failure.getId()).withStatus(failure.getStatus().getStatus()).withAborted(failure.isAborted()).withCause(failure.getCause()).withSeqNo(failure.getSeqNo()).withTerm(failure.getTerm()).build();
    }
}

