/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.lang.Nullable;

public abstract class BaseQueryBuilder<Q extends BaseQuery, SELF extends BaseQueryBuilder<Q, SELF>> {
    @Nullable
    private Pageable pageable;
    @Nullable
    private Sort sort;
    @Nullable
    private Integer maxResults;
    @Nullable
    private Collection<String> ids;
    private boolean trackScores;
    @Nullable
    protected IndicesOptions indicesOptions;
    private float minScore;
    @Nullable
    private String preference;
    @Nullable
    private SourceFilter sourceFilter;
    private List<String> fields = new ArrayList<String>();
    @Nullable
    protected HighlightQuery highlightQuery;
    @Nullable
    private String route;
    @Nullable
    private List<IndexBoost> indicesBoost;

    @Nullable
    public Pageable getPageable() {
        return this.pageable;
    }

    @Nullable
    public Sort getSort() {
        return this.sort;
    }

    @Nullable
    public Integer getMaxResults() {
        return this.maxResults;
    }

    @Nullable
    public Collection<String> getIds() {
        return this.ids;
    }

    public boolean getTrackScores() {
        return this.trackScores;
    }

    @Nullable
    public IndicesOptions getIndicesOptions() {
        return this.indicesOptions;
    }

    public float getMinScore() {
        return this.minScore;
    }

    @Nullable
    public String getPreference() {
        return this.preference;
    }

    @Nullable
    public SourceFilter getSourceFilter() {
        return this.sourceFilter;
    }

    public List<String> getFields() {
        return this.fields;
    }

    @Nullable
    public HighlightQuery getHighlightQuery() {
        return this.highlightQuery;
    }

    @Nullable
    public String getRoute() {
        return this.route;
    }

    @Nullable
    public List<IndexBoost> getIndicesBoost() {
        return this.indicesBoost;
    }

    public SELF withPageable(Pageable pageable) {
        this.pageable = pageable;
        return this.self();
    }

    public SELF withSort(Sort sort) {
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return this.self();
    }

    public SELF withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this.self();
    }

    public SELF withIds(String ... ids) {
        this.ids = Arrays.asList(ids);
        return this.self();
    }

    public SELF withIds(Collection<String> ids) {
        this.ids = ids;
        return this.self();
    }

    public SELF withTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this.self();
    }

    public SELF withIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this.self();
    }

    public SELF withMinScore(float minScore) {
        this.minScore = minScore;
        return this.self();
    }

    public SELF withPreference(String preference) {
        this.preference = preference;
        return this.self();
    }

    public SELF withSourceFilter(SourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
        return this.self();
    }

    public SELF withFields(String ... fields) {
        Collections.addAll(this.fields, fields);
        return this.self();
    }

    public SELF withFields(Collection<String> fields) {
        this.fields.addAll(fields);
        return this.self();
    }

    public SELF withHighlightQuery(HighlightQuery highlightQuery) {
        this.highlightQuery = highlightQuery;
        return this.self();
    }

    public SELF withRoute(String route) {
        this.route = route;
        return this.self();
    }

    public SELF withIndicesBoost(List<IndexBoost> indicesBoost) {
        this.indicesBoost = indicesBoost;
        return this.self();
    }

    public SELF withIndicesBoost(IndexBoost ... indicesBoost) {
        this.indicesBoost = Arrays.asList(indicesBoost);
        return this.self();
    }

    public abstract Q build();

    private SELF self() {
        return (SELF)this;
    }
}

