/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.Version;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.elasticsearch.BulkFailureException;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;

public abstract class AbstractElasticsearchRestTransportTemplate
extends AbstractElasticsearchTemplate {
    protected List<IndexedObjectInformation> checkForBulkOperationFailure(BulkResponse bulkResponse) {
        if (bulkResponse.hasFailures()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedDocuments.put(item.getId(), item.getFailureMessage());
            }
            throw new BulkFailureException("Bulk operation has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + ']', failedDocuments);
        }
        return Stream.of(bulkResponse.getItems()).map(bulkItemResponse -> {
            DocWriteResponse response = bulkItemResponse.getResponse();
            if (response != null) {
                return IndexedObjectInformation.of(response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion());
            }
            return IndexedObjectInformation.of(bulkItemResponse.getId(), null, null, null);
        }).collect(Collectors.toList());
    }

    @Override
    protected <T> SearchHits<T> doSearch(MoreLikeThisQuery query, Class<T> clazz, IndexCoordinates index) {
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = this.requestFactory.moreLikeThisQueryBuilder(query, index);
        return this.search(new NativeSearchQueryBuilder().withQuery((QueryBuilder)moreLikeThisQueryBuilder).withPageable(query.getPageable()).build(), clazz, index);
    }

    @Override
    public <T> List<SearchHits<T>> multiSearch(List<? extends Query> queries, Class<T> clazz, IndexCoordinates index) {
        MultiSearchRequest request = new MultiSearchRequest();
        for (Query query : queries) {
            request.add(this.requestFactory.searchRequest(query, clazz, index));
        }
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> readDocumentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this.elasticsearchConverter, clazz, index);
        AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback<T>(clazz, index);
        ArrayList<SearchHits<T>> res = new ArrayList<SearchHits<T>>(queries.size());
        int c = 0;
        for (Query query : queries) {
            int n = c++;
            res.add((SearchHits<T>)callback.doWith(SearchDocumentResponse.from(items[n].getResponse(), readDocumentCallback::doWith)));
        }
        return res;
    }

    @Override
    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(classes, (String)"classes must not be null");
        Assert.isTrue((queries.size() == classes.size() ? 1 : 0) != 0, (String)"queries and classes must have the same size");
        MultiSearchRequest request = new MultiSearchRequest();
        Iterator<Class<?>> it = classes.iterator();
        for (Query query : queries) {
            Class<?> clazz = it.next();
            request.add(this.requestFactory.searchRequest(query, clazz, this.getIndexCoordinatesFor(clazz)));
        }
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ArrayList arrayList = new ArrayList(queries.size());
        int c = 0;
        Iterator<Class<?>> it1 = classes.iterator();
        for (Query query : queries) {
            Class<?> entityClass = it1.next();
            IndexCoordinates index = this.getIndexCoordinatesFor(entityClass);
            AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((EntityReader<?, Document>)this.elasticsearchConverter, entityClass, index);
            AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback(entityClass, index);
            SearchResponse response = items[c++].getResponse();
            arrayList.add((SearchHits<?>)callback.doWith(SearchDocumentResponse.from(response, documentCallback::doWith)));
        }
        return arrayList;
    }

    @Override
    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes, IndexCoordinates index) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(classes, (String)"classes must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.isTrue((queries.size() == classes.size() ? 1 : 0) != 0, (String)"queries and classes must have the same size");
        MultiSearchRequest request = new MultiSearchRequest();
        Iterator<Class<?>> it = classes.iterator();
        for (Query query : queries) {
            request.add(this.requestFactory.searchRequest(query, it.next(), index));
        }
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ArrayList arrayList = new ArrayList(queries.size());
        int c = 0;
        Iterator<Class<?>> it1 = classes.iterator();
        for (Query query : queries) {
            Class<?> entityClass = it1.next();
            AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((EntityReader<?, Document>)this.elasticsearchConverter, entityClass, index);
            AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback(entityClass, index);
            SearchResponse response = items[c++].getResponse();
            arrayList.add((SearchHits<?>)callback.doWith(SearchDocumentResponse.from(response, documentCallback::doWith)));
        }
        return arrayList;
    }

    protected abstract MultiSearchResponse.Item[] getMultiSearchResult(MultiSearchRequest var1);

    @Override
    public Query matchAllQuery() {
        return new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).build();
    }

    @Override
    public Query idsQuery(List<String> ids) {
        Assert.notNull(ids, (String)"ids must not be null");
        return new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(ids.toArray(new String[0]))).build();
    }

    @Override
    protected String getVendor() {
        return "Elasticsearch";
    }

    @Override
    protected String getRuntimeLibraryVersion() {
        return Version.CURRENT.toString();
    }

    @Override
    @Deprecated
    public SearchResponse suggest(SuggestBuilder suggestion, Class<?> clazz) {
        return this.suggest(suggestion, this.getIndexCoordinatesFor(clazz));
    }
}

