/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.ResponseConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.Explanation;
import org.springframework.data.elasticsearch.core.document.NestedMetaData;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.mapping.MappingException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DocumentAdapters {
    @Nullable
    public static Document from(GetResponse source) {
        Assert.notNull((Object)source, (String)"GetResponse must not be null");
        if (!source.isExists()) {
            return null;
        }
        if (source.isSourceEmpty()) {
            return DocumentAdapters.fromDocumentFields((Iterable<DocumentField>)source, source.getIndex(), source.getId(), source.getVersion(), source.getSeqNo(), source.getPrimaryTerm());
        }
        Document document = Document.from(source.getSourceAsMap());
        document.setIndex(source.getIndex());
        document.setId(source.getId());
        document.setVersion(source.getVersion());
        document.setSeqNo(source.getSeqNo());
        document.setPrimaryTerm(source.getPrimaryTerm());
        return document;
    }

    @Nullable
    public static Document from(GetResult source) {
        Assert.notNull((Object)source, (String)"GetResult must not be null");
        if (!source.isExists()) {
            return null;
        }
        if (source.isSourceEmpty()) {
            return DocumentAdapters.fromDocumentFields((Iterable<DocumentField>)source, source.getIndex(), source.getId(), source.getVersion(), source.getSeqNo(), source.getPrimaryTerm());
        }
        Document document = Document.from(source.getSource());
        document.setIndex(source.getIndex());
        document.setId(source.getId());
        document.setVersion(source.getVersion());
        document.setSeqNo(source.getSeqNo());
        document.setPrimaryTerm(source.getPrimaryTerm());
        return document;
    }

    public static List<MultiGetItem<Document>> from(MultiGetResponse source) {
        Assert.notNull((Object)source, (String)"MultiGetResponse must not be null");
        return Arrays.stream(source.getResponses()).map(DocumentAdapters::from).collect(Collectors.toList());
    }

    public static MultiGetItem<Document> from(MultiGetItemResponse itemResponse) {
        MultiGetItem.Failure failure = ResponseConverter.getFailure(itemResponse);
        return MultiGetItem.of(itemResponse.isFailed() ? null : DocumentAdapters.from(itemResponse.getResponse()), failure);
    }

    public static SearchDocument from(SearchHit source) {
        Assert.notNull((Object)source, (String)"SearchHit must not be null");
        HashMap<String, List<String>> highlightFields = new HashMap<String, List<String>>(source.getHighlightFields().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.stream(((HighlightField)entry.getValue()).getFragments()).map(Text::string).collect(Collectors.toList()))));
        LinkedHashMap<String, SearchDocumentResponse> innerHits = new LinkedHashMap<String, SearchDocumentResponse>();
        Map sourceInnerHits = source.getInnerHits();
        if (sourceInnerHits != null) {
            sourceInnerHits.forEach((name, searchHits) -> innerHits.put((String)name, SearchDocumentResponse.from(searchHits, null, null)));
        }
        NestedMetaData nestedMetaData = DocumentAdapters.from(source.getNestedIdentity());
        Explanation explanation = DocumentAdapters.from(source.getExplanation());
        List<String> matchedQueries = DocumentAdapters.from(source.getMatchedQueries());
        BytesReference sourceRef = source.getSourceRef();
        if (sourceRef == null || sourceRef.length() == 0) {
            return new SearchDocumentAdapter(source.getScore(), source.getSortValues(), source.getFields(), highlightFields, DocumentAdapters.fromDocumentFields((Iterable<DocumentField>)source, source.getIndex(), source.getId(), source.getVersion(), source.getSeqNo(), source.getPrimaryTerm()), innerHits, nestedMetaData, explanation, matchedQueries);
        }
        Document document = Document.from(source.getSourceAsMap());
        document.setIndex(source.getIndex());
        document.setId(source.getId());
        if (source.getVersion() >= 0L) {
            document.setVersion(source.getVersion());
        }
        document.setSeqNo(source.getSeqNo());
        document.setPrimaryTerm(source.getPrimaryTerm());
        return new SearchDocumentAdapter(source.getScore(), source.getSortValues(), source.getFields(), highlightFields, document, innerHits, nestedMetaData, explanation, matchedQueries);
    }

    @Nullable
    private static Explanation from(@Nullable org.apache.lucene.search.Explanation explanation) {
        if (explanation == null) {
            return null;
        }
        ArrayList<Explanation> details = new ArrayList<Explanation>();
        for (org.apache.lucene.search.Explanation detail : explanation.getDetails()) {
            details.add(DocumentAdapters.from(detail));
        }
        return new Explanation(explanation.isMatch(), explanation.getValue().doubleValue(), explanation.getDescription(), details);
    }

    @Nullable
    private static NestedMetaData from(@Nullable SearchHit.NestedIdentity nestedIdentity) {
        if (nestedIdentity == null) {
            return null;
        }
        NestedMetaData child = DocumentAdapters.from(nestedIdentity.getChild());
        return NestedMetaData.of(nestedIdentity.getField().string(), nestedIdentity.getOffset(), child);
    }

    @Nullable
    private static List<String> from(@Nullable String[] matchedQueries) {
        return matchedQueries == null ? null : Arrays.asList(matchedQueries);
    }

    public static Document fromDocumentFields(Iterable<DocumentField> documentFields, String index, String id, long version, long seqNo, long primaryTerm) {
        if (documentFields instanceof Collection) {
            return new DocumentFieldAdapter((Collection)documentFields, index, id, version, seqNo, primaryTerm);
        }
        ArrayList<DocumentField> fields = new ArrayList<DocumentField>();
        for (DocumentField documentField : documentFields) {
            fields.add(documentField);
        }
        return new DocumentFieldAdapter(fields, index, id, version, seqNo, primaryTerm);
    }

    static class SearchDocumentAdapter
    implements SearchDocument {
        private final float score;
        private final Object[] sortValues;
        private final Map<String, List<Object>> fields = new HashMap<String, List<Object>>();
        private final Document delegate;
        private final Map<String, List<String>> highlightFields = new HashMap<String, List<String>>();
        private final Map<String, SearchDocumentResponse> innerHits = new HashMap<String, SearchDocumentResponse>();
        @Nullable
        private final NestedMetaData nestedMetaData;
        @Nullable
        private final Explanation explanation;
        @Nullable
        private final List<String> matchedQueries;

        SearchDocumentAdapter(float score, Object[] sortValues, Map<String, DocumentField> fields, Map<String, List<String>> highlightFields, Document delegate, Map<String, SearchDocumentResponse> innerHits, @Nullable NestedMetaData nestedMetaData, @Nullable Explanation explanation, @Nullable List<String> matchedQueries) {
            this.score = score;
            this.sortValues = sortValues;
            this.delegate = delegate;
            fields.forEach((? super K name, ? super V documentField) -> this.fields.put((String)name, documentField.getValues()));
            this.highlightFields.putAll(highlightFields);
            this.innerHits.putAll(innerHits);
            this.nestedMetaData = nestedMetaData;
            this.explanation = explanation;
            this.matchedQueries = matchedQueries;
        }

        @Override
        public SearchDocument append(String key, Object value) {
            this.delegate.append(key, value);
            return this;
        }

        @Override
        public float getScore() {
            return this.score;
        }

        @Override
        public Map<String, List<Object>> getFields() {
            return this.fields;
        }

        @Override
        public Object[] getSortValues() {
            return this.sortValues;
        }

        @Override
        public Map<String, List<String>> getHighlightFields() {
            return this.highlightFields;
        }

        @Override
        public String getIndex() {
            return this.delegate.getIndex();
        }

        @Override
        public boolean hasId() {
            return this.delegate.hasId();
        }

        @Override
        public String getId() {
            return this.delegate.getId();
        }

        @Override
        public void setId(String id) {
            this.delegate.setId(id);
        }

        @Override
        public boolean hasVersion() {
            return this.delegate.hasVersion();
        }

        @Override
        public long getVersion() {
            return this.delegate.getVersion();
        }

        @Override
        public void setVersion(long version) {
            this.delegate.setVersion(version);
        }

        @Override
        public boolean hasSeqNo() {
            return this.delegate.hasSeqNo();
        }

        @Override
        public long getSeqNo() {
            return this.delegate.getSeqNo();
        }

        @Override
        public void setSeqNo(long seqNo) {
            this.delegate.setSeqNo(seqNo);
        }

        @Override
        public boolean hasPrimaryTerm() {
            return this.delegate.hasPrimaryTerm();
        }

        @Override
        public long getPrimaryTerm() {
            return this.delegate.getPrimaryTerm();
        }

        @Override
        public void setPrimaryTerm(long primaryTerm) {
            this.delegate.setPrimaryTerm(primaryTerm);
        }

        @Override
        public Map<String, SearchDocumentResponse> getInnerHits() {
            return this.innerHits;
        }

        @Override
        @Nullable
        public NestedMetaData getNestedMetaData() {
            return this.nestedMetaData;
        }

        @Override
        @Nullable
        public <T> T get(Object key, Class<T> type) {
            return this.delegate.get(key, type);
        }

        @Override
        public String toJson() {
            return this.delegate.toJson();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public Object put(String key, Object value) {
            return this.delegate.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.delegate.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            this.delegate.putAll(m);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        @Nullable
        public Explanation getExplanation() {
            return this.explanation;
        }

        @Override
        @Nullable
        public List<String> getMatchedQueries() {
            return this.matchedQueries;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SearchDocumentAdapter)) {
                return false;
            }
            SearchDocumentAdapter that = (SearchDocumentAdapter)o;
            return Float.compare(that.score, this.score) == 0 && this.delegate.equals(that.delegate);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public void forEach(BiConsumer<? super String, ? super Object> action) {
            this.delegate.forEach(action);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.delegate.remove(key, value);
        }

        public String toString() {
            String id = this.hasId() ? this.getId() : "?";
            String version = this.hasVersion() ? Long.toString(this.getVersion()) : "?";
            return this.getClass().getSimpleName() + '@' + id + '#' + version + ' ' + this.toJson();
        }
    }

    static class DocumentFieldAdapter
    implements Document {
        private final Collection<DocumentField> documentFields;
        private final String index;
        private final String id;
        private final long version;
        private final long seqNo;
        private final long primaryTerm;

        DocumentFieldAdapter(Collection<DocumentField> documentFields, String index, String id, long version, long seqNo, long primaryTerm) {
            this.documentFields = documentFields;
            this.index = index;
            this.id = id;
            this.version = version;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
        }

        @Override
        public String getIndex() {
            return this.index;
        }

        @Override
        public boolean hasId() {
            return StringUtils.hasLength((String)this.id);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean hasVersion() {
            return this.version >= 0L;
        }

        @Override
        public long getVersion() {
            if (!this.hasVersion()) {
                throw new IllegalStateException("No version associated with this Document");
            }
            return this.version;
        }

        @Override
        public boolean hasSeqNo() {
            return true;
        }

        @Override
        public long getSeqNo() {
            if (!this.hasSeqNo()) {
                throw new IllegalStateException("No seq_no associated with this Document");
            }
            return this.seqNo;
        }

        @Override
        public boolean hasPrimaryTerm() {
            return true;
        }

        @Override
        public long getPrimaryTerm() {
            if (!this.hasPrimaryTerm()) {
                throw new IllegalStateException("No primary_term associated with this Document");
            }
            return this.primaryTerm;
        }

        @Override
        public int size() {
            return this.documentFields.size();
        }

        @Override
        public boolean isEmpty() {
            return this.documentFields.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            for (DocumentField documentField : this.documentFields) {
                if (!documentField.getName().equals(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            for (DocumentField documentField : this.documentFields) {
                Object fieldValue = DocumentFieldAdapter.getValue(documentField);
                if ((fieldValue == null || !fieldValue.equals(value)) && value != fieldValue) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Object get(Object key) {
            return this.documentFields.stream().filter(documentField -> documentField.getName().equals(key)).map(DocumentField::getValue).findFirst().orElse(null);
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            return this.documentFields.stream().map(DocumentField::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        @Override
        public Collection<Object> values() {
            return this.documentFields.stream().map(DocumentFieldAdapter::getValue).collect(Collectors.toList());
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.documentFields.stream().collect(Collectors.toMap(DocumentField::getName, DocumentFieldAdapter::getValue)).entrySet();
        }

        @Override
        public void forEach(BiConsumer<? super String, ? super Object> action) {
            Objects.requireNonNull(action);
            this.documentFields.forEach((? super T field) -> action.accept(field.getName(), DocumentFieldAdapter.getValue(field)));
        }

        @Override
        public String toJson() {
            JsonFactory nodeFactory = new JsonFactory();
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                JsonGenerator generator = nodeFactory.createGenerator((OutputStream)stream, JsonEncoding.UTF8);
                generator.writeStartObject();
                for (DocumentField value : this.documentFields) {
                    if (value.getValues().size() > 1) {
                        generator.writeArrayFieldStart(value.getName());
                        for (Object val : value.getValues()) {
                            generator.writeObject(val);
                        }
                        generator.writeEndArray();
                        continue;
                    }
                    generator.writeObjectField(value.getName(), value.getValue());
                }
                generator.writeEndObject();
                generator.flush();
                return new String(stream.toByteArray(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new MappingException("Cannot render JSON", (Throwable)e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + '@' + this.id + '#' + this.version + ' ' + this.toJson();
        }

        @Nullable
        private static Object getValue(DocumentField documentField) {
            if (documentField.getValues().isEmpty()) {
                return null;
            }
            if (documentField.getValues().size() == 1) {
                return documentField.getValue();
            }
            return documentField.getValues();
        }
    }
}

