/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.annotations.Highlight;
import org.springframework.data.elasticsearch.annotations.Query;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.HighlightQueryBuilder;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchEntityMetadata;
import org.springframework.data.elasticsearch.repository.query.SimpleElasticsearchEntityMetadata;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ElasticsearchQueryMethod
extends QueryMethod {
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
    @Nullable
    private ElasticsearchEntityMetadata<?> metadata;
    protected final Method method;
    @Nullable
    private final Query queryAnnotation;
    @Nullable
    private final Highlight highlightAnnotation;
    private final Lazy<HighlightQuery> highlightQueryLazy = Lazy.of(this::createAnnotatedHighlightQuery);

    public ElasticsearchQueryMethod(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory factory, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        super(method, repositoryMetadata, factory);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.method = method;
        this.mappingContext = mappingContext;
        this.queryAnnotation = (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class);
        this.highlightAnnotation = (Highlight)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Highlight.class);
        this.verifyCountQueryTypes();
    }

    protected void verifyCountQueryTypes() {
        TypeInformation returnType;
        if (this.hasCountQueryAnnotation() && (returnType = ClassTypeInformation.fromReturnTypeOf((Method)this.method)).getType() != Long.TYPE && !Long.class.isAssignableFrom(returnType.getType())) {
            throw new InvalidDataAccessApiUsageException("count query methods must return a Long");
        }
    }

    public boolean hasAnnotatedQuery() {
        return this.queryAnnotation != null;
    }

    public String getAnnotatedQuery() {
        return this.queryAnnotation.value();
    }

    public boolean hasAnnotatedHighlight() {
        return this.highlightAnnotation != null;
    }

    public HighlightQuery getAnnotatedHighlightQuery() {
        Assert.isTrue((boolean)this.hasAnnotatedHighlight(), (String)("no Highlight annotation present on " + this.getName()));
        return (HighlightQuery)this.highlightQueryLazy.get();
    }

    private HighlightQuery createAnnotatedHighlightQuery() {
        return new HighlightQueryBuilder(this.mappingContext).getHighlightQuery(this.highlightAnnotation, this.getDomainClass());
    }

    public ElasticsearchEntityMetadata<?> getEntityInformation() {
        if (this.metadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class domainClass = this.getDomainClass();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedObjectType)) {
                this.metadata = new SimpleElasticsearchEntityMetadata(domainClass, (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass));
            } else {
                ElasticsearchPersistentEntity returnedEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(returnedObjectType);
                ElasticsearchPersistentEntity managedEntity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
                returnedEntity = returnedEntity == null || returnedEntity.getType().isInterface() ? managedEntity : returnedEntity;
                ElasticsearchPersistentEntity collectionEntity = domainClass.isAssignableFrom(returnedObjectType) ? returnedEntity : managedEntity;
                this.metadata = new SimpleElasticsearchEntityMetadata(returnedEntity.getType(), collectionEntity);
            }
        }
        return this.metadata;
    }

    protected MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public boolean isSearchHitMethod() {
        Class<?> methodReturnType = this.method.getReturnType();
        if (SearchHits.class.isAssignableFrom(methodReturnType)) {
            return true;
        }
        try {
            ParameterizedType collectionTypeArgument;
            ParameterizedType methodGenericReturnType = (ParameterizedType)this.method.getGenericReturnType();
            if (this.isAllowedGenericType(methodGenericReturnType) && SearchHit.class.isAssignableFrom((Class)(collectionTypeArgument = (ParameterizedType)methodGenericReturnType.getActualTypeArguments()[0]).getRawType())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isSearchPageMethod() {
        return SearchPage.class.isAssignableFrom(this.methodReturnType());
    }

    public Class<?> methodReturnType() {
        return this.method.getReturnType();
    }

    protected boolean isAllowedGenericType(ParameterizedType methodGenericReturnType) {
        return Collection.class.isAssignableFrom((Class)methodGenericReturnType.getRawType()) || Stream.class.isAssignableFrom((Class)methodGenericReturnType.getRawType());
    }

    public boolean isNotSearchHitMethod() {
        return !this.isSearchHitMethod();
    }

    public boolean isNotSearchPageMethod() {
        return !this.isSearchPageMethod();
    }

    public boolean hasCountQueryAnnotation() {
        return this.queryAnnotation != null && this.queryAnnotation.count();
    }
}

