/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.search.aggregations.Aggregations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsImpl;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.NestedMetaData;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class SearchHitMapping<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchHitMapping.class);
    private final Class<T> type;
    private final ElasticsearchConverter converter;
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    private SearchHitMapping(Class<T> type, ElasticsearchConverter converter) {
        Assert.notNull(type, (String)"type is null");
        Assert.notNull((Object)converter, (String)"converter is null");
        this.type = type;
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    static <T> SearchHitMapping<T> mappingFor(Class<T> entityClass, ElasticsearchConverter converter) {
        return new SearchHitMapping<T>(entityClass, converter);
    }

    SearchHits<T> mapHits(SearchDocumentResponse searchDocumentResponse, List<T> contents) {
        return this.mapHitsFromResponse(searchDocumentResponse, contents);
    }

    SearchScrollHits<T> mapScrollHits(SearchDocumentResponse searchDocumentResponse, List<T> contents) {
        return this.mapHitsFromResponse(searchDocumentResponse, contents);
    }

    private SearchHitsImpl<T> mapHitsFromResponse(SearchDocumentResponse searchDocumentResponse, List<T> contents) {
        Assert.notNull((Object)searchDocumentResponse, (String)"searchDocumentResponse is null");
        Assert.notNull(contents, (String)"contents is null");
        Assert.isTrue((searchDocumentResponse.getSearchDocuments().size() == contents.size() ? 1 : 0) != 0, (String)"Count of documents must match the count of entities");
        long totalHits = searchDocumentResponse.getTotalHits();
        float maxScore = searchDocumentResponse.getMaxScore();
        String scrollId = searchDocumentResponse.getScrollId();
        ArrayList<SearchHit<T>> searchHits = new ArrayList<SearchHit<T>>();
        List<SearchDocument> searchDocuments = searchDocumentResponse.getSearchDocuments();
        for (int i = 0; i < searchDocuments.size(); ++i) {
            SearchDocument document = searchDocuments.get(i);
            T content = contents.get(i);
            SearchHit<T> hit = this.mapHit(document, content);
            searchHits.add(hit);
        }
        Aggregations aggregations = searchDocumentResponse.getAggregations();
        TotalHitsRelation totalHitsRelation = TotalHitsRelation.valueOf(searchDocumentResponse.getTotalHitsRelation());
        return new SearchHitsImpl(totalHits, totalHitsRelation, maxScore, scrollId, searchHits, aggregations);
    }

    SearchHit<T> mapHit(SearchDocument searchDocument, T content) {
        Assert.notNull((Object)searchDocument, (String)"searchDocument is null");
        Assert.notNull(content, (String)"content is null");
        return new SearchHit<T>(searchDocument.getIndex(), searchDocument.hasId() ? searchDocument.getId() : null, searchDocument.getRouting(), searchDocument.getScore(), searchDocument.getSortValues(), this.getHighlightsAndRemapFieldNames(searchDocument), this.mapInnerHits(searchDocument), searchDocument.getNestedMetaData(), searchDocument.getExplanation(), searchDocument.getMatchedQueries(), content);
    }

    @Nullable
    private Map<String, List<String>> getHighlightsAndRemapFieldNames(SearchDocument searchDocument) {
        Map<String, List<String>> highlightFields = searchDocument.getHighlightFields();
        if (highlightFields == null) {
            return null;
        }
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(this.type);
        if (persistentEntity == null) {
            return highlightFields;
        }
        return highlightFields.entrySet().stream().collect(Collectors.toMap(entry -> {
            ElasticsearchPersistentProperty property = persistentEntity.getPersistentPropertyWithFieldName((String)entry.getKey());
            return property != null ? property.getName() : (String)entry.getKey();
        }, Map.Entry::getValue));
    }

    private Map<String, SearchHits<?>> mapInnerHits(SearchDocument searchDocument) {
        LinkedHashMap innerHits = new LinkedHashMap();
        Map<String, SearchDocumentResponse> documentInnerHits = searchDocument.getInnerHits();
        if (documentInnerHits != null && documentInnerHits.size() > 0) {
            SearchHitMapping<SearchDocument> searchDocumentSearchHitMapping = SearchHitMapping.mappingFor(SearchDocument.class, this.converter);
            for (Map.Entry<String, SearchDocumentResponse> entry : documentInnerHits.entrySet()) {
                SearchDocumentResponse searchDocumentResponse = entry.getValue();
                SearchHitsImpl<SearchDocument> searchHits = super.mapHitsFromResponse(searchDocumentResponse, searchDocumentResponse.getSearchDocuments());
                SearchHits<?> mappedSearchHits = this.mapInnerDocuments(searchHits, this.type);
                innerHits.put(entry.getKey(), mappedSearchHits);
            }
        }
        return innerHits;
    }

    private SearchHits<?> mapInnerDocuments(SearchHits<SearchDocument> searchHits, Class<T> type) {
        if (searchHits.getTotalHits() == 0L) {
            return searchHits;
        }
        try {
            NestedMetaData nestedMetaData = searchHits.getSearchHit(0).getContent().getNestedMetaData();
            ElasticsearchPersistentEntityWithNestedMetaData persistentEntityWithNestedMetaData = this.getPersistentEntity((ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(type), nestedMetaData);
            if (persistentEntityWithNestedMetaData.entity != null) {
                ArrayList convertedSearchHits = new ArrayList();
                Class targetType = persistentEntityWithNestedMetaData.entity.getType();
                searchHits.getSearchHits().forEach(searchHit -> {
                    SearchDocument searchDocument = (SearchDocument)searchHit.getContent();
                    Object targetObject = this.converter.read(targetType, searchDocument);
                    convertedSearchHits.add(new SearchHit<Object>(searchDocument.getIndex(), searchDocument.getId(), searchDocument.getRouting(), searchDocument.getScore(), searchDocument.getSortValues(), searchDocument.getHighlightFields(), searchHit.getInnerHits(), persistentEntityWithNestedMetaData.nestedMetaData, searchHit.getExplanation(), searchHit.getMatchedQueries(), targetObject));
                });
                String scrollId = null;
                if (searchHits instanceof SearchHitsImpl) {
                    scrollId = ((SearchHitsImpl)searchHits).getScrollId();
                }
                return new SearchHitsImpl(searchHits.getTotalHits(), searchHits.getTotalHitsRelation(), searchHits.getMaxScore(), scrollId, convertedSearchHits, searchHits.getAggregations());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not map inner_hits", (Throwable)e);
        }
        return searchHits;
    }

    private ElasticsearchPersistentEntityWithNestedMetaData getPersistentEntity(@Nullable ElasticsearchPersistentEntity<?> persistentEntity, @Nullable NestedMetaData nestedMetaData) {
        NestedMetaData currentMetaData = nestedMetaData;
        LinkedList<NestedMetaData> mappedNestedMetaDatas = new LinkedList<NestedMetaData>();
        while (persistentEntity != null && currentMetaData != null) {
            ElasticsearchPersistentProperty persistentProperty = persistentEntity.getPersistentPropertyWithFieldName(currentMetaData.getField());
            if (persistentProperty == null) {
                persistentEntity = null;
                continue;
            }
            persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(persistentProperty.getActualType());
            mappedNestedMetaDatas.add(0, NestedMetaData.of(persistentProperty.getName(), currentMetaData.getOffset(), null));
            currentMetaData = currentMetaData.getChild();
        }
        NestedMetaData mappedNestedMetaData = mappedNestedMetaDatas.stream().reduce(null, (result, nmd) -> NestedMetaData.of(nmd.getField(), nmd.getOffset(), result));
        return new ElasticsearchPersistentEntityWithNestedMetaData(persistentEntity, mappedNestedMetaData);
    }

    private static class ElasticsearchPersistentEntityWithNestedMetaData {
        @Nullable
        private ElasticsearchPersistentEntity<?> entity;
        private NestedMetaData nestedMetaData;

        public ElasticsearchPersistentEntityWithNestedMetaData(@Nullable ElasticsearchPersistentEntity<?> entity, NestedMetaData nestedMetaData) {
            this.entity = entity;
            this.nestedMetaData = nestedMetaData;
        }
    }
}

