/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.RequestFactory;
import org.springframework.data.elasticsearch.core.ResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.MappingBuilder;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class AbstractDefaultIndexOperations
implements IndexOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDefaultIndexOperations.class);
    protected final ElasticsearchConverter elasticsearchConverter;
    protected final RequestFactory requestFactory;
    @Nullable
    protected final Class<?> boundClass;
    @Nullable
    private final IndexCoordinates boundIndex;

    public AbstractDefaultIndexOperations(ElasticsearchConverter elasticsearchConverter, Class<?> boundClass) {
        Assert.notNull(boundClass, (String)"boundClass may not be null");
        this.elasticsearchConverter = elasticsearchConverter;
        this.requestFactory = new RequestFactory(elasticsearchConverter);
        this.boundClass = boundClass;
        this.boundIndex = null;
    }

    public AbstractDefaultIndexOperations(ElasticsearchConverter elasticsearchConverter, IndexCoordinates boundIndex) {
        Assert.notNull((Object)boundIndex, (String)"boundIndex may not be null");
        this.elasticsearchConverter = elasticsearchConverter;
        this.requestFactory = new RequestFactory(elasticsearchConverter);
        this.boundClass = null;
        this.boundIndex = boundIndex;
    }

    protected Class<?> checkForBoundClass() {
        if (this.boundClass == null) {
            throw new InvalidDataAccessApiUsageException("IndexOperations are not bound");
        }
        return this.boundClass;
    }

    @Override
    public boolean create() {
        Document settings = null;
        if (this.boundClass != null) {
            settings = this.createSettings(this.boundClass);
        }
        return this.doCreate(this.getIndexCoordinates(), settings);
    }

    @Override
    public Document createSettings(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        Document settings = null;
        Setting setting = (Setting)AnnotatedElementUtils.findMergedAnnotation(clazz, Setting.class);
        if (setting != null) {
            settings = this.loadSettings(setting.settingPath());
        }
        if (settings == null) {
            settings = this.getRequiredPersistentEntity(clazz).getDefaultSettings();
        }
        return settings;
    }

    @Override
    public boolean create(Document settings) {
        return this.doCreate(this.getIndexCoordinates(), settings);
    }

    protected abstract boolean doCreate(IndexCoordinates var1, @Nullable Document var2);

    @Override
    public boolean delete() {
        return this.doDelete(this.getIndexCoordinates());
    }

    protected abstract boolean doDelete(IndexCoordinates var1);

    @Override
    public boolean exists() {
        return this.doExists(this.getIndexCoordinates());
    }

    protected abstract boolean doExists(IndexCoordinates var1);

    @Override
    public boolean putMapping(Document mapping) {
        return this.doPutMapping(this.getIndexCoordinates(), mapping);
    }

    protected abstract boolean doPutMapping(IndexCoordinates var1, Document var2);

    @Override
    public Map<String, Object> getMapping() {
        return this.doGetMapping(this.getIndexCoordinates());
    }

    protected abstract Map<String, Object> doGetMapping(IndexCoordinates var1);

    @Override
    public Map<String, Object> getSettings() {
        return this.getSettings(false);
    }

    @Override
    public Map<String, Object> getSettings(boolean includeDefaults) {
        return this.doGetSettings(this.getIndexCoordinates(), includeDefaults);
    }

    protected abstract Map<String, Object> doGetSettings(IndexCoordinates var1, boolean var2);

    @Override
    public void refresh() {
        this.doRefresh(this.getIndexCoordinates());
    }

    protected abstract void doRefresh(IndexCoordinates var1);

    @Override
    public boolean addAlias(AliasQuery query) {
        return this.doAddAlias(query, this.getIndexCoordinates());
    }

    protected abstract boolean doAddAlias(AliasQuery var1, IndexCoordinates var2);

    @Override
    public List<AliasMetadata> queryForAlias() {
        return this.doQueryForAlias(this.getIndexCoordinates());
    }

    protected abstract List<AliasMetadata> doQueryForAlias(IndexCoordinates var1);

    @Override
    public boolean removeAlias(AliasQuery query) {
        return this.doRemoveAlias(query, this.getIndexCoordinates());
    }

    protected abstract boolean doRemoveAlias(AliasQuery var1, IndexCoordinates var2);

    @Override
    public Map<String, Set<AliasData>> getAliases(String ... aliasNames) {
        Assert.notEmpty((Object[])aliasNames, (String)"aliasNames must not be empty");
        return this.doGetAliases(aliasNames, null);
    }

    @Override
    public Map<String, Set<AliasData>> getAliasesForIndex(String ... indexNames) {
        Assert.notEmpty((Object[])indexNames, (String)"indexNames must not be empty");
        return this.doGetAliases(null, indexNames);
    }

    protected abstract Map<String, Set<AliasData>> doGetAliases(@Nullable String[] var1, @Nullable String[] var2);

    @Override
    public Document createMapping() {
        return this.createMapping(this.checkForBoundClass());
    }

    @Override
    public Document createMapping(Class<?> clazz) {
        return this.buildMapping(clazz);
    }

    protected Document buildMapping(Class<?> clazz) {
        Mapping mappingAnnotation = (Mapping)AnnotatedElementUtils.findMergedAnnotation(clazz, Mapping.class);
        if (mappingAnnotation != null) {
            String mappingPath = mappingAnnotation.mappingPath();
            if (StringUtils.hasText((String)mappingPath)) {
                String mappings = ResourceUtil.readFileFromClasspath(mappingPath);
                if (StringUtils.hasText((String)mappings)) {
                    return Document.parse(mappings);
                }
            } else {
                LOGGER.info("mappingPath in @Mapping has to be defined. Building mappings using @Field");
            }
        }
        try {
            String mapping = new MappingBuilder(this.elasticsearchConverter).buildPropertyMapping(clazz);
            return Document.parse(mapping);
        }
        catch (Exception e) {
            throw new UncategorizedElasticsearchException("Failed to build mapping for " + clazz.getSimpleName(), e);
        }
    }

    @Override
    public Document createSettings() {
        return this.createSettings(this.checkForBoundClass());
    }

    ElasticsearchPersistentEntity<?> getRequiredPersistentEntity(Class<?> clazz) {
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    @Override
    public IndexCoordinates getIndexCoordinates() {
        return this.boundClass != null ? this.getIndexCoordinatesFor(this.boundClass) : Objects.requireNonNull(this.boundIndex);
    }

    public IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return this.getRequiredPersistentEntity(clazz).getIndexCoordinates();
    }

    @Nullable
    private Document loadSettings(String settingPath) {
        if (StringUtils.hasText((String)settingPath)) {
            String settingsFile = ResourceUtil.readFileFromClasspath(settingPath);
            if (StringUtils.hasText((String)settingsFile)) {
                return Document.parse(settingsFile);
            }
        } else {
            LOGGER.info("settingPath in @Setting has to be defined. Using default instead.");
        }
        return null;
    }
}

