/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.reactive;

import java.util.Collection;
import java.util.function.Consumer;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.indices.GetFieldMappingsRequest;
import org.elasticsearch.client.indices.GetFieldMappingsResponse;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesResponse;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.suggest.Suggest;
import org.springframework.data.elasticsearch.client.ElasticsearchHost;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveElasticsearchClient {
    default public Mono<Boolean> ping() {
        return this.ping(HttpHeaders.EMPTY);
    }

    public Mono<Boolean> ping(HttpHeaders var1);

    default public Mono<MainResponse> info() {
        return this.info(HttpHeaders.EMPTY);
    }

    public Mono<MainResponse> info(HttpHeaders var1);

    default public Mono<GetResult> get(Consumer<GetRequest> consumer) {
        GetRequest request = new GetRequest();
        consumer.accept(request);
        return this.get(request);
    }

    default public Mono<GetResult> get(GetRequest getRequest) {
        return this.get(HttpHeaders.EMPTY, getRequest);
    }

    public Mono<GetResult> get(HttpHeaders var1, GetRequest var2);

    default public Flux<GetResult> multiGet(Consumer<MultiGetRequest> consumer) {
        MultiGetRequest request = new MultiGetRequest();
        consumer.accept(request);
        return this.multiGet(request);
    }

    default public Flux<GetResult> multiGet(MultiGetRequest multiGetRequest) {
        return this.multiGet(HttpHeaders.EMPTY, multiGetRequest);
    }

    public Flux<GetResult> multiGet(HttpHeaders var1, MultiGetRequest var2);

    default public Mono<Boolean> exists(Consumer<GetRequest> consumer) {
        GetRequest request = new GetRequest();
        consumer.accept(request);
        return this.exists(request);
    }

    default public Mono<Boolean> exists(GetRequest getRequest) {
        return this.exists(HttpHeaders.EMPTY, getRequest);
    }

    public Mono<Boolean> exists(HttpHeaders var1, GetRequest var2);

    default public Mono<IndexResponse> index(Consumer<IndexRequest> consumer) {
        IndexRequest request = new IndexRequest();
        consumer.accept(request);
        return this.index(request);
    }

    default public Mono<IndexResponse> index(IndexRequest indexRequest) {
        return this.index(HttpHeaders.EMPTY, indexRequest);
    }

    public Mono<IndexResponse> index(HttpHeaders var1, IndexRequest var2);

    public Indices indices();

    default public Mono<UpdateResponse> update(Consumer<UpdateRequest> consumer) {
        UpdateRequest request = new UpdateRequest();
        consumer.accept(request);
        return this.update(request);
    }

    default public Mono<UpdateResponse> update(UpdateRequest updateRequest) {
        return this.update(HttpHeaders.EMPTY, updateRequest);
    }

    public Mono<UpdateResponse> update(HttpHeaders var1, UpdateRequest var2);

    default public Mono<DeleteResponse> delete(Consumer<DeleteRequest> consumer) {
        DeleteRequest request = new DeleteRequest();
        consumer.accept(request);
        return this.delete(request);
    }

    default public Mono<DeleteResponse> delete(DeleteRequest deleteRequest) {
        return this.delete(HttpHeaders.EMPTY, deleteRequest);
    }

    public Mono<DeleteResponse> delete(HttpHeaders var1, DeleteRequest var2);

    default public Mono<Long> count(Consumer<SearchRequest> consumer) {
        SearchRequest searchRequest = new SearchRequest();
        consumer.accept(searchRequest);
        return this.count(searchRequest);
    }

    default public Mono<Long> count(SearchRequest searchRequest) {
        return this.count(HttpHeaders.EMPTY, searchRequest);
    }

    public Mono<Long> count(HttpHeaders var1, SearchRequest var2);

    default public Flux<SearchHit> search(Consumer<SearchRequest> consumer) {
        SearchRequest request = new SearchRequest();
        consumer.accept(request);
        return this.search(request);
    }

    default public Flux<SearchHit> search(SearchRequest searchRequest) {
        return this.search(HttpHeaders.EMPTY, searchRequest);
    }

    public Flux<SearchHit> search(HttpHeaders var1, SearchRequest var2);

    default public Mono<SearchResponse> searchForResponse(SearchRequest searchRequest) {
        return this.searchForResponse(HttpHeaders.EMPTY, searchRequest);
    }

    public Mono<SearchResponse> searchForResponse(HttpHeaders var1, SearchRequest var2);

    default public Flux<Suggest> suggest(Consumer<SearchRequest> consumer) {
        SearchRequest request = new SearchRequest();
        consumer.accept(request);
        return this.suggest(request);
    }

    default public Flux<Suggest> suggest(SearchRequest searchRequest) {
        return this.suggest(HttpHeaders.EMPTY, searchRequest);
    }

    public Flux<Suggest> suggest(HttpHeaders var1, SearchRequest var2);

    default public Flux<Aggregation> aggregate(Consumer<SearchRequest> consumer) {
        Assert.notNull(consumer, (String)"consumer must not be null");
        SearchRequest request = new SearchRequest();
        consumer.accept(request);
        return this.aggregate(request);
    }

    default public Flux<Aggregation> aggregate(SearchRequest searchRequest) {
        return this.aggregate(HttpHeaders.EMPTY, searchRequest);
    }

    public Flux<Aggregation> aggregate(HttpHeaders var1, SearchRequest var2);

    default public Flux<SearchHit> scroll(SearchRequest searchRequest) {
        return this.scroll(HttpHeaders.EMPTY, searchRequest);
    }

    public Flux<SearchHit> scroll(HttpHeaders var1, SearchRequest var2);

    default public Mono<BulkByScrollResponse> deleteBy(Consumer<DeleteByQueryRequest> consumer) {
        DeleteByQueryRequest request = new DeleteByQueryRequest();
        consumer.accept(request);
        return this.deleteBy(request);
    }

    default public Mono<BulkByScrollResponse> deleteBy(DeleteByQueryRequest deleteRequest) {
        return this.deleteBy(HttpHeaders.EMPTY, deleteRequest);
    }

    public Mono<BulkByScrollResponse> deleteBy(HttpHeaders var1, DeleteByQueryRequest var2);

    default public Mono<BulkResponse> bulk(Consumer<BulkRequest> consumer) {
        BulkRequest request = new BulkRequest();
        consumer.accept(request);
        return this.bulk(request);
    }

    default public Mono<BulkResponse> bulk(BulkRequest bulkRequest) {
        return this.bulk(HttpHeaders.EMPTY, bulkRequest);
    }

    public Mono<BulkResponse> bulk(HttpHeaders var1, BulkRequest var2);

    public <T> Mono<T> execute(ReactiveElasticsearchClientCallback<T> var1);

    public Mono<Status> status();

    public static interface Indices {
        default public Mono<Boolean> existsIndex(Consumer<GetIndexRequest> consumer) {
            GetIndexRequest request = new GetIndexRequest();
            consumer.accept(request);
            return this.existsIndex(request);
        }

        default public Mono<Boolean> existsIndex(GetIndexRequest getIndexRequest) {
            return this.existsIndex(HttpHeaders.EMPTY, getIndexRequest);
        }

        public Mono<Boolean> existsIndex(HttpHeaders var1, GetIndexRequest var2);

        default public Mono<Boolean> deleteIndex(Consumer<DeleteIndexRequest> consumer) {
            DeleteIndexRequest request = new DeleteIndexRequest();
            consumer.accept(request);
            return this.deleteIndex(request);
        }

        default public Mono<Boolean> deleteIndex(DeleteIndexRequest deleteIndexRequest) {
            return this.deleteIndex(HttpHeaders.EMPTY, deleteIndexRequest);
        }

        public Mono<Boolean> deleteIndex(HttpHeaders var1, DeleteIndexRequest var2);

        default public Mono<Boolean> createIndex(Consumer<CreateIndexRequest> consumer) {
            CreateIndexRequest request = new CreateIndexRequest();
            consumer.accept(request);
            return this.createIndex(request);
        }

        default public Mono<Boolean> createIndex(CreateIndexRequest createIndexRequest) {
            return this.createIndex(HttpHeaders.EMPTY, createIndexRequest);
        }

        public Mono<Boolean> createIndex(HttpHeaders var1, CreateIndexRequest var2);

        default public Mono<Void> openIndex(Consumer<OpenIndexRequest> consumer) {
            OpenIndexRequest request = new OpenIndexRequest();
            consumer.accept(request);
            return this.openIndex(request);
        }

        default public Mono<Void> openIndex(OpenIndexRequest openIndexRequest) {
            return this.openIndex(HttpHeaders.EMPTY, openIndexRequest);
        }

        public Mono<Void> openIndex(HttpHeaders var1, OpenIndexRequest var2);

        default public Mono<Void> closeIndex(Consumer<CloseIndexRequest> consumer) {
            CloseIndexRequest request = new CloseIndexRequest();
            consumer.accept(request);
            return this.closeIndex(request);
        }

        default public Mono<Void> closeIndex(CloseIndexRequest closeIndexRequest) {
            return this.closeIndex(HttpHeaders.EMPTY, closeIndexRequest);
        }

        public Mono<Void> closeIndex(HttpHeaders var1, CloseIndexRequest var2);

        default public Mono<Void> refreshIndex(Consumer<RefreshRequest> consumer) {
            RefreshRequest request = new RefreshRequest(new String[0]);
            consumer.accept(request);
            return this.refreshIndex(request);
        }

        default public Mono<Void> refreshIndex(RefreshRequest refreshRequest) {
            return this.refreshIndex(HttpHeaders.EMPTY, refreshRequest);
        }

        public Mono<Void> refreshIndex(HttpHeaders var1, RefreshRequest var2);

        @Deprecated
        default public Mono<Boolean> updateMapping(Consumer<PutMappingRequest> consumer) {
            return this.putMapping(consumer);
        }

        @Deprecated
        default public Mono<Boolean> updateMapping(PutMappingRequest putMappingRequest) {
            return this.putMapping(putMappingRequest);
        }

        @Deprecated
        default public Mono<Boolean> updateMapping(HttpHeaders headers, PutMappingRequest putMappingRequest) {
            return this.putMapping(headers, putMappingRequest);
        }

        default public Mono<Boolean> putMapping(Consumer<PutMappingRequest> consumer) {
            PutMappingRequest request = new PutMappingRequest();
            consumer.accept(request);
            return this.putMapping(request);
        }

        default public Mono<Boolean> putMapping(PutMappingRequest putMappingRequest) {
            return this.putMapping(HttpHeaders.EMPTY, putMappingRequest);
        }

        public Mono<Boolean> putMapping(HttpHeaders var1, PutMappingRequest var2);

        default public Mono<Void> flushIndex(Consumer<FlushRequest> consumer) {
            FlushRequest request = new FlushRequest(new String[0]);
            consumer.accept(request);
            return this.flushIndex(request);
        }

        default public Mono<Void> flushIndex(FlushRequest flushRequest) {
            return this.flushIndex(HttpHeaders.EMPTY, flushRequest);
        }

        public Mono<Void> flushIndex(HttpHeaders var1, FlushRequest var2);

        default public Mono<GetSettingsResponse> getSettings(Consumer<GetSettingsRequest> consumer) {
            GetSettingsRequest request = new GetSettingsRequest();
            consumer.accept(request);
            return this.getSettings(request);
        }

        default public Mono<GetSettingsResponse> getSettings(GetSettingsRequest getSettingsRequest) {
            return this.getSettings(HttpHeaders.EMPTY, getSettingsRequest);
        }

        public Mono<GetSettingsResponse> getSettings(HttpHeaders var1, GetSettingsRequest var2);

        default public Mono<GetMappingsResponse> getMapping(Consumer<GetMappingsRequest> consumer) {
            GetMappingsRequest request = new GetMappingsRequest();
            consumer.accept(request);
            return this.getMapping(request);
        }

        default public Mono<GetMappingsResponse> getMapping(GetMappingsRequest getMappingsRequest) {
            return this.getMapping(HttpHeaders.EMPTY, getMappingsRequest);
        }

        public Mono<GetMappingsResponse> getMapping(HttpHeaders var1, GetMappingsRequest var2);

        default public Mono<GetFieldMappingsResponse> getFieldMapping(Consumer<GetFieldMappingsRequest> consumer) {
            GetFieldMappingsRequest request = new GetFieldMappingsRequest();
            consumer.accept(request);
            return this.getFieldMapping(request);
        }

        default public Mono<GetFieldMappingsResponse> getFieldMapping(GetFieldMappingsRequest getFieldMappingsRequest) {
            return this.getFieldMapping(HttpHeaders.EMPTY, getFieldMappingsRequest);
        }

        public Mono<GetFieldMappingsResponse> getFieldMapping(HttpHeaders var1, GetFieldMappingsRequest var2);

        default public Mono<Boolean> updateAliases(Consumer<IndicesAliasesRequest> consumer) {
            IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
            consumer.accept(indicesAliasesRequest);
            return this.updateAliases(indicesAliasesRequest);
        }

        default public Mono<Boolean> updateAliases(IndicesAliasesRequest indicesAliasesRequest) {
            return this.updateAliases(HttpHeaders.EMPTY, indicesAliasesRequest);
        }

        public Mono<Boolean> updateAliases(HttpHeaders var1, IndicesAliasesRequest var2);

        default public Mono<GetAliasesResponse> getAliases(Consumer<GetAliasesRequest> consumer) {
            GetAliasesRequest getAliasesRequest = new GetAliasesRequest();
            consumer.accept(getAliasesRequest);
            return this.getAliases(getAliasesRequest);
        }

        default public Mono<GetAliasesResponse> getAliases(GetAliasesRequest getAliasesRequest) {
            return this.getAliases(HttpHeaders.EMPTY, getAliasesRequest);
        }

        public Mono<GetAliasesResponse> getAliases(HttpHeaders var1, GetAliasesRequest var2);

        default public Mono<Boolean> putTemplate(Consumer<PutIndexTemplateRequest> consumer, String templateName) {
            PutIndexTemplateRequest putIndexTemplateRequest = new PutIndexTemplateRequest(templateName);
            consumer.accept(putIndexTemplateRequest);
            return this.putTemplate(putIndexTemplateRequest);
        }

        default public Mono<Boolean> putTemplate(PutIndexTemplateRequest putIndexTemplateRequest) {
            return this.putTemplate(HttpHeaders.EMPTY, putIndexTemplateRequest);
        }

        public Mono<Boolean> putTemplate(HttpHeaders var1, PutIndexTemplateRequest var2);

        default public Mono<GetIndexTemplatesResponse> getTemplate(Consumer<GetIndexTemplatesRequest> consumer) {
            GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(new String[0]);
            consumer.accept(getIndexTemplatesRequest);
            return this.getTemplate(getIndexTemplatesRequest);
        }

        default public Mono<GetIndexTemplatesResponse> getTemplate(GetIndexTemplatesRequest getIndexTemplatesRequest) {
            return this.getTemplate(HttpHeaders.EMPTY, getIndexTemplatesRequest);
        }

        public Mono<GetIndexTemplatesResponse> getTemplate(HttpHeaders var1, GetIndexTemplatesRequest var2);

        default public Mono<Boolean> existsTemplate(Consumer<IndexTemplatesExistRequest> consumer) {
            IndexTemplatesExistRequest indexTemplatesExistRequest = new IndexTemplatesExistRequest(new String[0]);
            consumer.accept(indexTemplatesExistRequest);
            return this.existsTemplate(indexTemplatesExistRequest);
        }

        default public Mono<Boolean> existsTemplate(IndexTemplatesExistRequest indexTemplatesExistRequest) {
            return this.existsTemplate(HttpHeaders.EMPTY, indexTemplatesExistRequest);
        }

        public Mono<Boolean> existsTemplate(HttpHeaders var1, IndexTemplatesExistRequest var2);

        default public Mono<Boolean> deleteTemplate(Consumer<DeleteIndexTemplateRequest> consumer) {
            DeleteIndexTemplateRequest deleteIndexTemplateRequest = new DeleteIndexTemplateRequest();
            consumer.accept(deleteIndexTemplateRequest);
            return this.deleteTemplate(deleteIndexTemplateRequest);
        }

        default public Mono<Boolean> deleteTemplate(DeleteIndexTemplateRequest deleteIndexTemplateRequest) {
            return this.deleteTemplate(HttpHeaders.EMPTY, deleteIndexTemplateRequest);
        }

        public Mono<Boolean> deleteTemplate(HttpHeaders var1, DeleteIndexTemplateRequest var2);
    }

    public static interface Status {
        public Collection<ElasticsearchHost> hosts();

        default public boolean isOk() {
            Collection<ElasticsearchHost> hosts = this.hosts();
            if (CollectionUtils.isEmpty(hosts)) {
                return false;
            }
            return this.hosts().stream().anyMatch(ElasticsearchHost::isOnline);
        }
    }

    public static interface ReactiveElasticsearchClientCallback<T> {
        public Mono<T> doWithClient(WebClient var1);
    }
}

