/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.core.document.MapDocument;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface Document
extends Map<String, Object> {
    public static Document create() {
        return new MapDocument();
    }

    public static Document from(Map<String, ? extends Object> map) {
        Assert.notNull(map, (String)"Map must not be null");
        if (map instanceof LinkedHashMap) {
            return new MapDocument(map);
        }
        return new MapDocument(new LinkedHashMap<String, Object>(map));
    }

    public static Document parse(String json) {
        Assert.notNull((Object)json, (String)"JSON must not be null");
        try {
            return new MapDocument((Map)MapDocument.OBJECT_MAPPER.readerFor(Map.class).readValue(json));
        }
        catch (IOException e) {
            throw new ConversionException("Cannot parse JSON", e);
        }
    }

    default public Document append(String key, Object value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        this.put(key, value);
        return this;
    }

    default public boolean hasId() {
        return false;
    }

    @Nullable
    default public String getIndex() {
        return null;
    }

    default public void setIndex(@Nullable String index) {
        throw new UnsupportedOperationException();
    }

    default public String getId() {
        throw new UnsupportedOperationException();
    }

    default public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    default public boolean hasVersion() {
        return false;
    }

    default public long getVersion() {
        throw new UnsupportedOperationException();
    }

    default public void setVersion(long version) {
        throw new UnsupportedOperationException();
    }

    default public boolean hasSeqNo() {
        return false;
    }

    default public long getSeqNo() {
        throw new UnsupportedOperationException();
    }

    default public void setSeqNo(long seqNo) {
        throw new UnsupportedOperationException();
    }

    default public boolean hasPrimaryTerm() {
        return false;
    }

    default public long getPrimaryTerm() {
        throw new UnsupportedOperationException();
    }

    default public void setPrimaryTerm(long primaryTerm) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    default public <T> T get(Object key, Class<T> type) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(type, (String)"Type must not be null");
        return type.cast(this.get(key));
    }

    @Nullable
    default public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    default public boolean getBooleanOrDefault(String key, boolean defaultValue) {
        return this.getBooleanOrDefault(key, () -> defaultValue);
    }

    default public boolean getBooleanOrDefault(String key, BooleanSupplier defaultValue) {
        Boolean value = this.getBoolean(key);
        return value == null ? defaultValue.getAsBoolean() : value.booleanValue();
    }

    @Nullable
    default public Integer getInt(String key) {
        return this.get(key, Integer.class);
    }

    default public int getIntOrDefault(String key, int defaultValue) {
        return this.getIntOrDefault(key, () -> defaultValue);
    }

    default public int getIntOrDefault(String key, IntSupplier defaultValue) {
        Integer value = this.getInt(key);
        return value == null ? defaultValue.getAsInt() : value.intValue();
    }

    @Nullable
    default public Long getLong(String key) {
        return this.get(key, Long.class);
    }

    default public long getLongOrDefault(String key, long defaultValue) {
        return this.getLongOrDefault(key, () -> defaultValue);
    }

    default public long getLongOrDefault(String key, LongSupplier defaultValue) {
        Long value = this.getLong(key);
        return value == null ? defaultValue.getAsLong() : value.longValue();
    }

    @Nullable
    default public String getString(String key) {
        return this.get(key, String.class);
    }

    default public String getStringOrDefault(String key, String defaultValue) {
        return this.getStringOrDefault(key, () -> defaultValue);
    }

    default public String getStringOrDefault(String key, Supplier<String> defaultValue) {
        String value = this.getString(key);
        return value == null ? defaultValue.get() : value;
    }

    default public <R> R transform(Function<? super Document, ? extends R> transformer) {
        Assert.notNull(transformer, (String)"transformer must not be null");
        return transformer.apply(this);
    }

    public String toJson();
}

