/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.springframework.data.elasticsearch.core.DocumentOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.SearchOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.lang.Nullable;

public interface ElasticsearchOperations
extends DocumentOperations,
SearchOperations {
    public IndexOperations indexOps(Class<?> var1);

    public IndexOperations indexOps(IndexCoordinates var1);

    public ElasticsearchConverter getElasticsearchConverter();

    public IndexCoordinates getIndexCoordinatesFor(Class<?> var1);

    @Nullable
    public String getEntityRouting(Object var1);

    @Deprecated
    default public boolean createIndex(String indexName) {
        return this.indexOps(IndexCoordinates.of(indexName)).create();
    }

    @Deprecated
    default public boolean createIndex(String indexName, Object settings) {
        return this.indexOps(IndexCoordinates.of(indexName)).create(this.getDocument(settings));
    }

    @Deprecated
    default public boolean createIndex(Class<?> clazz) {
        return this.indexOps(clazz).create();
    }

    @Deprecated
    default public boolean createIndex(Class<?> clazz, Object settings) {
        return this.indexOps(clazz).create(this.getDocument(settings));
    }

    @Deprecated
    default public boolean deleteIndex(Class<?> clazz) {
        return this.indexOps(clazz).delete();
    }

    @Deprecated
    default public boolean deleteIndex(String indexName) {
        return this.indexOps(IndexCoordinates.of(indexName)).delete();
    }

    @Deprecated
    default public boolean deleteIndex(IndexCoordinates index) {
        return this.indexOps(index).delete();
    }

    @Deprecated
    default public boolean indexExists(String indexName) {
        return this.indexOps(IndexCoordinates.of(indexName)).exists();
    }

    @Deprecated
    default public boolean indexExists(Class<?> clazz) {
        return this.indexOps(clazz).exists();
    }

    @Deprecated
    default public boolean putMapping(Class<?> clazz) {
        IndexOperations indexOps = this.indexOps(clazz);
        return indexOps.putMapping(clazz);
    }

    @Deprecated
    default public boolean putMapping(IndexCoordinates index, Class<?> clazz) {
        IndexOperations indexOps = this.indexOps(index);
        return indexOps.putMapping(clazz);
    }

    @Deprecated
    default public boolean putMapping(IndexCoordinates index, Object mappings) {
        return this.indexOps(index).putMapping(this.getDocument(mappings));
    }

    @Deprecated
    default public boolean putMapping(Class<?> clazz, Object mappings) {
        return this.indexOps(clazz).putMapping(this.getDocument(mappings));
    }

    @Deprecated
    default public Map<String, Object> getMapping(Class<?> clazz) {
        return this.indexOps(clazz).getMapping();
    }

    @Deprecated
    default public Map<String, Object> getMapping(IndexCoordinates index) {
        return this.indexOps(index).getMapping();
    }

    @Deprecated
    default public boolean addAlias(AliasQuery query, IndexCoordinates index) {
        return this.indexOps(index).addAlias(query);
    }

    @Deprecated
    default public boolean removeAlias(AliasQuery query, IndexCoordinates index) {
        return this.indexOps(index).removeAlias(query);
    }

    @Deprecated
    default public List<AliasMetadata> queryForAlias(String indexName) {
        return this.indexOps(IndexCoordinates.of(indexName)).queryForAlias();
    }

    @Deprecated
    default public Map<String, Object> getSetting(String indexName) {
        return this.indexOps(IndexCoordinates.of(indexName)).getSettings();
    }

    @Deprecated
    default public Map<String, Object> getSetting(Class<?> clazz) {
        return this.indexOps(clazz).getSettings();
    }

    @Deprecated
    default public Map<String, Object> getSettings(String indexName, boolean includeDefaults) {
        return this.indexOps(IndexCoordinates.of(indexName)).getSettings(includeDefaults);
    }

    default public Map<String, Object> getSettings(Class<?> clazz, boolean includeDefaults) {
        return this.indexOps(clazz).getSettings(includeDefaults);
    }

    @Deprecated
    default public void refresh(IndexCoordinates index) {
        this.indexOps(index).refresh();
    }

    @Deprecated
    default public void refresh(Class<?> clazz) {
        this.indexOps(clazz).refresh();
    }

    @Deprecated
    @Nullable
    default public Document getDocument(Object object) {
        Document document = null;
        try {
            if (object instanceof String) {
                document = Document.parse((String)object);
            } else if (object instanceof Map) {
                document = Document.from((Map)object);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("object cannot be converted to Document", e);
        }
        return document;
    }

    @Nullable
    default public String stringIdRepresentation(@Nullable Object id) {
        return Objects.toString(id, null);
    }
}

