/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractReactiveElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.support.StringQueryUtil;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class ReactiveElasticsearchStringQuery
extends AbstractReactiveElasticsearchRepositoryQuery {
    private final String query;

    public ReactiveElasticsearchStringQuery(ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getAnnotatedQuery(), queryMethod, operations, expressionParser, evaluationContextProvider);
    }

    public ReactiveElasticsearchStringQuery(String query, ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, operations);
        this.query = query;
    }

    @Override
    protected StringQuery createQuery(ElasticsearchParameterAccessor parameterAccessor) {
        String queryString = StringQueryUtil.replacePlaceholders(this.query, parameterAccessor);
        return new StringQuery(queryString);
    }

    @Override
    boolean isCountQuery() {
        return false;
    }

    @Override
    boolean isDeleteQuery() {
        return false;
    }

    @Override
    boolean isExistsQuery() {
        return false;
    }

    @Override
    boolean isLimiting() {
        return false;
    }
}

