/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.Map;
import org.elasticsearch.index.query.QueryBuilder;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AliasBuilder {
    @Nullable
    private String aliasName;
    @Nullable
    private QueryBuilder filterBuilder;
    @Nullable
    private Map<String, Object> filter;
    @Nullable
    private String searchRouting;
    @Nullable
    private String indexRouting;
    @Nullable
    private String routing;

    public AliasBuilder withAliasName(String aliasName) {
        this.aliasName = aliasName;
        return this;
    }

    public AliasBuilder withFilterBuilder(QueryBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public AliasBuilder withFilter(Map<String, Object> filter) {
        this.filter = filter;
        return this;
    }

    public AliasBuilder withSearchRouting(String searchRouting) {
        this.searchRouting = searchRouting;
        return this;
    }

    public AliasBuilder withIndexRouting(String indexRouting) {
        this.indexRouting = indexRouting;
        return this;
    }

    public AliasBuilder withRouting(String routing) {
        this.routing = routing;
        return this;
    }

    public AliasQuery build() {
        Assert.notNull((Object)this.aliasName, (String)"aliasName must not be null");
        AliasQuery aliasQuery = new AliasQuery(this.aliasName);
        aliasQuery.setFilterBuilder(this.filterBuilder);
        aliasQuery.setFilter(this.filter);
        aliasQuery.setSearchRouting(this.searchRouting);
        aliasQuery.setIndexRouting(this.indexRouting);
        aliasQuery.setRouting(this.routing);
        return aliasQuery;
    }
}

