/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.Arrays;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class IndexCoordinates {
    public static final String TYPE = "_doc";
    private final String[] indexNames;
    private final String[] typeNames;

    public static IndexCoordinates of(String ... indexNames) {
        Assert.notNull((Object)indexNames, (String)"indexNames must not be null");
        return new IndexCoordinates(indexNames, null);
    }

    private IndexCoordinates(String[] indexNames, @Nullable String[] typeNames) {
        Assert.notEmpty((Object[])indexNames, (String)"indexNames may not be null or empty");
        this.indexNames = indexNames;
        this.typeNames = typeNames != null ? typeNames : new String[]{};
    }

    @Deprecated
    public IndexCoordinates withTypes(String ... typeNames) {
        Assert.notEmpty((Object[])typeNames, (String)"typeNames must not be null");
        return new IndexCoordinates(this.indexNames, typeNames);
    }

    public String getIndexName() {
        return this.indexNames[0];
    }

    public String[] getIndexNames() {
        return Arrays.copyOf(this.indexNames, this.indexNames.length);
    }

    @Deprecated
    @Nullable
    public String getTypeName() {
        return this.typeNames.length > 0 ? this.typeNames[0] : null;
    }

    @Deprecated
    public String[] getTypeNames() {
        return Arrays.copyOf(this.typeNames, this.typeNames.length);
    }

    public String toString() {
        return "IndexCoordinates{indexNames=" + Arrays.toString(this.indexNames) + ", typeNames=" + Arrays.toString(this.typeNames) + '}';
    }
}

