/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.RequestFactory;
import org.springframework.data.elasticsearch.core.SearchHitMapping;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsIterator;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.StreamQueries;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.event.AfterConvertCallback;
import org.springframework.data.elasticsearch.core.event.AfterSaveCallback;
import org.springframework.data.elasticsearch.core.event.BeforeConvertCallback;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.elasticsearch.core.query.GetQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.IndexQueryBuilder;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;
import org.springframework.data.elasticsearch.support.VersionInfo;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.CloseableIterator;
import org.springframework.data.util.Streamable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractElasticsearchTemplate
implements ElasticsearchOperations,
ApplicationContextAware {
    @Nullable
    protected ElasticsearchConverter elasticsearchConverter;
    @Nullable
    protected RequestFactory requestFactory;
    @Nullable
    private EntityCallbacks entityCallbacks;

    protected void initialize(ElasticsearchConverter elasticsearchConverter) {
        Assert.notNull((Object)elasticsearchConverter, (String)"elasticsearchConverter must not be null.");
        this.elasticsearchConverter = elasticsearchConverter;
        this.requestFactory = new RequestFactory(elasticsearchConverter);
        VersionInfo.logVersions(this.getClusterVersion());
    }

    protected ElasticsearchConverter createElasticsearchConverter() {
        MappingElasticsearchConverter mappingElasticsearchConverter = new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext());
        mappingElasticsearchConverter.afterPropertiesSet();
        return mappingElasticsearchConverter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
        if (this.elasticsearchConverter instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.elasticsearchConverter).setApplicationContext(applicationContext);
        }
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"entityCallbacks must not be null");
        this.entityCallbacks = entityCallbacks;
    }

    @Override
    public <T> T save(T entity) {
        Assert.notNull(entity, (String)"entity must not be null");
        return this.save(entity, this.getIndexCoordinatesFor(entity.getClass()));
    }

    @Override
    public <T> T save(T entity, IndexCoordinates index) {
        Assert.notNull(entity, (String)"entity must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        IndexQuery query = this.getIndexQuery(entity);
        this.index(query, index);
        Object castResult = query.getObject();
        return (T)castResult;
    }

    @Override
    public <T> Iterable<T> save(Iterable<T> entities) {
        Assert.notNull(entities, (String)"entities must not be null");
        Iterator<T> iterator = entities.iterator();
        if (iterator.hasNext()) {
            return this.save(entities, this.getIndexCoordinatesFor(iterator.next().getClass()));
        }
        return entities;
    }

    @Override
    public <T> Iterable<T> save(Iterable<T> entities, IndexCoordinates index) {
        Assert.notNull(entities, (String)"entities must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        List<IndexQuery> indexQueries = Streamable.of(entities).stream().map(this::getIndexQuery).collect(Collectors.toList());
        if (!indexQueries.isEmpty()) {
            List<String> ids = this.bulkIndex(indexQueries, index);
            Iterator<String> idIterator = ids.iterator();
            entities.forEach(entity -> this.setPersistentEntityId(entity, (String)idIterator.next()));
        }
        return indexQueries.stream().map(IndexQuery::getObject).map(entity -> entity).collect(Collectors.toList());
    }

    @Override
    public <T> Iterable<T> save(T ... entities) {
        return this.save((Iterable<T>)Arrays.asList(entities));
    }

    @Override
    @Nullable
    public <T> T get(String id, Class<T> clazz) {
        return this.get(id, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    @Nullable
    public <T> T get(GetQuery query, Class<T> clazz, IndexCoordinates index) {
        return this.get(query.getId(), clazz, index);
    }

    @Override
    @Nullable
    public <T> T queryForObject(GetQuery query, Class<T> clazz) {
        return this.get(query.getId(), clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public boolean exists(String id, Class<?> clazz) {
        return this.exists(id, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public boolean exists(String id, IndexCoordinates index) {
        return this.doExists(id, index);
    }

    protected abstract boolean doExists(String var1, IndexCoordinates var2);

    @Override
    public String delete(String id, Class<?> entityType) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull(entityType, (String)"entityType must not be null");
        return this.delete(id, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public String delete(Object entity) {
        return this.delete(entity, this.getIndexCoordinatesFor(entity.getClass()));
    }

    @Override
    public String delete(Object entity, IndexCoordinates index) {
        return this.delete(this.getEntityId(entity), index);
    }

    @Override
    public long count(Query query, Class<?> clazz) {
        return this.count(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public <T> CloseableIterator<T> stream(Query query, Class<T> clazz, IndexCoordinates index) {
        return (CloseableIterator)SearchHitSupport.unwrapSearchHits(this.searchForStream(query, clazz, index));
    }

    @Override
    public <T> SearchHitsIterator<T> searchForStream(Query query, Class<T> clazz) {
        return this.searchForStream(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public <T> SearchHitsIterator<T> searchForStream(Query query, Class<T> clazz, IndexCoordinates index) {
        long scrollTimeInMillis = TimeValue.timeValueMinutes((long)1L).millis();
        return StreamQueries.streamResults(this.searchScrollStart(scrollTimeInMillis, query, clazz, index), scrollId -> this.searchScrollContinue((String)scrollId, scrollTimeInMillis, clazz, index), this::searchScrollClear);
    }

    @Override
    public <T> SearchHits<T> search(MoreLikeThisQuery query, Class<T> clazz) {
        return this.search(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public <T> SearchHits<T> search(MoreLikeThisQuery query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query.getId(), (String)"No document id defined for MoreLikeThisQuery");
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = this.requestFactory.moreLikeThisQueryBuilder(query, index);
        return this.search(new NativeSearchQueryBuilder().withQuery((QueryBuilder)moreLikeThisQueryBuilder).build(), clazz, index);
    }

    @Override
    public <T> List<SearchHits<T>> multiSearch(List<? extends Query> queries, Class<T> clazz, IndexCoordinates index) {
        MultiSearchRequest request = new MultiSearchRequest();
        for (Query query : queries) {
            request.add(this.requestFactory.searchRequest(query, clazz, index));
        }
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ReadSearchDocumentResponseCallback<T> readSearchDocumentResponseCallback = new ReadSearchDocumentResponseCallback<T>(clazz, index);
        ArrayList<SearchHits<T>> res = new ArrayList<SearchHits<T>>(queries.size());
        int c = 0;
        for (Query query : queries) {
            res.add((SearchHits<T>)readSearchDocumentResponseCallback.doWith(SearchDocumentResponse.from(items[c++].getResponse())));
        }
        return res;
    }

    @Override
    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes, IndexCoordinates index) {
        MultiSearchRequest request = new MultiSearchRequest();
        Iterator<Class<?>> it = classes.iterator();
        for (Query query : queries) {
            request.add(this.requestFactory.searchRequest(query, it.next(), index));
        }
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ArrayList arrayList = new ArrayList(queries.size());
        int c = 0;
        Iterator<Class<?>> it1 = classes.iterator();
        for (Query query : queries) {
            Class<?> entityClass = it1.next();
            ReadSearchDocumentResponseCallback callback = new ReadSearchDocumentResponseCallback(entityClass, index);
            SearchResponse response = items[c++].getResponse();
            arrayList.add((SearchHits<?>)callback.doWith(SearchDocumentResponse.from(response)));
        }
        return arrayList;
    }

    @Override
    public <T> SearchHits<T> search(Query query, Class<T> clazz) {
        return this.search(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    protected abstract <T> SearchScrollHits<T> searchScrollStart(long var1, Query var3, Class<T> var4, IndexCoordinates var5);

    protected abstract <T> SearchScrollHits<T> searchScrollContinue(@Nullable String var1, long var2, Class<T> var4, IndexCoordinates var5);

    protected void searchScrollClear(String scrollId) {
        this.searchScrollClear(Collections.singletonList(scrollId));
    }

    protected abstract void searchScrollClear(List<String> var1);

    protected abstract MultiSearchResponse.Item[] getMultiSearchResult(MultiSearchRequest var1);

    @Override
    public ElasticsearchConverter getElasticsearchConverter() {
        Assert.notNull((Object)this.elasticsearchConverter, (String)"elasticsearchConverter is not initialized.");
        return this.elasticsearchConverter;
    }

    public RequestFactory getRequestFactory() {
        Assert.notNull((Object)this.requestFactory, (String)"requestfactory not initialized");
        return this.requestFactory;
    }

    protected static String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }

    @Override
    public IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return this.getRequiredPersistentEntity(clazz).getIndexCoordinates();
    }

    protected List<String> checkForBulkOperationFailure(BulkResponse bulkResponse) {
        if (bulkResponse.hasFailures()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedDocuments.put(item.getId(), item.getFailureMessage());
            }
            throw new ElasticsearchException("Bulk operation has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + ']', failedDocuments);
        }
        return Stream.of(bulkResponse.getItems()).map(BulkItemResponse::getId).collect(Collectors.toList());
    }

    protected void setPersistentEntityId(Object entity, String id) {
        ElasticsearchPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
            persistentEntity.getPropertyAccessor(entity).setProperty((PersistentProperty)idProperty, (Object)id);
        }
    }

    ElasticsearchPersistentEntity<?> getRequiredPersistentEntity(Class<?> clazz) {
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    @Nullable
    private String getEntityId(Object entity) {
        ElasticsearchPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null) {
            return this.stringIdRepresentation(persistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)idProperty));
        }
        return null;
    }

    @Nullable
    private Long getEntityVersion(Object entity) {
        Object version;
        ElasticsearchPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        ElasticsearchPersistentProperty versionProperty = persistentEntity.getVersionProperty();
        if (versionProperty != null && (version = persistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)versionProperty)) != null && Long.class.isAssignableFrom(version.getClass())) {
            return (Long)version;
        }
        return null;
    }

    @Nullable
    private SeqNoPrimaryTerm getEntitySeqNoPrimaryTerm(Object entity) {
        Object seqNoPrimaryTerm;
        ElasticsearchPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        ElasticsearchPersistentProperty property = persistentEntity.getSeqNoPrimaryTermProperty();
        if (property != null && (seqNoPrimaryTerm = persistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)property)) != null && SeqNoPrimaryTerm.class.isAssignableFrom(seqNoPrimaryTerm.getClass())) {
            return (SeqNoPrimaryTerm)seqNoPrimaryTerm;
        }
        return null;
    }

    private <T> IndexQuery getIndexQuery(T entity) {
        String id = this.getEntityId(entity);
        if (id != null) {
            id = this.elasticsearchConverter.convertId(id);
        }
        IndexQueryBuilder builder = new IndexQueryBuilder().withId(id).withObject(entity);
        SeqNoPrimaryTerm seqNoPrimaryTerm = this.getEntitySeqNoPrimaryTerm(entity);
        if (seqNoPrimaryTerm != null) {
            builder.withSeqNoPrimaryTerm(seqNoPrimaryTerm);
        } else {
            builder.withVersion(this.getEntityVersion(entity));
        }
        return builder.build();
    }

    @Nullable
    protected abstract String getClusterVersion();

    protected <T> T maybeCallbackBeforeConvert(T entity, IndexCoordinates index) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, entity, new Object[]{index});
        }
        return entity;
    }

    protected void maybeCallbackBeforeConvertWithQuery(Object query, IndexCoordinates index) {
        IndexQuery indexQuery;
        Object queryObject;
        if (query instanceof IndexQuery && (queryObject = (indexQuery = (IndexQuery)query).getObject()) != null) {
            queryObject = this.maybeCallbackBeforeConvert(queryObject, index);
            indexQuery.setObject(queryObject);
        }
    }

    protected void maybeCallbackBeforeConvertWithQueries(List<?> queries, IndexCoordinates index) {
        queries.forEach(query -> this.maybeCallbackBeforeConvertWithQuery(query, index));
    }

    protected <T> T maybeCallbackAfterSave(T entity, IndexCoordinates index) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(AfterSaveCallback.class, entity, new Object[]{index});
        }
        return entity;
    }

    protected void maybeCallbackAfterSaveWithQuery(Object query, IndexCoordinates index) {
        IndexQuery indexQuery;
        Object queryObject;
        if (query instanceof IndexQuery && (queryObject = (indexQuery = (IndexQuery)query).getObject()) != null) {
            queryObject = this.maybeCallbackAfterSave(queryObject, index);
            indexQuery.setObject(queryObject);
        }
    }

    protected void maybeCallbackAfterSaveWithQueries(List<?> queries, IndexCoordinates index) {
        queries.forEach(query -> this.maybeCallbackAfterSaveWithQuery(query, index));
    }

    protected <T> T maybeCallbackAfterConvert(T entity, Document document, IndexCoordinates index) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(AfterConvertCallback.class, entity, new Object[]{document, index});
        }
        return entity;
    }

    protected class ReadSearchScrollDocumentResponseCallback<T>
    implements SearchDocumentResponseCallback<SearchScrollHits<T>> {
        private final DocumentCallback<T> delegate;
        private final Class<T> type;

        public ReadSearchScrollDocumentResponseCallback(Class<T> type, IndexCoordinates index) {
            Assert.notNull(type, (String)"type is null");
            this.delegate = new ReadDocumentCallback<T>(AbstractElasticsearchTemplate.this.elasticsearchConverter, type, index);
            this.type = type;
        }

        @Override
        public SearchScrollHits<T> doWith(SearchDocumentResponse response) {
            List entities = response.getSearchDocuments().stream().map(this.delegate::doWith).collect(Collectors.toList());
            return SearchHitMapping.mappingFor(this.type, AbstractElasticsearchTemplate.this.elasticsearchConverter.getMappingContext()).mapScrollHits(response, entities);
        }
    }

    protected class ReadSearchDocumentResponseCallback<T>
    implements SearchDocumentResponseCallback<SearchHits<T>> {
        private final DocumentCallback<T> delegate;
        private final Class<T> type;

        public ReadSearchDocumentResponseCallback(Class<T> type, IndexCoordinates index) {
            Assert.notNull(type, (String)"type is null");
            this.delegate = new ReadDocumentCallback<T>(AbstractElasticsearchTemplate.this.elasticsearchConverter, type, index);
            this.type = type;
        }

        @Override
        public SearchHits<T> doWith(SearchDocumentResponse response) {
            List entities = response.getSearchDocuments().stream().map(this.delegate::doWith).collect(Collectors.toList());
            return SearchHitMapping.mappingFor(this.type, AbstractElasticsearchTemplate.this.elasticsearchConverter.getMappingContext()).mapHits(response, entities);
        }
    }

    protected static interface SearchDocumentResponseCallback<T> {
        @NonNull
        public T doWith(@NonNull SearchDocumentResponse var1);
    }

    protected class ReadDocumentCallback<T>
    implements DocumentCallback<T> {
        private final EntityReader<? super T, Document> reader;
        private final Class<T> type;
        private final IndexCoordinates index;

        public ReadDocumentCallback(EntityReader<? super T, Document> reader, Class<T> type, IndexCoordinates index) {
            Assert.notNull(reader, (String)"reader is null");
            Assert.notNull(type, (String)"type is null");
            this.reader = reader;
            this.type = type;
            this.index = index;
        }

        @Override
        @Nullable
        public T doWith(@Nullable Document document) {
            if (document == null) {
                return null;
            }
            Object entity = this.reader.read(this.type, (Object)document);
            return (T)AbstractElasticsearchTemplate.this.maybeCallbackAfterConvert(entity, document, this.index);
        }
    }

    protected static interface DocumentCallback<T> {
        @Nullable
        public T doWith(@Nullable Document var1);
    }
}

